/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security;

import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import org.apache.harmony.security.fortress.PolicyUtils;

public class PolicyEntry {
    private final CodeSource cs;
    private final Principal[] principals;
    private final Collection<Permission> permissions;

    public PolicyEntry(CodeSource codeSource, Collection<? extends Principal> collection, Collection<? extends Permission> collection2) {
        this.cs = codeSource;
        this.principals = collection == null || collection.isEmpty() ? null : collection.toArray(new Principal[collection.size()]);
        this.permissions = collection2 == null || collection2.isEmpty() ? null : Collections.unmodifiableCollection(collection2);
    }

    public boolean impliesCodeSource(CodeSource codeSource) {
        if (this.cs == null) {
            return true;
        }
        if (codeSource == null) {
            return false;
        }
        return this.cs.implies(PolicyEntry.normalizeCodeSource(codeSource));
    }

    public boolean impliesPrincipals(Principal[] principalArray) {
        return PolicyUtils.matchSubset(this.principals, principalArray);
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isVoid() {
        return this.permissions == null || this.permissions.size() == 0;
    }

    private static CodeSource normalizeCodeSource(CodeSource codeSource) {
        try {
            URL uRL = codeSource.getLocation();
            if (null == uRL) {
                return codeSource;
            }
            if (!uRL.getProtocol().equals("file")) {
                return codeSource;
            }
            String string = uRL.toExternalForm();
            if (string == null || !string.contains(" ")) {
                return codeSource;
            }
            URL uRL2 = new URL(string.replaceAll(" ", "%20"));
            CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
            CodeSource codeSource2 = codeSignerArray == null ? new CodeSource(uRL2, codeSource.getCertificates()) : new CodeSource(uRL2, codeSignerArray);
            return codeSource2;
        }
        catch (Throwable throwable) {
            return codeSource;
        }
    }
}

