/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.HashSet;
import org.apache.harmony.security.SecurityUtils;
import org.apache.harmony.security.internal.nls.Messages;

public class DefaultPolicyScanner {
    protected StreamTokenizer configure(StreamTokenizer streamTokenizer) {
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        return streamTokenizer;
    }

    public void scanStream(Reader reader, Collection<GrantEntry> collection, KeystoreEntry[] keystoreEntryArray) throws IOException, InvalidFormatException {
        StreamTokenizer streamTokenizer = this.configure(new StreamTokenizer(reader));
        KeystoreEntry keystoreEntry = null;
        String string = null;
        block5: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -1: {
                    break block5;
                }
                case -3: {
                    if (SecurityUtils.equalsIgnoreCase("keystore", streamTokenizer.sval)) {
                        if (null == keystoreEntry) {
                            keystoreEntry = this.readKeystoreEntry(streamTokenizer);
                            continue block5;
                        }
                        this.skipOneLine(streamTokenizer);
                        continue block5;
                    }
                    if (SecurityUtils.equalsIgnoreCase("keystorePasswordURL", streamTokenizer.sval)) {
                        if (null == string) {
                            string = this.readKeystorePassword(streamTokenizer);
                            continue block5;
                        }
                        this.skipOneLine(streamTokenizer);
                        continue block5;
                    }
                    if (SecurityUtils.equalsIgnoreCase("grant", streamTokenizer.sval)) {
                        collection.add(this.readGrantEntry(streamTokenizer));
                        continue block5;
                    }
                    this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.89"));
                    continue block5;
                }
                case 59: {
                    continue block5;
                }
                default: {
                    this.handleUnexpectedToken(streamTokenizer);
                    continue block5;
                }
            }
            break;
        }
        if (keystoreEntry != null) {
            keystoreEntry.keypassword_url = string;
            keystoreEntryArray[0] = keystoreEntry;
        }
    }

    protected KeystoreEntry readKeystoreEntry(StreamTokenizer streamTokenizer) throws IOException, InvalidFormatException {
        KeystoreEntry keystoreEntry = new KeystoreEntry();
        if (streamTokenizer.nextToken() == 34) {
            keystoreEntry.url = streamTokenizer.sval;
            if (streamTokenizer.nextToken() == 34 || streamTokenizer.ttype == 44 && streamTokenizer.nextToken() == 34) {
                keystoreEntry.type = streamTokenizer.sval;
            } else {
                streamTokenizer.pushBack();
            }
        } else {
            this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.8A"));
        }
        return keystoreEntry;
    }

    protected String readKeystorePassword(StreamTokenizer streamTokenizer) throws IOException, InvalidFormatException {
        String string = null;
        if (streamTokenizer.nextToken() == 34) {
            string = streamTokenizer.sval;
            return string;
        }
        this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.8A"));
        return null;
    }

    protected GrantEntry readGrantEntry(StreamTokenizer streamTokenizer) throws IOException, InvalidFormatException {
        GrantEntry grantEntry = new GrantEntry();
        block5: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -3: {
                    if (SecurityUtils.equalsIgnoreCase("signedby", streamTokenizer.sval)) {
                        if (streamTokenizer.nextToken() == 34) {
                            grantEntry.signers = streamTokenizer.sval;
                            continue block5;
                        }
                        this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.8B"));
                        continue block5;
                    }
                    if (SecurityUtils.equalsIgnoreCase("codebase", streamTokenizer.sval)) {
                        if (streamTokenizer.nextToken() == 34) {
                            grantEntry.codebase = streamTokenizer.sval;
                            continue block5;
                        }
                        this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.8C"));
                        continue block5;
                    }
                    if (SecurityUtils.equalsIgnoreCase("principal", streamTokenizer.sval)) {
                        grantEntry.addPrincipal(this.readPrincipalEntry(streamTokenizer));
                        continue block5;
                    }
                    this.handleUnexpectedToken(streamTokenizer);
                    continue block5;
                }
                case 44: {
                    continue block5;
                }
                case 123: {
                    grantEntry.permissions = this.readPermissionEntries(streamTokenizer);
                    break block5;
                }
                default: {
                    streamTokenizer.pushBack();
                    break block5;
                }
            }
            break;
        }
        return grantEntry;
    }

    protected PrincipalEntry readPrincipalEntry(StreamTokenizer streamTokenizer) throws IOException, InvalidFormatException {
        PrincipalEntry principalEntry = new PrincipalEntry();
        if (streamTokenizer.nextToken() == -3) {
            principalEntry.klass = streamTokenizer.sval;
            streamTokenizer.nextToken();
        } else if (streamTokenizer.ttype == 42) {
            principalEntry.klass = "*";
            streamTokenizer.nextToken();
        }
        if (streamTokenizer.ttype == 34) {
            principalEntry.name = streamTokenizer.sval;
        } else if (streamTokenizer.ttype == 42) {
            principalEntry.name = "*";
        } else {
            this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.8D"));
        }
        return principalEntry;
    }

    protected void skipOneLine(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != 59) {
        }
    }

    protected Collection<PermissionEntry> readPermissionEntries(StreamTokenizer streamTokenizer) throws IOException, InvalidFormatException {
        HashSet<PermissionEntry> hashSet = new HashSet<PermissionEntry>();
        block5: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -3: {
                    if (SecurityUtils.equalsIgnoreCase("permission", streamTokenizer.sval)) {
                        PermissionEntry permissionEntry = new PermissionEntry();
                        if (streamTokenizer.nextToken() == -3) {
                            permissionEntry.klass = streamTokenizer.sval;
                            if (streamTokenizer.nextToken() == 34) {
                                permissionEntry.name = streamTokenizer.sval;
                                streamTokenizer.nextToken();
                            }
                            if (streamTokenizer.ttype == 44) {
                                streamTokenizer.nextToken();
                            }
                            if (streamTokenizer.ttype == 34) {
                                permissionEntry.actions = streamTokenizer.sval;
                                if (streamTokenizer.nextToken() == 44) {
                                    streamTokenizer.nextToken();
                                }
                            }
                            if (streamTokenizer.ttype == -3 && SecurityUtils.equalsIgnoreCase("signedby", streamTokenizer.sval)) {
                                if (streamTokenizer.nextToken() == 34) {
                                    permissionEntry.signers = streamTokenizer.sval;
                                } else {
                                    this.handleUnexpectedToken(streamTokenizer);
                                }
                            } else {
                                streamTokenizer.pushBack();
                            }
                            hashSet.add(permissionEntry);
                            continue block5;
                        }
                    }
                    this.handleUnexpectedToken(streamTokenizer, Messages.getString("security.8E"));
                    continue block5;
                }
                case 59: {
                    continue block5;
                }
                case 125: {
                    break block5;
                }
                default: {
                    this.handleUnexpectedToken(streamTokenizer);
                    continue block5;
                }
            }
            break;
        }
        return hashSet;
    }

    protected String composeStatus(StreamTokenizer streamTokenizer) {
        return streamTokenizer.toString();
    }

    protected final void handleUnexpectedToken(StreamTokenizer streamTokenizer, String string) throws InvalidFormatException {
        throw new InvalidFormatException(Messages.getString("security.8F", this.composeStatus(streamTokenizer), string));
    }

    protected final void handleUnexpectedToken(StreamTokenizer streamTokenizer) throws InvalidFormatException {
        throw new InvalidFormatException(Messages.getString("security.90", this.composeStatus(streamTokenizer)));
    }

    public static class PermissionEntry {
        public String klass;
        public String name;
        public String actions;
        public String signers;
    }

    public static class PrincipalEntry {
        public static final String WILDCARD = "*";
        public String klass;
        public String name;
    }

    public static class GrantEntry {
        public String signers;
        public String codebase;
        public Collection<PrincipalEntry> principals;
        public Collection<PermissionEntry> permissions;

        public void addPrincipal(PrincipalEntry principalEntry) {
            if (this.principals == null) {
                this.principals = new HashSet<PrincipalEntry>();
            }
            this.principals.add(principalEntry);
        }
    }

    public static class KeystoreEntry {
        public String url;
        public String type;
        public String keypassword_url;
    }

    public static class InvalidFormatException
    extends Exception {
        private static final long serialVersionUID = 5789786270390222184L;

        public InvalidFormatException(String string) {
            super(string);
        }
    }
}

