/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;

public class ProtectionDomain {
    private CodeSource codeSource;
    private PermissionCollection permissions;
    private ClassLoader classLoader;
    private Principal[] principals;
    private boolean dynamicPerms;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codeSource = codeSource;
        if (permissionCollection != null) {
            permissionCollection.setReadOnly();
        }
        this.permissions = permissionCollection;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.codeSource = codeSource;
        if (permissionCollection != null) {
            permissionCollection.setReadOnly();
        }
        this.permissions = permissionCollection;
        this.classLoader = classLoader;
        if (principalArray != null) {
            this.principals = new Principal[principalArray.length];
            System.arraycopy(principalArray, 0, this.principals, 0, this.principals.length);
        }
        this.dynamicPerms = true;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final CodeSource getCodeSource() {
        return this.codeSource;
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public final Principal[] getPrincipals() {
        if (this.principals == null) {
            return new Principal[0];
        }
        Principal[] principalArray = new Principal[this.principals.length];
        System.arraycopy(this.principals, 0, principalArray, 0, principalArray.length);
        return principalArray;
    }

    public boolean implies(Permission permission) {
        if (this.dynamicPerms && Policy.getAccessiblePolicy().implies(this, permission)) {
            return true;
        }
        return this.permissions == null ? false : this.permissions.implies(permission);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("ProtectionDomain\n");
        stringBuffer.append("CodeSource=").append(this.codeSource == null ? "<null>" : this.codeSource.toString()).append("\n");
        stringBuffer.append("ClassLoader=").append(this.classLoader == null ? "<null>" : this.classLoader.toString()).append("\n");
        if (this.principals == null || this.principals.length == 0) {
            stringBuffer.append("<no principals>\n");
        } else {
            stringBuffer.append("Principals: <\n");
            for (int i = 0; i < this.principals.length; ++i) {
                stringBuffer.append("\t").append(this.principals[i] == null ? "<null>" : ((Object)this.principals[i]).toString()).append("\n");
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("Permissions:\n");
        if (this.permissions == null) {
            stringBuffer.append("\t\t<no static permissions>\n");
        } else {
            stringBuffer.append("\t\tstatic: ").append(this.permissions.toString()).append("\n");
        }
        if (this.dynamicPerms) {
            if (Policy.isSet()) {
                PermissionCollection permissionCollection = Policy.getAccessiblePolicy().getPermissions(this);
                if (permissionCollection == null) {
                    stringBuffer.append("\t\t<no dynamic permissions>\n");
                } else {
                    stringBuffer.append("\t\tdynamic: ").append(permissionCollection.toString()).append("\n");
                }
            } else {
                stringBuffer.append("\t\t<no dynamic permissions>\n");
            }
        }
        return stringBuffer.toString();
    }
}

