/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PolicySpi;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import org.apache.harmony.security.fortress.DefaultPolicy;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.fortress.PolicyUtils;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class Policy {
    private static final String POLICY_PROVIDER = "policy.provider";
    private static final SecurityPermission SET_POLICY = new SecurityPermission("setPolicy");
    private static final SecurityPermission GET_POLICY = new SecurityPermission("getPolicy");
    private static Policy activePolicy;
    private static final String POLICYSERVICE = "Policy";
    private static Engine engine;
    private String type;
    private Parameters params;
    private Provider provider;
    private PolicySpi spiImpl;
    private static final String CREATE_POLICY = "createPolicy.";
    public static final PermissionCollection UNSUPPORTED_EMPTY_COLLECTION;

    public Policy() {
    }

    private Policy(PolicySpi policySpi, Provider provider, String string, Parameters parameters) {
        this.spiImpl = policySpi;
        this.provider = provider;
        this.type = string;
        this.params = parameters;
    }

    public static Policy getInstance(String string, Parameters parameters) throws NoSuchAlgorithmException {
        Policy.checkSecurityPermission(new SecurityPermission(CREATE_POLICY + string));
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Engine.ServiceResult serviceResult = engine.getInstance(string, parameters);
            return new PolicyDelegate((PolicySpi)serviceResult.spi, serviceResult.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (noSuchAlgorithmException.getCause() == null) {
                throw noSuchAlgorithmException;
            }
            throw new IllegalArgumentException(Messages.getString("security.1A7", parameters.toString()));
        }
    }

    public static Policy getInstance(String string, Parameters parameters, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Policy.checkSecurityPermission(new SecurityPermission(CREATE_POLICY + string));
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(Messages.getString("security.03", string2));
        }
        return Policy.getInstanceImpl(string, parameters, provider);
    }

    public static Policy getInstance(String string, Parameters parameters, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("security.04");
        }
        Policy.checkSecurityPermission(new SecurityPermission(CREATE_POLICY + string));
        return Policy.getInstanceImpl(string, parameters, provider);
    }

    private static void checkSecurityPermission(SecurityPermission securityPermission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(securityPermission);
        }
    }

    private static Policy getInstanceImpl(String string, Parameters parameters, Provider provider) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Engine.ServiceResult serviceResult = engine.getInstance(string, provider, parameters);
            return new PolicyDelegate((PolicySpi)serviceResult.spi, provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (noSuchAlgorithmException.getCause() == null) {
                throw noSuchAlgorithmException;
            }
            throw new IllegalArgumentException(Messages.getString("security.1A7", parameters.toString()));
        }
    }

    public Parameters getParameters() {
        return this.params;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.spiImpl == null ? UNSUPPORTED_EMPTY_COLLECTION : this.spiImpl.engineGetPermissions(codeSource);
    }

    public void refresh() {
        if (this.spiImpl != null) {
            this.spiImpl.engineRefresh();
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        Permissions permissions = new Permissions();
        if (protectionDomain != null) {
            Enumeration<Permission> enumeration;
            PermissionCollection permissionCollection;
            try {
                permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
                if (permissionCollection != UNSUPPORTED_EMPTY_COLLECTION) {
                    enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        permissions.add(enumeration.nextElement());
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if ((permissionCollection = protectionDomain.getPermissions()) != null) {
                enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    permissions.add(enumeration.nextElement());
                }
            }
        }
        return permissions;
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        return this.spiImpl == null ? this.defaultImplies(protectionDomain, permission) : this.spiImpl.engineImplies(protectionDomain, permission);
    }

    private boolean defaultImplies(ProtectionDomain protectionDomain, Permission permission) {
        if (protectionDomain == null && permission == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        if (protectionDomain != null) {
            PermissionCollection permissionCollection = this.getPermissions(protectionDomain);
            PermissionCollection permissionCollection2 = protectionDomain.getPermissions();
            if (permissionCollection2 != null) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
            try {
                bl = permissionCollection.implies(permission);
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
        }
        return bl;
    }

    public static Policy getPolicy() {
        Policy.checkSecurityPermission(GET_POLICY);
        return Policy.getAccessiblePolicy();
    }

    private static Policy getDefaultProvider() {
        final String string = AccessController.doPrivileged(new PolicyUtils.SecurityPropertyAccessor(POLICY_PROVIDER));
        if (string == null) {
            return new DefaultPolicy();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                try {
                    return (Policy)Class.forName(string, true, ClassLoader.getSystemClassLoader()).newInstance();
                }
                catch (Exception exception) {
                    return new DefaultPolicy();
                }
            }
        });
    }

    static boolean isSet() {
        return activePolicy != null;
    }

    static synchronized Policy getAccessiblePolicy() {
        if (activePolicy == null) {
            activePolicy = Policy.getDefaultProvider();
        }
        return activePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicy(Policy policy) {
        Policy.checkSecurityPermission(SET_POLICY);
        Class<Policy> clazz = Policy.class;
        synchronized (Policy.class) {
            activePolicy = policy;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        engine = new Engine(POLICYSERVICE);
        UNSUPPORTED_EMPTY_COLLECTION = new PermissionCollection(){
            private static final long serialVersionUID = 1L;

            @Override
            public void add(Permission permission) {
                throw new SecurityException(Messages.getString("security.1A5"));
            }

            @Override
            public Enumeration<Permission> elements() {
                return new Permissions().elements();
            }

            @Override
            public boolean implies(Permission permission) {
                if (permission == null) {
                    throw new NullPointerException();
                }
                return false;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        };
    }

    public static interface Parameters {
    }

    private static class PolicyDelegate
    extends Policy {
        public PolicyDelegate(PolicySpi policySpi, Provider provider, String string, Parameters parameters) {
            super(policySpi, provider, string, parameters);
        }
    }
}

