/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PermissionsHash;
import java.security.UnresolvedPermission;
import java.security.UnresolvedPermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.harmony.security.internal.nls.Messages;

public final class Permissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 4858622370623524688L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", Hashtable.class), new ObjectStreamField("allPermission", PermissionCollection.class)};
    private transient Map klasses = new HashMap();
    private boolean allEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException(Messages.getString("security.15"));
        }
        if (permission == null) {
            throw new NullPointerException(Messages.getString("security.20"));
        }
        Class<?> clazz = permission.getClass();
        PermissionCollection permissionCollection = (PermissionCollection)this.klasses.get(clazz);
        if (permissionCollection == null) {
            Map map = this.klasses;
            synchronized (map) {
                permissionCollection = (PermissionCollection)this.klasses.get(clazz);
                if (permissionCollection == null) {
                    permissionCollection = permission.newPermissionCollection();
                    if (permissionCollection == null) {
                        permissionCollection = new PermissionsHash();
                    }
                    this.klasses.put(clazz, permissionCollection);
                }
            }
        }
        permissionCollection.add(permission);
        if (clazz == AllPermission.class) {
            this.allEnabled = true;
        }
    }

    @Override
    public Enumeration<Permission> elements() {
        return new MetaEnumeration(this.klasses.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (permission == null) {
            throw new NullPointerException(Messages.getString("security.21"));
        }
        if (this.allEnabled) {
            return true;
        }
        Class<?> clazz = permission.getClass();
        PermissionCollection permissionCollection = null;
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.klasses.get(UnresolvedPermission.class);
        if (unresolvedPermissionCollection != null && unresolvedPermissionCollection.hasUnresolved(permission)) {
            Map map = this.klasses;
            synchronized (map) {
                permissionCollection = (PermissionCollection)this.klasses.get(clazz);
                try {
                    permissionCollection = unresolvedPermissionCollection.resolveCollection(permission, permissionCollection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (permissionCollection != null) {
                    this.klasses.put(clazz, permissionCollection);
                    if (clazz == AllPermission.class) {
                        this.allEnabled = true;
                    }
                }
            }
        }
        permissionCollection = (PermissionCollection)this.klasses.get(clazz);
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Map map = (Map)getField.get("perms", null);
        this.klasses = new HashMap();
        Map map2 = this.klasses;
        synchronized (map2) {
            for (Map.Entry entry : map.entrySet()) {
                PermissionCollection permissionCollection;
                Class clazz = (Class)entry.getKey();
                if (clazz != (permissionCollection = (PermissionCollection)entry.getValue()).elements().nextElement().getClass()) {
                    throw new InvalidObjectException(Messages.getString("security.22"));
                }
                this.klasses.put(clazz, permissionCollection);
            }
        }
        boolean bl = this.allEnabled = getField.get("allPermission", null) != null;
        if (this.allEnabled && !this.klasses.containsKey(AllPermission.class)) {
            throw new InvalidObjectException(Messages.getString("security.23"));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("perms", new Hashtable(this.klasses));
        putField.put("allPermission", this.allEnabled ? this.klasses.get(AllPermission.class) : null);
        objectOutputStream.writeFields();
    }

    static final class MetaEnumeration
    implements Enumeration {
        private Iterator pcIter;
        private Enumeration current;

        public MetaEnumeration(Iterator iterator) {
            this.pcIter = iterator;
            this.current = this.getNextEnumeration();
        }

        private Enumeration getNextEnumeration() {
            while (this.pcIter.hasNext()) {
                Enumeration<Permission> enumeration = ((PermissionCollection)this.pcIter.next()).elements();
                if (!enumeration.hasMoreElements()) continue;
                return enumeration;
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current != null) {
                Object e = this.current.nextElement();
                if (!this.current.hasMoreElements()) {
                    this.current = this.getNextEnumeration();
                }
                return e;
            }
            throw new NoSuchElementException(Messages.getString("security.17"));
        }
    }
}

