/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.harmony.security.internal.nls.Messages;

final class AllPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -4023755556366636806L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("all_allowed", Boolean.TYPE)};
    private transient Permission all;

    AllPermissionCollection() {
    }

    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException(Messages.getString("security.15"));
        }
        if (!(permission instanceof AllPermission)) {
            throw new IllegalArgumentException(Messages.getString("security.16", permission));
        }
        this.all = permission;
    }

    @Override
    public Enumeration<Permission> elements() {
        return new SingletonEnumeration<Permission>(this.all);
    }

    @Override
    public boolean implies(Permission permission) {
        return this.all != null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("all_allowed", this.all != null);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        if (getField.get("all_allowed", false)) {
            this.all = new AllPermission();
        }
    }

    static final class SingletonEnumeration<E>
    implements Enumeration<E> {
        private E element;

        public SingletonEnumeration(E e) {
            this.element = e;
        }

        @Override
        public boolean hasMoreElements() {
            return this.element != null;
        }

        @Override
        public E nextElement() {
            if (this.element == null) {
                throw new NoSuchElementException(Messages.getString("security.17"));
            }
            E e = this.element;
            this.element = null;
            return e;
        }
    }
}

