/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.rowset.serial.SerialException;
import org.apache.harmony.sql.internal.nls.Messages;

public class SerialRef
implements Ref,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4727123500609662274L;
    private String baseTypeName;
    private Object object;
    private Ref reference;

    public SerialRef(Ref ref) throws SerialException, SQLException {
        if (ref == null) {
            throw new SQLException(Messages.getString("sql.9"));
        }
        this.reference = ref;
        this.object = ref;
        this.baseTypeName = ref.getBaseTypeName();
        if (this.baseTypeName == null) {
            throw new SQLException(Messages.getString("sql.10"));
        }
    }

    @Override
    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    @Override
    public Object getObject() throws SerialException {
        try {
            return this.reference.getObject();
        }
        catch (SQLException sQLException) {
            throw new SerialException(Messages.getString("sql.11", sQLException.getMessage()));
        }
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws SerialException {
        return map.get(this.object);
    }

    @Override
    public void setObject(Object object) throws SerialException {
        try {
            this.reference.setObject(object);
            this.object = object;
        }
        catch (SQLException sQLException) {
            throw new SerialException(Messages.getString("sql.11", sQLException.getMessage()));
        }
    }
}

