/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ZOSdump
extends Dump {
    static boolean bCompounded = true;
    static int ascbasxb = 0;
    static final int DR1 = -992349888;
    static final int DR2 = -992349632;
    static boolean verbose = false;
    static final int HEADERSIZE = 64;
    static final int CHUNKSIZE = 4096;
    static final int BLOCKSIZE = 4160;
    static boolean oldFormat = false;
    static int levelCount = 0;
    static int savedAsid;
    private static long[] numberOfMemoryRanges;
    private static long numberOfAddressSpaces;
    private Vector foundAsids = new Vector();
    private int[] asidArray;
    private static int currentAsidPosition;
    private static int prevAsidPosition;
    private static int asid01Position;
    private HashMap addressSpaceModes = new HashMap();
    private static long currentAddress;
    private static CompoundedMemoryRanges compoundedMemory;
    private static MemoryRange[][] memoryRanges;

    public ZOSdump(String filename) throws FileNotFoundException {
        super(filename);
        bIsLittleEndian = false;
        this.setSystemType(3);
        try {
            long current_pos = 0L;
            this.seek(current_pos);
            boolean bFinished = false;
            boolean bFirstAsid = true;
            AsidMemoryRanges ongoingAsid = null;
            int prevAsid = 0;
            if (bCompounded) {
                compoundedMemory = new CompoundedMemoryRanges();
            }
            while (!bFinished) {
                this.seek(current_pos);
                byte[] b = new byte[28];
                this.readFully(b);
                int sig = this.getInt(b, 0);
                if (sig == -992349888 || sig == -992349632) {
                    int asid = this.getInt(b, 3);
                    int highAddress = 0;
                    if (!oldFormat) {
                        highAddress = this.getInt(b, 5);
                    }
                    int lowAddress = this.getInt(b, oldFormat ? 5 : 6);
                    long address = highAddress;
                    address <<= 32;
                    address += (long)lowAddress;
                    if (verbose) {
                        System.err.println("Asid: 0x" + Integer.toHexString(asid) + "   Address: 0x" + Long.toHexString(address) + "   Offset: 0x" + Long.toHexString(current_pos));
                    }
                    if (!bCompounded) {
                        if (bFirstAsid) {
                            ++numberOfAddressSpaces;
                            prevAsid = asid;
                            bFirstAsid = false;
                            ongoingAsid = new AsidMemoryRanges(asid);
                            this.foundAsids.add(ongoingAsid);
                        }
                        if (asid != prevAsid) {
                            boolean bFound = false;
                            for (int i = 0; !bFound && i < this.foundAsids.size(); ++i) {
                                int knownAsid = ((AsidMemoryRanges)this.foundAsids.get((int)i)).asid;
                                if (knownAsid != asid) continue;
                                bFound = true;
                                ongoingAsid = (AsidMemoryRanges)this.foundAsids.get(i);
                            }
                            if (!bFound) {
                                ++numberOfAddressSpaces;
                                ongoingAsid = new AsidMemoryRanges(asid);
                                this.foundAsids.add(ongoingAsid);
                            }
                            prevAsid = asid;
                        }
                    }
                    if (address > 0xFFFFFFFFL) {
                        this.bIs32Bit = false;
                        this.addressSpaceModes.put(new Integer(asid), new Integer(64));
                    } else if (!this.addressSpaceModes.containsKey(new Integer(asid))) {
                        this.addressSpaceModes.put(new Integer(asid), new Integer(31));
                    }
                    MemoryRange mr = new MemoryRange(address, current_pos, 4096L, asid);
                    if (bCompounded) {
                        if (mr.getAsid() != 0) {
                            compoundedMemory.addRange(mr);
                        }
                    } else {
                        ongoingAsid.addRange(mr);
                    }
                } else {
                    System.err.println("Unrecognised block type (0x" + Integer.toHexString(sig) + ") at position 0x" + Long.toHexString(this.getFilePointer()));
                }
                current_pos += 4160L;
                try {
                    this.seek(current_pos);
                }
                catch (IOException ioe) {
                    bFinished = true;
                }
            }
        }
        catch (EOFException eof) {
        }
        catch (IOException ioe) {
            System.err.println("An unexpected IOException:" + ioe.toString());
        }
        if (bCompounded) {
            this.consolidateMemoryCompounded();
        } else {
            this.consolidateMemory();
        }
        if (verbose) {
            for (int i = 0; i < memoryRanges.length; ++i) {
                if (!bCompounded) {
                    System.err.println("\n Asid: 0x" + Integer.toHexString(this.asidArray[i]));
                }
                for (int j = 0; j < memoryRanges[i].length; ++j) {
                    long v = memoryRanges[i][j].getVaddr();
                    long s = memoryRanges[i][j].getSize();
                    long o = memoryRanges[i][j].getFileoffset();
                    System.err.println("  #" + j + "\tAddr: 0x" + Long.toHexString(v) + "   \tSize: 0x" + Long.toHexString(s) + "   \tOffset: 0x" + Long.toHexString(o));
                }
            }
            for (Map.Entry entry : this.addressSpaceModes.entrySet()) {
                System.err.println("ASID = " + entry.getKey() + " address size = " + entry.getValue());
            }
        }
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("ZOSAS", this, 0);
        J9Process proc = new J9Process("ZOSProc", 0);
        this.addressSpaces[0].addProcess(proc);
    }

    protected MemoryRange[] getRawMemoryRanges() {
        if (bCompounded) {
            return memoryRanges[0];
        }
        if (-1 == currentAsidPosition) {
            return null;
        }
        if (prevAsidPosition != currentAsidPosition) {
            prevAsidPosition = currentAsidPosition;
            this.refreshMemoryRanges();
        }
        return memoryRanges[currentAsidPosition];
    }

    protected byte[] getRawMemoryBytes(long vaddr, int size) {
        byte[] extraBytes;
        long offset_into_range;
        int whichRange;
        if (vaddr == 0L) {
            return null;
        }
        int piecesOf64 = 0;
        MemoryRange[] mr = this.getMemoryRanges();
        if (++levelCount == 1) {
            whichRange = this.findWhichMemoryRange(vaddr);
            if (whichRange != -1) {
                savedAsid = mr[whichRange].getAsid();
            }
        } else {
            whichRange = this.findWhichMemoryRange(vaddr, savedAsid);
        }
        if (-1 == whichRange) {
            --levelCount;
            return null;
        }
        int asidPosition = currentAsidPosition;
        if (bCompounded) {
            asidPosition = 0;
        }
        long start = memoryRanges[asidPosition][whichRange].getVaddr();
        long saved_offset_into_range = offset_into_range = vaddr - start;
        piecesOf64 = (int)(offset_into_range / 4096L + 1L);
        if (piecesOf64 > 0) {
            offset_into_range += (long)(64 * piecesOf64);
        }
        long mylen = size;
        byte[] b = null;
        int coverage = (int)(offset_into_range + mylen - (long)((piecesOf64 - 1) * 4096)) / 4096;
        mylen += (long)(coverage * 64);
        try {
            long where_to_read_from = memoryRanges[asidPosition][whichRange].getFileoffset() + offset_into_range;
            int howmany = (int)mylen;
            long available = memoryRanges[asidPosition][whichRange].getSize() - offset_into_range;
            if (mylen > (available += 64L * (memoryRanges[asidPosition][whichRange].getSize() / 4096L))) {
                howmany = (int)available;
            }
            b = new byte[howmany];
            this.seek(where_to_read_from);
            this.read(b, 0, howmany);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (coverage > 0) {
            byte[] b1 = new byte[b.length];
            int posOld = 0;
            int posNew = 0;
            boolean transferred = false;
            for (int i = 0; i < coverage + 1; ++i) {
                int n;
                if (0 == i) {
                    n = (int)(4096L - saved_offset_into_range % 4096L);
                    if (n > b.length) {
                        n = b.length;
                    }
                    System.arraycopy(b, 0, b1, 0, n);
                    posNew = n;
                    posOld = n;
                    continue;
                }
                n = b.length - (posOld += 64);
                if (n > 4096) {
                    n = 4096;
                }
                if (n > 0) {
                    System.arraycopy(b, posOld, b1, posNew, n);
                }
                posNew += n;
                posOld += n;
            }
            if (b1.length > size) {
                byte[] baFinal = new byte[size];
                System.arraycopy(b1, 0, baFinal, 0, size);
                --levelCount;
                return baFinal;
            }
            b = b1;
        }
        if (b.length < size && null != (extraBytes = this.getRawMemoryBytes(vaddr + (long)b.length, size - b.length))) {
            byte[] baFinal = new byte[b.length + extraBytes.length];
            System.arraycopy(b, 0, baFinal, 0, b.length);
            System.arraycopy(extraBytes, 0, baFinal, b.length, extraBytes.length);
            b = baFinal;
        }
        --levelCount;
        return b;
    }

    public long seekToMemoryAddress(long vaddr) {
        long numAvailable = 0L;
        boolean bRet = false;
        currentAddress = vaddr;
        int range = this.findWhichMemoryRange(vaddr);
        if (-1 != range) {
            int asidPosition = 0;
            if (range >= 1000000) {
                asidPosition = asid01Position;
                range -= 1000000;
            }
            long offsetIntoRange = vaddr - memoryRanges[asidPosition][range].getVaddr();
            numAvailable = memoryRanges[0][range].getSize() - offsetIntoRange;
        }
        return numAvailable;
    }

    public static boolean isSupportedDump(RandomAccessFile raf) {
        boolean bRet;
        block6: {
            int sig = 0;
            bRet = false;
            try {
                raf.seek(0L);
                sig = raf.readInt();
                if (sig == -992349888) {
                    if (verbose) {
                        System.err.println("It's a DR1!");
                    }
                    oldFormat = true;
                    bRet = true;
                }
                if (sig == -992349632) {
                    if (verbose) {
                        System.err.println("It's a DR2!");
                    }
                    bRet = true;
                }
            }
            catch (IOException ioe) {
                if (!verbose) break block6;
                System.err.println("It's not a ZOSDump!");
            }
        }
        return bRet;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("\nUsage: java ZOSDump filename\n");
            System.exit(1);
        }
        verbose = true;
        try {
            RandomAccessFile raf = new RandomAccessFile(args[0], "r");
            if (ZOSdump.isSupportedDump(raf)) {
                System.err.println("\n File \"" + args[0] + "\" looks to be a ZOSDump");
            }
            try {
                raf.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException e) {
            System.err.println("\n File \"" + args[0] + "\" not found.");
            System.exit(1);
        }
        try {
            new ZOSdump(args[0]);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("\n File \"" + args[0] + "\" not found.");
            System.exit(1);
        }
    }

    private short getShort(byte[] b, int offset) {
        int b1 = b[offset <<= 2] << 8;
        int b2 = b[offset + 1] & 0xFF;
        short s = (short)(b1 + b2);
        return s;
    }

    private int getInt(byte[] b, int offset) {
        int b1 = b[offset <<= 2] << 24;
        int b2 = b[offset + 1] << 16 & 0xFFFFFF;
        int b3 = b[offset + 2] << 8 & 0xFFFF;
        int b4 = b[offset + 3] & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    private long getLong(byte[] b) {
        long b1 = (long)b[0] << 56 & 0xFFFFFFFFFFFFFFFFL;
        long b2 = (long)b[1] << 48 & 0xFFFFFFFFFFFFFFL;
        long b3 = (long)b[2] << 40 & 0xFFFFFFFFFFFFL;
        long b4 = (long)b[3] << 32 & 0xFFFFFFFFFFL;
        long b5 = (long)b[4] << 24 & 0xFFFFFFFFL;
        long b6 = (long)b[5] << 16 & 0xFFFFFFL;
        long b7 = (long)b[6] << 8 & 0xFFFFL;
        long b8 = (long)b[7] & 0xFFL;
        return b1 | b2 | b3 | b4 | b5 | b6 | b7 | b8;
    }

    private void establishCurrentAsid() {
        Object mr;
        asid01Position = -1;
        for (int i = 0; i < this.asidArray.length; ++i) {
            if (this.asidArray[i] != 1) continue;
            asid01Position = i;
            i = this.asidArray.length;
        }
        if (asid01Position != -1 && (mr = null)[0].getVaddr() == 0L) {
            try {
                this.seek(mr[0].getFileoffset() + 548L + 64L);
                int psaaold = this.readInt();
                int element = this.findWhichMemoryRange((long)psaaold + 108L);
                if (-1 == element || element < 1000000) {
                    System.err.println("Error looking for ascbasxb");
                } else {
                    long offset = mr[element -= 1000000].getFileoffset();
                    long start = mr[element].getVaddr();
                    long seekPos = offset + ((long)psaaold - start) + 108L + 64L;
                    this.seek(seekPos);
                    ascbasxb = this.readInt();
                }
            }
            catch (IOException ioe) {
                System.err.println("IOException looking for psaaold or ascbasxb");
            }
        }
    }

    private void consolidateMemoryCompounded() {
        int j;
        memoryRanges = new MemoryRange[1][];
        int rqdElements = 0;
        long previousAddr = 0L;
        int count = ZOSdump.compoundedMemory.unconsolidatedRanges.size();
        for (j = 0; j < ZOSdump.compoundedMemory.unconsolidatedRanges.size(); ++j) {
            long tAddr = ((MemoryRange)ZOSdump.compoundedMemory.unconsolidatedRanges.get(j)).getVaddr();
            if (j == 0 || previousAddr + 4096L != tAddr) {
                ++rqdElements;
            }
            previousAddr = tAddr;
        }
        ZOSdump.memoryRanges[0] = new MemoryRange[rqdElements];
        rqdElements = 0;
        previousAddr = 0L;
        for (j = 0; j < ZOSdump.compoundedMemory.unconsolidatedRanges.size(); ++j) {
            MemoryRange tMemRange = (MemoryRange)ZOSdump.compoundedMemory.unconsolidatedRanges.get(j);
            if (0 == rqdElements) {
                ZOSdump.memoryRanges[0][rqdElements] = tMemRange;
                ++rqdElements;
                previousAddr = tMemRange.getVaddr();
                continue;
            }
            long tAddr = tMemRange.getVaddr();
            if (previousAddr + 4096L == tAddr) {
                memoryRanges[0][rqdElements - 1].setSize(memoryRanges[0][rqdElements - 1].getSize() + 4160L - 64L);
            } else {
                ZOSdump.memoryRanges[0][rqdElements] = tMemRange;
                ++rqdElements;
            }
            previousAddr = tAddr;
        }
        this.arraySort(memoryRanges[0]);
    }

    private void consolidateMemory() {
        int i;
        this.asidArray = new int[this.foundAsids.size()];
        memoryRanges = new MemoryRange[this.foundAsids.size()][];
        for (i = 0; i < this.foundAsids.size(); ++i) {
            int j;
            AsidMemoryRanges asmr = (AsidMemoryRanges)this.foundAsids.get(i);
            this.asidArray[i] = asmr.asid;
            int rqdElements = 0;
            long previousAddr = 0L;
            int count = asmr.unconsolidatedRanges.size();
            for (j = 0; j < asmr.unconsolidatedRanges.size(); ++j) {
                long tAddr = ((MemoryRange)asmr.unconsolidatedRanges.get(j)).getVaddr();
                if (count == 1 || previousAddr + 4096L != tAddr) {
                    ++rqdElements;
                }
                previousAddr = tAddr;
            }
            ZOSdump.memoryRanges[i] = new MemoryRange[rqdElements];
            rqdElements = 0;
            previousAddr = 0L;
            for (j = 0; j < asmr.unconsolidatedRanges.size(); ++j) {
                MemoryRange tMemRange = (MemoryRange)asmr.unconsolidatedRanges.get(j);
                if (0 == rqdElements) {
                    ZOSdump.memoryRanges[i][rqdElements] = tMemRange;
                    ++rqdElements;
                    previousAddr = tMemRange.getVaddr();
                    continue;
                }
                long tAddr = tMemRange.getVaddr();
                if (previousAddr + 4096L == tAddr) {
                    memoryRanges[i][rqdElements - 1].setSize(memoryRanges[i][rqdElements - 1].getSize() + 4160L - 64L);
                } else {
                    ZOSdump.memoryRanges[i][rqdElements] = tMemRange;
                    ++rqdElements;
                }
                previousAddr = tAddr;
            }
        }
        for (i = 0; i < memoryRanges.length; ++i) {
            if (memoryRanges[i].length <= 1) continue;
            this.arraySort(memoryRanges[i]);
        }
    }

    private void arraySort(MemoryRange[] mr) {
        for (int j = 1; j < mr.length; ++j) {
            long thisone = mr[j].getVaddr();
            if (thisone >= mr[j - 1].getVaddr()) continue;
            int slot = 0;
            for (int k = j - 2; k >= 0; --k) {
                if (thisone < mr[k].getVaddr()) continue;
                slot = k + 1;
                k = 0;
            }
            MemoryRange tMemRange = mr[j];
            for (int k = j; k > slot; --k) {
                mr[k] = mr[k - 1];
            }
            mr[slot] = tMemRange;
        }
    }

    public long readLongEx() throws IOException {
        long retLong = 0L;
        byte[] b1 = this.getMemoryBytes(currentAddress, 8);
        if (b1.length != 8) {
            throw new IOException("ZOSDump unable to read long (8 bytes)from 0x" + Long.toHexString(currentAddress));
        }
        retLong = this.getLong(b1);
        return retLong;
    }

    public int readIntEx() throws IOException {
        int retInt = 0;
        byte[] b1 = this.getMemoryBytes(currentAddress, 4);
        if (b1.length != 4) {
            throw new IOException("ZOSDump unable to read int (4 bytes) from 0x" + Long.toHexString(currentAddress));
        }
        retInt = this.getInt(b1, 0);
        return retInt;
    }

    public short readShortEx() throws IOException {
        short retShort = 0;
        byte[] b1 = this.getMemoryBytes(currentAddress, 2);
        if (b1.length != 2) {
            throw new IOException("ZOSDump unable to read int (4 bytes) from 0x" + Long.toHexString(currentAddress));
        }
        retShort = this.getShort(b1, 0);
        return retShort;
    }

    public void readFullyEx(byte[] b) throws IOException {
        int expectedLen = b.length;
        byte[] b1 = this.getMemoryBytes(currentAddress, b.length);
        if (b1 != null) {
            if (b1.length != expectedLen) {
                throw new IOException("ZOSDump unable to read " + expectedLen + "bytes for 0x" + Long.toHexString(currentAddress));
            }
        } else {
            throw new IOException("ZOSDump unable to read bytes for 0x" + Long.toHexString(currentAddress));
        }
        System.arraycopy(b1, 0, b, 0, expectedLen);
    }

    public int readEx(byte[] b) throws IOException {
        int retLen = 0;
        byte[] b1 = this.getMemoryBytes(currentAddress, b.length);
        if (b1 != null) {
            retLen = b1.length;
            System.arraycopy(b1, 0, b, 0, retLen);
        }
        return retLen;
    }

    public int readEx(byte[] b, int off, int len) throws IOException {
        int retLen = 0;
        byte[] b1 = this.getMemoryBytes(currentAddress, len);
        if (b1 != null) {
            retLen = b1.length;
            System.arraycopy(b1, 0, b, off, retLen);
        }
        return retLen;
    }

    public void setCurrentJvm(J9Jvm currentJvm) {
        this.currentJvm = currentJvm;
        long anchorPtr = DumpUtils.parseLongHex(currentJvm.getId());
        int whichRange = this.findWhichMemoryRange(anchorPtr);
        if (whichRange >= 0) {
            int asid = this.sortedMemoryRanges[whichRange].getAsid();
            Integer addressMode = (Integer)this.addressSpaceModes.get(new Integer(asid));
            if (addressMode != null) {
                if (addressMode == 31) {
                    this.bIs32Bit = true;
                } else if (addressMode == 64) {
                    this.bIs32Bit = false;
                }
                System.out.println("Found " + addressMode + "-bit JVM at address " + anchorPtr + " in ASID " + asid);
            }
        } else {
            System.out.println("JVM at address " + anchorPtr + " not found in dump");
        }
    }

    static {
        numberOfAddressSpaces = 0L;
        currentAsidPosition = -1;
        prevAsidPosition = -1;
        asid01Position = -1;
        Dump.registerDumpSupport(ZOSdump.class);
    }

    class AddressSpace {
        AddressSpace() {
        }
    }

    class CompoundedMemoryRanges {
        Vector unconsolidatedRanges;

        CompoundedMemoryRanges() {
        }

        void addRange(MemoryRange m) {
            if (null == this.unconsolidatedRanges) {
                this.unconsolidatedRanges = new Vector();
            }
            this.unconsolidatedRanges.add(m);
        }
    }

    class AsidMemoryRanges {
        int asid;
        int taskCount;
        int[] tasks;
        Vector unconsolidatedRanges = new Vector();

        AsidMemoryRanges(int asidIn) {
            this.asid = asidIn;
        }

        void addRange(MemoryRange m) {
            this.unconsolidatedRanges.add(m);
        }

        int[] getTasks() {
            return this.tasks;
        }

        void addTasks(int count, int[] tcbs) {
        }
    }
}

