/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipHandler {
    private ZipFile zipFile;
    private File XMLFile;
    private File coreFile;
    private File tempDir;
    private String coreFilename;
    private String XMLFilename;
    private Collection supportFiles;

    public ZipHandler(File file, String _coreFilename, String _XMLFilename) throws ZipException, IOException {
        String zipFilename;
        this.zipFile = new ZipFile(file);
        this.coreFilename = null == _coreFilename ? ((zipFilename = file.getName()).endsWith(".zip") ? zipFilename.substring(0, zipFilename.length() - 4) : zipFilename) : _coreFilename;
        this.XMLFilename = null == _XMLFilename ? this.coreFilename + ".xml" : _XMLFilename;
        this.supportFiles = null;
        this.setupTempDir();
    }

    public File getXMLFile() {
        if (null == this.tempDir) {
            return null;
        }
        if (null == this.XMLFile) {
            ZipEntry XMLEntry = this.zipFile.getEntry(this.XMLFilename);
            if (null == XMLEntry) {
                return null;
            }
            try {
                this.XMLFile = new File(this.tempDir, XMLEntry.getName());
                this.XMLFile.deleteOnExit();
                this.dumpStream(this.zipFile.getInputStream(XMLEntry), new FileOutputStream(this.XMLFile));
            }
            catch (IOException ioe) {
                this.XMLFile = null;
            }
        }
        return this.XMLFile;
    }

    public File getCoreFile() {
        if (null == this.tempDir) {
            return null;
        }
        if (null == this.coreFile) {
            ZipEntry coreEntry = this.zipFile.getEntry(this.coreFilename);
            if (null == coreEntry) {
                return null;
            }
            if (null == this.supportFiles) {
                this.supportFiles = new Vector();
                String[] excludeNames = new String[]{this.coreFilename, this.XMLFilename};
                Iterator supportEntries = this.getEntriesExcludingNames(excludeNames);
                while (supportEntries.hasNext()) {
                    ZipEntry supportEntry = (ZipEntry)supportEntries.next();
                    try {
                        File supportFile = new File(this.tempDir, supportEntry.getName());
                        this.dumpStream(this.zipFile.getInputStream(supportEntry), new FileOutputStream(supportFile));
                        this.supportFiles.add(supportFile);
                        supportFile.deleteOnExit();
                    }
                    catch (IOException ioe) {}
                }
            }
            try {
                this.coreFile = new File(this.tempDir, coreEntry.getName());
                this.coreFile.deleteOnExit();
                this.dumpStream(this.zipFile.getInputStream(coreEntry), new FileOutputStream(this.coreFile));
            }
            catch (IOException ioe) {
                this.coreFile = null;
            }
        }
        return this.coreFile;
    }

    public Iterator close() {
        Vector<File> filesRemaining = new Vector<File>();
        if (null != this.supportFiles) {
            for (File supportFile : this.supportFiles) {
                if (supportFile.delete()) continue;
                filesRemaining.add(supportFile);
            }
        }
        if (null != this.XMLFile && !this.XMLFile.delete()) {
            filesRemaining.add(this.XMLFile);
        }
        if (null != this.coreFile && !this.coreFile.delete()) {
            filesRemaining.add(this.coreFile);
        }
        if (null != this.tempDir && !this.tempDir.delete()) {
            filesRemaining.add(this.tempDir);
        }
        return filesRemaining.iterator();
    }

    private Iterator getEntriesExcludingNames(String[] excludeNames) {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        Vector<ZipEntry> returnEntries = new Vector<ZipEntry>();
        while (entries.hasMoreElements()) {
            ZipEntry currEntry = entries.nextElement();
            boolean matchesExcludeName = false;
            for (int i = 0; i < excludeNames.length; ++i) {
                if (!currEntry.getName().equals(excludeNames[i])) continue;
                matchesExcludeName = true;
                break;
            }
            if (matchesExcludeName) continue;
            returnEntries.add(currEntry);
        }
        return returnEntries.iterator();
    }

    private void dumpStream(InputStream in, OutputStream out) {
        byte[] buffer = new byte[65536];
        try {
            int len = in.read(buffer);
            while (len >= 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
            in.close();
            out.close();
        }
        catch (IOException ioe) {
            return;
        }
    }

    private void setupTempDir() throws IOException {
        this.tempDir = File.createTempFile("tempJdmpview", null);
        this.tempDir.deleteOnExit();
        if (!this.tempDir.delete() || !this.tempDir.mkdir()) {
            this.tempDir = null;
        }
    }

    public String openAndProcessZipFile() {
        String coreFileName = null;
        File unzipCoreFile = this.getCoreFile();
        File unzipXMLFile = this.getXMLFile();
        coreFileName = unzipCoreFile.getAbsolutePath();
        return coreFileName;
    }

    public String getTempDirName() {
        String tempDirName = this.tempDir.getAbsolutePath();
        return tempDirName;
    }
}

