/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.ClassRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.LongObjectRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.LongPrimitveArrayRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.MediumObjectRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.ObjectArrayRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PrimitiveArrayRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.ShortObjectRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class PortableHeapDumpRecord {
    public static final byte ONE_BYTE_REF = 0;
    public static final byte TWO_BYTE_REF = 1;
    public static final byte FOUR_BYTE_REF = 2;
    public static final byte EIGHT_BYTE_REF = 3;
    public static final String[] REF_SIZE_TO_STRING = new String[]{"one byte (byte)", "two byte (short)", "four byte (int)", "eight byte (long)"};
    public static final byte WORD_SIZE_32BIT = 4;
    public static final byte WORD_SIZE_64BIT = 8;
    public static final int ADDRESS_SHIFT_SIZE = 2;
    protected byte tag;
    protected long length;
    protected long[] References;
    protected byte referenceSize;
    protected short hashCode;

    public boolean getTagBit(int pos) {
        return (this.tag & 1 << pos) > 0;
    }

    public int getTagValue(int start, int end) {
        if (start < 0 || end > 8) {
            throw new IllegalArgumentException();
        }
        int result = this.tag;
        result &= 255 >>> 7 - start;
        result &= 255 << end;
        return result >>>= end;
    }

    public long getLength() {
        return this.length;
    }

    protected static byte sizeofReference(long reference) {
        if (reference > Integer.MAX_VALUE || reference < Integer.MIN_VALUE) {
            return 3;
        }
        if (reference > 32767L || reference < -32768L) {
            return 2;
        }
        if (reference > 127L || reference < -128L) {
            return 1;
        }
        return 0;
    }

    protected void setReferences(J9Object object) {
        long[] references = object.getObjectRefs();
        if (references == null) {
            this.References = new long[0];
            return;
        }
        this.References = new long[references.length];
        for (int i = 0; i < references.length; ++i) {
            this.References[i] = PortableHeapDumpRecord.getAddressDifference(references[i], object.getObjectAddress());
            byte currentSize = PortableHeapDumpRecord.sizeofReference(this.References[i]);
            if (currentSize <= this.referenceSize) continue;
            this.referenceSize = currentSize;
        }
    }

    protected void writeReference(DataOutput dos, byte size, long reference) throws IOException {
        switch (size) {
            case 0: {
                dos.writeByte((byte)reference);
                break;
            }
            case 1: {
                dos.writeShort((short)reference);
                break;
            }
            case 2: {
                dos.writeInt((int)reference);
                break;
            }
            case 3: {
                dos.writeLong(reference);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong size argument!");
            }
        }
    }

    protected static long readReference(DataInput dis, byte size, long previousAddress) throws IOException {
        long result = 0L;
        switch (size) {
            case 0: {
                result = dis.readByte() << 2;
                result += previousAddress;
                break;
            }
            case 1: {
                result = dis.readShort() << 2;
                result += previousAddress;
                break;
            }
            case 2: {
                result = dis.readInt() << 2;
                result += previousAddress;
                break;
            }
            case 3: {
                result = dis.readLong() << 2;
                result = previousAddress;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong size argument!");
            }
        }
        return result;
    }

    protected static long[] readReferences(DataInput dis, long currentAddress, byte referenceSize, int referenceLength) throws IOException {
        if (referenceLength == 0) {
            return null;
        }
        long[] References = new long[referenceLength];
        switch (referenceSize) {
            case 0: {
                int i = 0;
                while (i < References.length) {
                    References[i] = dis.readByte() << 2;
                    int n = i++;
                    References[n] = References[n] + currentAddress;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < References.length) {
                    References[i] = dis.readShort() << 2;
                    int n = i++;
                    References[n] = References[n] + currentAddress;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < References.length) {
                    References[i] = dis.readInt() << 2;
                    int n = i++;
                    References[n] = References[n] + currentAddress;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < References.length) {
                    References[i] = dis.readLong() << 2;
                    int n = i++;
                    References[n] = References[n] + currentAddress;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error size byte invalid");
            }
        }
        return References;
    }

    protected void writeReferences(DataOutput dos) throws IOException {
        if (this.References.length == 0) {
            return;
        }
        switch (this.referenceSize) {
            case 0: {
                for (int i = 0; i < this.References.length; ++i) {
                    dos.writeByte((byte)this.References[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.References.length; ++i) {
                    dos.writeShort((short)this.References[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.References.length; ++i) {
                    dos.writeInt((int)this.References[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.References.length; ++i) {
                    dos.writeLong(this.References[i]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error size byte invalid");
            }
        }
    }

    protected static long getAddressDifference(long current, long previous) {
        return current - previous >> 2;
    }

    protected static long getAddressDifference(J9Object current, J9Object previous) {
        if (previous == null) {
            return current.getObjectAddress() >> 2;
        }
        return PortableHeapDumpRecord.getAddressDifference(current.getObjectAddress(), previous.getObjectAddress());
    }

    protected static void writeArrayRecord(DataOutput dos, J9Object current, J9Object previous) throws IOException {
        boolean isPrimitive = current.isPrimitiveArray();
        boolean isHashed = false;
        boolean isPinned = false;
        if (isPrimitive) {
            if (isHashed || isPinned) {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Long Primitive Array Object");
                }
                new LongPrimitveArrayRecord(current, previous).writeHeapDump(dos);
            } else {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Primitive Array Object");
                }
                new PrimitiveArrayRecord(current, previous).writeHeapDump(dos);
            }
        } else {
            if (PortableHeapDump.DEBUG) {
                PortableHeapDump.DEBUG_STREAM.print("Object Array");
            }
            new ObjectArrayRecord(current, previous).writeHeapDump(dos);
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" class = " + current.getClassForObject().getName());
            PortableHeapDump.DEBUG_STREAM.print(" address difference=" + PortableHeapDumpRecord.getAddressDifference(current, previous) + " double words");
            PortableHeapDump.DEBUG_STREAM.println();
        }
    }

    protected static void writeClassRecord(DataOutput dos, J9Object current, J9Object previous) throws IOException {
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println("Class Record: Current = 0x" + Long.toHexString(current.getObjectAddress()) + (previous == null ? " previous is null " : " previous = 0x" + Long.toHexString(previous.getObjectAddress())));
        }
        new ClassRecord(current, previous).writeHeapDump(dos);
    }

    protected static boolean isShortObjectEligible(J9Object current, J9Object previous) {
        long addressDifference = PortableHeapDumpRecord.getAddressDifference(current, previous);
        return addressDifference < 32767L && addressDifference > -32768L;
    }

    protected static void writeObjectRecord(DataOutput dos, J9Object current, J9Object previous, byte classCacheIndex) throws IOException {
        PortableHeapDumpRecord phdr;
        if (classCacheIndex == -1 || previous == null) {
            if (PortableHeapDump.DEBUG) {
                PortableHeapDump.DEBUG_STREAM.print("Long Object, new class insert in cache");
            }
            phdr = new LongObjectRecord(current, previous);
        } else if (PortableHeapDumpRecord.isShortObjectEligible(current, previous)) {
            int referencesLength = 0;
            long[] references = current.getObjectRefs();
            if (references != null) {
                referencesLength = references.length;
            }
            if (referencesLength <= 3) {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Short Object, no of ref =" + referencesLength);
                }
                phdr = new ShortObjectRecord(current, previous, classCacheIndex);
            } else if (referencesLength < 8) {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Medium Object, no of ref =" + referencesLength);
                }
                phdr = new MediumObjectRecord(current, previous);
            } else {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Long Object, no of ref=" + referencesLength);
                }
                phdr = new LongObjectRecord(current, previous);
            }
        } else {
            if (PortableHeapDump.DEBUG) {
                PortableHeapDump.DEBUG_STREAM.println("Long Object");
            }
            phdr = new LongObjectRecord(current, previous);
        }
        assert (phdr != null);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" class = " + current.getClassForObject().getName());
            PortableHeapDump.DEBUG_STREAM.print(" address difference=" + PortableHeapDumpRecord.getAddressDifference(current, previous) + " double words");
            PortableHeapDump.DEBUG_STREAM.println();
        }
        ((PortableHeapDumpRecord)phdr).writeHeapDump(dos);
    }

    protected static void readObjectRecords(DataInput dis, PortableHeapDumpHandler phdh) {
        PortableHeapDumpClassCache phdcc = new PortableHeapDumpClassCache();
        try {
            long previousAddress = 0L;
            byte magicByte = dis.readByte();
            block8: while (magicByte != 3) {
                switch (magicByte) {
                    case 4: {
                        LongObjectRecord.readHeapDump(dis, magicByte, phdh, previousAddress, phdcc);
                        continue block8;
                    }
                    case 5: {
                        ObjectArrayRecord.readHeapDump(dis, magicByte, phdh, previousAddress, null);
                        continue block8;
                    }
                    case 6: {
                        ClassRecord.readHeapDump(dis, magicByte, phdh);
                        continue block8;
                    }
                    case 7: {
                        LongPrimitveArrayRecord.readHeapDump(dis, magicByte, phdh);
                        continue block8;
                    }
                }
                byte id = magicByte;
                if ((id & 0xFFFFFF80) != 0) {
                    ShortObjectRecord.readHeapDump(dis, magicByte, phdh, phdcc);
                    continue;
                }
                if ((id & 0x40) != 0) {
                    MediumObjectRecord.readHeapDump(dis, magicByte, phdh, phdcc);
                    continue;
                }
                if ((id & 0x20) != 0) {
                    PrimitiveArrayRecord.readHeapDump(dis, magicByte, phdh);
                    continue;
                }
                phdh.exceptionDetected(new Exception("Unknown Record type, flag byte =" + magicByte));
            }
            phdh.endOfDump();
        }
        catch (Exception e) {
            phdh.exceptionDetected(e);
        }
    }

    public short getHashcode() {
        return this.hashCode;
    }

    public void setHashcode(short hashcode) {
        this.hashCode = hashcode;
    }

    protected abstract void writeHeapDump(DataOutput var1) throws IOException;
}

