/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public abstract class HeapDumpUtil {
    private static final int HEAPROOTS_HEXSTRING_LENGTH = 8;

    public static String getDefaultFileName() {
        StringBuffer result = new StringBuffer();
        result.append(J9JVMConsole.getTheDump().getDumpName());
        result.append(HeapDumpUtil.isPortableDump() ? ".phd" : ".hd");
        result.append(".gz");
        return result.toString();
    }

    public static boolean isPortableDump() {
        String DumpFormatType = Console.getProperty("HEAPDUMPFORMAT");
        if (DumpFormatType == null) {
            return true;
        }
        return !DumpFormatType.equalsIgnoreCase("Classic");
    }

    public static int doClassicHeapDump(PrintWriter out) throws IOException, IllegalArgumentException {
        out.println("// jdmpview heapdump generated at " + new Date() + " from '" + J9JVMConsole.getTheDump().getDumpName() + "'");
        out.println("// IBM Java VM 1.4.2 (J9 version " + J9JVMConsole.getTheDump().getVersion() + " build " + J9JVMConsole.getTheDump().getStamp() + ")");
        return HeapDumpUtil.dumpObjects(out);
    }

    public static int doPortableHeapDump(OutputStream out) throws IOException, IllegalArgumentException {
        Dump currentDump = J9JVMConsole.getTheDump();
        if (currentDump == null) {
            throw new IllegalArgumentException("The dump is not set");
        }
        boolean is32bit = currentDump.is32bit();
        boolean isLittleEndian = currentDump.isLittleEndian();
        PortableHeapDump phd = new PortableHeapDump(currentDump, is32bit, isLittleEndian);
        return phd.writeHeapDump(new DataOutputStream(out));
    }

    private static String toHexString(long l) {
        StringBuffer result = new StringBuffer(Long.toHexString(l).toUpperCase());
        if (result.length() < 8) {
            for (int i = 8 - result.length(); i > 0; --i) {
                result.insert(0, "0");
            }
        }
        result.insert(0, "0x");
        return result.toString();
    }

    private static int dumpObjects(PrintWriter ps) throws IOException, IllegalArgumentException {
        J9ObjectIterator objectIterator = J9ObjectIterator.getObjectIterator(null);
        char[] twisting = new char[]{'/', '/', '-', '-', '\\', '\\', '-', '-'};
        int count = 0;
        int objectCount = 0;
        int classCount = 0;
        int objectArrayCount = 0;
        int primitiveArrayCount = 0;
        int refCount = 0;
        int nullRefCount = 0;
        int twistingCount = 0;
        while (objectIterator.hasNext()) {
            J9Object current;
            if (++count % 50 == 0) {
                ++twistingCount;
            }
            if ((current = (J9Object)objectIterator.next()).isInstanceOfClass()) {
                ++classCount;
            } else if (current.isArray()) {
                if (current.isPrimitiveArray()) {
                    ++primitiveArrayCount;
                } else {
                    ++objectArrayCount;
                }
            } else {
                ++objectCount;
            }
            StringBuffer line1 = new StringBuffer();
            StringBuffer line2 = new StringBuffer();
            line1.append(HeapDumpUtil.toHexString(current.getObjectAddress()));
            line1.append(" [");
            line1.append(current.getInstanceSize());
            line1.append("] ");
            if (current.isArray()) {
                StringBuffer type = new StringBuffer();
                int arity = current.getClassForObject().getArity();
                if (current.isPrimitiveArray()) {
                    type.append("primitive array");
                } else {
                    if (arity >= 1) {
                        type.append("array of ");
                        --arity;
                    }
                    type.append(current.getArrayTypeAsString());
                    for (int i = 1; i <= arity; ++i) {
                        type.append("[");
                    }
                }
                line1.append(type);
            } else if (current.isInstanceOfClass()) {
                line1.append("class ");
                J9Class j9c = J9JVMConsole.getClass(current.getObjectAddress());
                line1.append(j9c.getName());
            } else {
                line1.append(current.getClassForObject().getName());
            }
            ps.println(line1.toString());
            if (current.isPrimitiveArray()) continue;
            long[] references = current.getObjectRefs();
            line2.append("\t");
            if (references != null) {
                for (int i = 0; i < references.length; ++i) {
                    line2.append("0x");
                    if (references[i] == 0L) {
                        line2.append("0");
                    } else {
                        line2.append(Long.toHexString(references[i]).toUpperCase());
                    }
                    line2.append(" ");
                    if (references[i] == 0L) {
                        ++nullRefCount;
                        continue;
                    }
                    ++refCount;
                }
            }
            ps.println(line2.toString());
        }
        System.out.println();
        ps.print("//Breakdown - Classes: " + classCount);
        ps.print(", Objects: " + objectCount);
        ps.print(", ObjectArrays: " + objectArrayCount);
        ps.println(", PrimitiveArrays: " + primitiveArrayCount);
        ps.print("//EOF: Total 'Objects',Refs(null) : ");
        ps.println("" + count + "," + refCount + "(" + nullRefCount + ")");
        return count;
    }
}

