/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpAbstractCommand;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpConsole;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpUtil;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Observable;

public class HeapDumpSetCommands
extends HeapDumpAbstractCommand {
    public static final String VERB = "SET";
    public static final String DESC = "Sets control for heapdump command";
    private static final String[] NOUNS = new String[]{"HEAPDUMP", "HEAPDUMPFORMAT", "HEAPDUMPDEBUG", "HEAPDUMPDEBUGOUTPUT", "HD_PORT", "HD_HOST"};
    public static final HeapDumpSetCommandActions[] ACTIONS = new HeapDumpSetCommandActions[]{new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails cd, Observable ob) {
            String filename = cd.getRest();
            if (filename.equals("")) {
                return "Heapdump file is currently set to " + HeapDumpConsole.getProperty("HEAPDUMPFILE");
            }
            HeapDumpConsole.setProperty("HEAPDUMPFILE", filename);
            return "Heapdump file is set to " + filename;
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails cd, Observable ob) {
            String result;
            String dumptype = cd.getRest();
            if (dumptype.equals("")) {
                return "The current format for HeapDump is " + HeapDumpConsole.getProperty("HEAPDUMPFORMAT");
            }
            if (dumptype.equalsIgnoreCase("Classic")) {
                HeapDumpConsole.setProperty("HEAPDUMPFORMAT", "Classic");
                HeapDumpConsole.setProperty("HEAPDUMPFILE", HeapDumpUtil.getDefaultFileName());
                result = "The HeapDump output is set to Classic";
            } else if (dumptype.equalsIgnoreCase("Portable")) {
                HeapDumpConsole.setProperty("HEAPDUMPFORMAT", "Portable");
                HeapDumpConsole.setProperty("HEAPDUMPFILE", HeapDumpUtil.getDefaultFileName());
                result = "The HeapDump output is set to Portable";
            } else {
                result = "Unknown Heapdump output type";
            }
            return result;
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails cd, Observable ob) {
            String option = cd.getRest();
            if (option.equals("")) {
                return "Heapdump Tracing is currently " + (PortableHeapDump.isDEBUG() ? "on" : "off");
            }
            if (option.equalsIgnoreCase("on") || option.equalsIgnoreCase("true")) {
                PortableHeapDump.setDEBUG(true);
            } else if (option.equalsIgnoreCase("off") || option.equalsIgnoreCase("false")) {
                PortableHeapDump.setDEBUG(false);
            }
            return "Heapdump Tracing is now " + (PortableHeapDump.isDEBUG() ? "on" : "off");
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails cd, Observable ob) {
            String option = cd.getRest();
            if (option.equals("")) {
                return "Heapdump Tracing is currently goes to" + (PortableHeapDump.DEBUG_STREAM == System.err ? "Standard error" : PortableHeapDump.DEBUG_FILENAME);
            }
            if (option.equalsIgnoreCase("*stderr*")) {
                PortableHeapDump.DEBUG_STREAM = System.err;
                return "Heapdump Tracing now goes to Standard error";
            }
            try {
                PortableHeapDump.DEBUG_STREAM = new PrintStream(new FileOutputStream(option));
            }
            catch (FileNotFoundException fnfe) {
                return "Heapdump Tracing: cannot create file" + option;
            }
            return "Heapdump Tracing now goes to " + option;
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails cd, Observable ob) {
            String input = cd.getRest();
            if (input.equals("")) {
                return "Heapdump Network output port is currently set to " + HeapDumpConsole.getProperty("HD_PORT");
            }
            try {
                int port = Integer.parseInt(input);
                HeapDumpConsole.setProperty("HD_PORT", input);
                return "Heapump Network output port is now set to: " + input;
            }
            catch (NumberFormatException nfe) {
                return "HD_PORT: Parameter is not a valid number";
            }
        }
    }, new HeapDumpSetCommandActions(){

        public String commandAction(CommandDetails cd, Observable ob) {
            String hostname = cd.getRest();
            if (hostname.equals("")) {
                return "Heapdump Network Host is currently set to " + HeapDumpConsole.getProperty("HD_HOST");
            }
            HeapDumpConsole.setProperty("HD_HOST", hostname);
            return "Heapdump Network Host is set to " + hostname;
        }
    }};

    protected HeapDumpSetCommands(String Noun, HeapDumpBaseCmds cp, Observable o) {
        super(VERB, Noun, cp, o, DESC);
    }

    public static HeapDumpSetCommands[] getHeapDumpSetCommands(HeapDumpBaseCmds cp, Observable o) {
        HeapDumpSetCommands[] result = new HeapDumpSetCommands[NOUNS.length];
        for (int i = 0; i < NOUNS.length; ++i) {
            result[i] = new HeapDumpSetCommands(NOUNS[i], cp, o);
        }
        return result;
    }

    public boolean checkUserInput(CommandDetails cd) {
        if (cd.getVerb().equals(VERB)) {
            for (int i = 0; i < NOUNS.length; ++i) {
                if (!cd.getNoun().equals(NOUNS[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String action(CommandDetails cd, Observable ob) {
        StringBuffer result = new StringBuffer("Unknown settings: available settings are: ");
        for (int i = 0; i < NOUNS.length; ++i) {
            result.append(NOUNS[i]);
            result.append(" ");
            if (!cd.getNoun().equalsIgnoreCase(NOUNS[i])) continue;
            return ACTIONS[i].commandAction(cd, ob);
        }
        return result.toString();
    }

    static interface HeapDumpSetCommandActions {
        public String commandAction(CommandDetails var1, Observable var2);
    }
}

