/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.security.auth.callback.CallbackHandler;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11keystore");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private SessionManager sessionManager = null;
    private Hashtable entries = new Hashtable();
    private Provider provider;
    private String providerName = "IBMPKCS11Impl";

    public PKCS11KeyStore() {
        this.sessionManager = ((IBMPKCS11Impl)Security.getProvider(this.providerName)).getSessionManager();
    }

    public PKCS11KeyStore(Provider provider) {
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.provider = provider;
        this.providerName = provider.getName();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)entry).key;
            }
            if (entry instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)entry).key;
            }
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
            chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                cert = ((TrustedCertEntry)entry).cert;
            } else if (entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
                cert = ((PrivateKeyEntry)entry).chain[0];
            }
        }
        return cert;
    }

    @Override
    public synchronized KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                PrivateKey privkey = (PrivateKey)((PrivateKeyEntry)entry).key;
                Certificate[] chain = null;
                if (((PrivateKeyEntry)entry).chain != null) {
                    chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
                }
                return new KeyStore.PrivateKeyEntry(privkey, chain);
            }
            if (entry instanceof SecretKeyEntry) {
                SecretKey seckey = (SecretKey)((SecretKeyEntry)entry).key;
                return new KeyStore.SecretKeyEntry(seckey);
            }
            if (entry instanceof TrustedCertEntry) {
                return new KeyStore.TrustedCertificateEntry(((TrustedCertEntry)entry).cert);
            }
        }
        return null;
    }

    @Override
    public synchronized void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            Certificate cert = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            this.engineSetCertificateEntry(alias, cert);
        } else if (entry instanceof KeyStore.PrivateKeyEntry) {
            PrivateKey key = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            Certificate[] chain = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
            char[] chars = null;
            this.engineSetKeyEntry(alias, key, chars, chain);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEnt = (KeyStore.SecretKeyEntry)entry;
            SecretKey skey = secretKeyEnt.getSecretKey();
            char[] chars = null;
            this.engineSetKeyEntry(alias, skey, chars, null);
        } else {
            throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date engineGetCreationDate(String alias) {
        Object date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            Session session = null;
            if (entry instanceof PrivateKeyEntry) {
                try {
                    session = this.sessionManager.getOpSession();
                    date = session.getAttrValue(((PrivateKeyEntry)entry).keyObject, 272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (date == null) {
                    PublicKey pkey;
                    Certificate[] chain;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the private key");
                    }
                    if ((chain = ((PrivateKeyEntry)entry).chain) != null && chain.length > 0 && (pkey = ((X509Certificate)chain[0]).getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof SecretKeyEntry) {
                try {
                    session = this.sessionManager.getOpSession();
                    date = session.getAttrValue(((SecretKeyEntry)entry).keyObject, 272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (date == null) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the secret key");
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof TrustedCertEntry) {
                try {
                    session = this.sessionManager.getOpSession();
                    date = session.getAttrValue(((TrustedCertEntry)entry).certObject, 272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (date == null) {
                    PublicKey pkey;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the certificate");
                    }
                    if ((pkey = ((TrustedCertEntry)entry).cert.getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            }
        }
        if (date == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetCreationDate", "no entry found associated with alias " + alias);
            }
            return null;
        }
        return (Date)date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Session session = null;
            PKCS11Object destroyIt = null;
            try {
                Object kf;
                String alg;
                Key pkey;
                Object entry;
                Object newEntry = null;
                session = this.sessionManager.getObjSession();
                if (this.engineIsCertificateEntry(alias)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineSetKeyEntry", "Alias exists for a certificate entry");
                        debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                    }
                    throw new KeyStoreException("Alias exists for a certificate entry");
                }
                if (this.engineIsKeyEntry(alias)) {
                    Object keyentry;
                    Object keyobj = this.entries.get(alias.toLowerCase());
                    if (keyobj instanceof PrivateKeyEntry) {
                        keyentry = (PrivateKeyEntry)keyobj;
                        PKCS11PrivateKey ppkey = (PKCS11PrivateKey)((PrivateKeyEntry)keyentry).key;
                        destroyIt = ppkey.getObject();
                        this.deleteChain(session, ppkey.getID());
                    } else {
                        keyentry = (SecretKeyEntry)keyobj;
                        PKCS11SecretKey skey = (PKCS11SecretKey)((SecretKeyEntry)keyentry).key;
                        destroyIt = ((SecretKeyEntry)keyentry).keyObject;
                    }
                }
                if (key instanceof PKCS11PrivateKey) {
                    entry = new PrivateKeyEntry();
                    ((PrivateKeyEntry)entry).key = key;
                    ((PrivateKeyEntry)entry).keyObject = ((PKCS11PrivateKey)key).getObject();
                    if (!((Boolean)this.getValue(session, ((PrivateKeyEntry)entry).keyObject, 1)).booleanValue()) {
                        ((PrivateKeyEntry)entry).key = pkey = this.makePrivKeyToken(session, (PKCS11PrivateKey)key, alias);
                        ((PrivateKeyEntry)entry).keyObject = pkey.getObject();
                    } else if (!((String)this.getValue(session, ((PrivateKeyEntry)entry).keyObject, 3)).equalsIgnoreCase(alias)) {
                        ((PrivateKeyEntry)entry).key = pkey = this.changePrivKeyLabel(session, (PKCS11PrivateKey)key, alias);
                        ((PrivateKeyEntry)entry).keyObject = pkey.getObject();
                    }
                    ((PrivateKeyEntry)entry).chain = chain != null && chain[0] != null ? (Certificate[])chain.clone() : null;
                    if (destroyIt != null) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                    this.addCertificateChain(session, alias, ((PKCS11PrivateKey)key).getID(), ((PrivateKeyEntry)entry).chain, true);
                    newEntry = entry;
                } else if (key instanceof PKCS11SecretKey) {
                    entry = new SecretKeyEntry();
                    ((SecretKeyEntry)entry).key = key;
                    ((SecretKeyEntry)entry).keyObject = ((PKCS11SecretKey)key).getObject();
                    if (!((Boolean)this.getValue(session, ((SecretKeyEntry)entry).keyObject, 1)).booleanValue()) {
                        ((SecretKeyEntry)entry).key = pkey = this.makeSecKeyToken(session, (PKCS11SecretKey)key, alias);
                        ((SecretKeyEntry)entry).keyObject = pkey.getObject();
                    } else if (!((String)this.getValue(session, ((SecretKeyEntry)entry).keyObject, 3)).equalsIgnoreCase(alias)) {
                        ((SecretKeyEntry)entry).key = pkey = this.changeSecKeyLabel(session, (PKCS11SecretKey)key, alias);
                        ((SecretKeyEntry)entry).keyObject = pkey.getObject();
                    }
                    if (destroyIt != null) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                    newEntry = entry;
                } else if (key instanceof PrivateKey) {
                    PKCS11PrivateKey ppkey;
                    block53: {
                        alg = key.getAlgorithm();
                        ppkey = null;
                        kf = null;
                        try {
                            if (alg.equalsIgnoreCase("DSA")) {
                                kf = KeyFactory.getInstance("DSA", this.providerName);
                                ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                                break block53;
                            }
                            if (alg.equalsIgnoreCase("RSA")) {
                                kf = KeyFactory.getInstance("RSA", this.providerName);
                                ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                                break block53;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + alg);
                                debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                            }
                            throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                        }
                        catch (Exception e) {
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)e);
                                debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                            }
                            throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                        }
                    }
                    PrivateKeyEntry entry2 = new PrivateKeyEntry();
                    if (!((String)this.getValue(session, ppkey.getObject(), 3)).equalsIgnoreCase(alias)) {
                        PKCS11PrivateKey pkey2 = this.changePrivKeyLabel(session, ppkey, alias);
                        entry2.key = pkey2;
                        entry2.keyObject = pkey2.getObject();
                    } else {
                        entry2.key = ppkey;
                        entry2.keyObject = ppkey.getObject();
                    }
                    entry2.chain = chain != null && chain[0] != null ? (Certificate[])chain.clone() : null;
                    if (destroyIt != null) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                    if (((Boolean)this.getValue(session, entry2.keyObject, 1)).booleanValue()) {
                        this.addCertificateChain(session, alias, ppkey.getID(), entry2.chain, true);
                    } else {
                        this.addCertificateChain(session, alias, ppkey.getID(), entry2.chain, false);
                    }
                    newEntry = entry2;
                } else if (key instanceof SecretKey) {
                    alg = key.getAlgorithm();
                    PKCS11SecretKey skey = null;
                    kf = null;
                    try {
                        if (!(alg.equalsIgnoreCase("DES") || alg.equalsIgnoreCase("3DES") || alg.equalsIgnoreCase("DESede") || alg.equalsIgnoreCase("TripleDES") || alg.equalsIgnoreCase("ARCFOUR") || alg.equalsIgnoreCase("RC4") || alg.equalsIgnoreCase("Blowfish") || alg.equalsIgnoreCase("Generic") || alg.equalsIgnoreCase("AES"))) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + alg);
                                debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                            }
                            throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                        }
                        kf = SecretKeyFactory.getInstance(alg, this.providerName);
                        skey = (PKCS11SecretKey)((SecretKeyFactory)kf).translateKey((SecretKey)key);
                    }
                    catch (Exception e) {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)e);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                    }
                    SecretKeyEntry entry3 = new SecretKeyEntry();
                    if (!((String)this.getValue(session, skey.getObject(), 3)).equalsIgnoreCase(alias)) {
                        PKCS11SecretKey sskey = this.changeSecKeyLabel(session, skey, alias);
                        entry3.key = sskey;
                        entry3.keyObject = sskey.getObject();
                    } else {
                        entry3.key = skey;
                        entry3.keyObject = skey.getObject();
                    }
                    newEntry = entry3;
                    if (destroyIt != null) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetKeyEntry", "destroy existing one");
                        }
                        session.destroyObject(destroyIt);
                    }
                } else {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineSetKeyEntry", "Invalid key type");
                        debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                    }
                    throw new KeyStoreException("Invalid key type");
                }
                this.entries.put(alias.toLowerCase(), newEntry);
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
    }

    private PKCS11PrivateKey changePrivKeyLabel(Session session, PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "changePrivKeyLabel", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{3};
        Object[] chgvalues = new Object[]{alias};
        return this.convertPrivKeyObj(session, chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11PrivateKey makePrivKeyToken(Session session, PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "makePrivKeyToken", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{1, 2, 3, 257};
        DerOutputStream privKeyDos = null;
        String privKeyNewString = null;
        X500Name privKeySubjName = null;
        String[] privKeyStringArray = null;
        UnstructuredName privKeyUnstructName = null;
        byte[] pkeySubject = null;
        byte[] pkeyEncodedSubject = null;
        pkeySubject = pkey.getSubject();
        if (pkeySubject != null) {
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "makePrivKeyToken_3a", "Try DER encoding private key subject name as X500 name initially");
                }
                privKeyDos = new DerOutputStream();
                privKeyNewString = new String(pkeySubject, "8859_1");
                privKeySubjName = new X500Name(privKeyNewString);
                privKeySubjName.encode(privKeyDos);
                pkeyEncodedSubject = privKeyDos.toByteArray();
            }
            catch (Exception ex3b) {
                try {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "makePrivKeyToken_3b", "DER encode private key subject name as UnstructuredName instead");
                    }
                    privKeyDos = new DerOutputStream();
                    privKeyStringArray = new String[]{new String(pkeySubject, "8859_1")};
                    privKeyUnstructName = new UnstructuredName(privKeyStringArray);
                    privKeyUnstructName.encode((OutputStream)privKeyDos);
                    pkeyEncodedSubject = privKeyDos.toByteArray();
                }
                catch (Exception ex3c) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "makePrivKeyToken_3c", (Throwable)ex3c);
                    }
                    throw new KeyStoreException(ex3c.getMessage());
                }
            }
        }
        Object[] chgvalues = new Object[]{Boolean.TRUE, Boolean.TRUE, alias, pkeyEncodedSubject};
        return this.convertPrivKeyObj(session, chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11PrivateKey convertPrivKeyObj(Session session, int[] chgtypes, Object[] chgvalues, PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        PrivateKeyInfo key = null;
        PKCS11Object newObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"PKCS11KeyStore", "convertPrivKeyObj");
        }
        try {
            newObj = session.copy(pkey.getObject(), chgtypes, chgvalues);
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertPrivKeyObj", "make copy of key");
            }
        }
        catch (Exception ke) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertPrivKeyObj", "Create as a new key not a copy. " + ke.getMessage());
            }
            int[] attrtypes = null;
            Object[] attrvalues = null;
            if (pkey instanceof PKCS11RSAPrivateKey) {
                PKCS11RSAPrivateKey pRSA = (PKCS11RSAPrivateKey)pkey;
                int[] attrtypesRSA = new int[]{0, 1, 2, 3, 256, 257, 258, 264, 265, 288, 291, 261, 268, 259, 296, 290, 292, 293, 294, 295};
                Object[] attrvaluesRSA = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, alias, PKCS11Object.RSA, pRSA.getSubject(), pRSA.getID(), pRSA.getSign(), pRSA.getSignRecover(), pRSA.getModulus(), pRSA.getPrivateExponent(), pRSA.getDecrypt(), pRSA.getDerive(), pRSA.getSensitive(), pRSA.getCoefficient(), pRSA.getPublicExponent(), pRSA.getPrime1(), pRSA.getPrime2(), pRSA.getExponent1(), pRSA.getExponent2()};
                attrtypes = attrtypesRSA;
                attrvalues = attrvaluesRSA;
            } else if (pkey instanceof PKCS11DSAPrivateKey) {
                PKCS11DSAPrivateKey pDSA = (PKCS11DSAPrivateKey)pkey;
                int[] attrtypesDSA = new int[]{17, 0, 1, 2, 3, 256, 257, 258, 264, 265, 306, 305, 304, 261, 268, 259};
                Object[] attrvaluesDSA = new Object[]{pDSA.getValue().toByteArray(), PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, alias, PKCS11Object.DSA, pDSA.getSubject(), pDSA.getID(), pDSA.getSign(), pDSA.getSignRecover(), pDSA.getBase(), pDSA.getSubprime(), pDSA.getPrime(), pDSA.getDecrypt(), pDSA.getDerive(), pDSA.getSensitive()};
                attrtypes = attrtypesDSA;
                attrvalues = attrvaluesDSA;
            }
            try {
                newObj = session.createObject(attrtypes, attrvalues);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "convertPrivKeyObj", (Throwable)e);
                    debug.exit(16384L, (Object)className, "convertPrivKeyObj");
                }
                if (newObj != null) {
                    session.destroyObject(newObj);
                }
                throw new KeyStoreException(e.getMessage());
            }
        }
        try {
            if (pkey instanceof PKCS11RSAPrivateKey) {
                PKCS11RSAPrivateKey pRSA = (PKCS11RSAPrivateKey)pkey;
                key = new RSAPrivateKey(session, newObj, pRSA.getID(), pRSA.getSubject(), alias, Boolean.TRUE, pRSA.getSensitive(), pRSA.getSign(), pRSA.getDecrypt(), pRSA.getUnwrap(), pRSA.getExtractable(), pRSA.getModulus(), pRSA.getPublicExponent(), pRSA.getPrivateExponent(), pRSA.getPrime1(), pRSA.getPrime2(), pRSA.getExponent1(), pRSA.getExponent2(), pRSA.getCoefficient());
            } else if (pkey instanceof PKCS11DSAPrivateKey) {
                PKCS11DSAPrivateKey pDSA = (PKCS11DSAPrivateKey)pkey;
                key = new DSAPrivateKey(session, newObj, alias, pDSA.getID(), pDSA.getSubject(), Boolean.TRUE, pDSA.getSensitive(), pDSA.getExtractable(), pDSA.getPrime(), pDSA.getSubprime(), pDSA.getBase(), pDSA.getValue());
            }
        }
        catch (InvalidKeyException ie) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "convertPrivKeyObj", (Throwable)ie);
                debug.exit(16384L, (Object)className, "convertPrivKeyObj");
            }
            throw new KeyStoreException(ie.getMessage());
        }
        finally {
            session.destroyObject(pkey.getObject());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"PKCS11KeyStore", "convertPrivKeyObj");
        }
        return key;
    }

    private PKCS11SecretKey changeSecKeyLabel(Session session, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "changeSecKeyLabel", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{3};
        Object[] chgvalues = new Object[]{alias};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "changeSecKeyLabel");
        }
        return this.convertSecKeyObj(session, chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11SecretKey makeSecKeyToken(Session session, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "makeSecKeyToken", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{1, 2, 3};
        Object[] chgvalues = new Object[]{Boolean.TRUE, Boolean.TRUE, alias};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "makeSecKeyToken");
        }
        return this.convertSecKeyObj(session, chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11SecretKey convertSecKeyObj(Session session, int[] chgtypes, Object[] chgvalues, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        PKCS11Object newObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "convertSecKeyObj");
        }
        try {
            newObj = session.copy(pkey.getObject(), chgtypes, chgvalues);
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertSecKeyObj", "make copy of secret key");
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertSecKeyObj", "Copy failed try to create token key");
            }
            try {
                PKCS11SecretKey gk;
                byte[] value = null;
                if (pkey instanceof GeneralKey) {
                    gk = (GeneralKey)pkey;
                    value = ((GeneralKey)gk).getValue();
                } else if (pkey instanceof PKCS11DESedeKey) {
                    gk = (PKCS11DESedeKey)pkey;
                    value = gk.getValue();
                } else if (pkey instanceof PKCS11DESKey) {
                    gk = (PKCS11DESKey)pkey;
                    value = gk.getValue();
                }
                int[] attrTypes = new int[]{0, 256, 258, 3, 2, 1, 259, 268, 260, 261, 262, 263, 17};
                Object[] attrValues = new Object[]{PKCS11Object.SECRET_KEY, pkey.getKeyType(), pkey.getID(), alias, Boolean.TRUE, Boolean.TRUE, pkey.getSensitive(), pkey.getDerive(), pkey.getEncrypt(), pkey.getDecrypt(), pkey.getWrap(), pkey.getUnwrap(), value};
                newObj = session.createObject(attrTypes, attrValues);
            }
            catch (PKCS11Exception pe) {
                if (newObj != null) {
                    session.destroyObject(newObj);
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "convertSecKeyObj", (Throwable)pe);
                    debug.exit(16384L, (Object)className, "convertSecKeyObj");
                }
                throw new KeyStoreException(pe.getMessage());
            }
        }
        GeneralKey key = null;
        try {
            if (pkey instanceof GeneralKey) {
                GeneralKey genKey = (GeneralKey)pkey;
                key = new GeneralKey(session, newObj, genKey.mechanismBuilder.getAlgorithm());
            } else if (pkey instanceof PKCS11DESKey) {
                key = new GeneralKey(session, newObj, "DES");
            } else if (pkey instanceof PKCS11DESedeKey) {
                key = new GeneralKey(session, newObj, "DESede");
            }
        }
        catch (InvalidKeyException ke) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "convertSecKeyObj", (Throwable)ke);
                debug.exit(16384L, (Object)className, "convertSecKeyObj");
            }
            throw new KeyStoreException(ke.getMessage());
        }
        finally {
            session.destroyObject(pkey.getObject());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "convertSecKeyObj");
        }
        return key;
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
            debug.text(16384L, (Object)className, "engineSetKeyEntry", "This method is not supported");
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetCertificateEntry", (Object)alias, (Object)cert);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Cannot overwrite key entry");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            Object[] certObj = new Object[2];
            if (cert instanceof X509Certificate) {
                byte[] subject = null;
                byte[] id = null;
                try {
                    id = alias.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    id = alias.getBytes();
                }
                byte[] issuer = null;
                CertificateSerialNumber serialNumber = null;
                byte[] encodedSerialNumber = null;
                DerOutputStream dos = null;
                if (id.length > 20) {
                    byte[] bytes = new byte[20];
                    System.arraycopy(id, 0, bytes, 0, 20);
                    id = bytes;
                }
                Session session = null;
                try {
                    session = this.sessionManager.getObjSession();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X509", this.providerName);
                    if (cert instanceof X509CertImpl) {
                        X509CertImpl thecert = (X509CertImpl)cert;
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getSubjectDN()).encode(dos);
                        subject = dos.toByteArray();
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getIssuerDN()).encode(dos);
                        issuer = dos.toByteArray();
                        dos = new DerOutputStream();
                        serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                        serialNumber.encode((OutputStream)dos);
                        encodedSerialNumber = dos.toByteArray();
                        certObj = this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
                    X509CertImpl thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    dos = new DerOutputStream();
                    serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                    serialNumber.encode((OutputStream)dos);
                    encodedSerialNumber = dos.toByteArray();
                    certObj = this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
                }
                catch (Exception ioe) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetCertificateEntry", (Throwable)ioe);
                        debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                    }
                    throw new KeyStoreException("Cannot store certificate :" + ioe.getMessage());
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Unsupported certificate type. Only X509 certificate is supported");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = cert;
            trustedCertEntry.certObject = (PKCS11Object)certObj[0];
            if (certObj[1] != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"PKCS11KeyStore", "engineSetCertificateEntry", "certificate is session object, session " + certObj[1]);
                }
                trustedCertEntry.session = (Session)certObj[1];
            }
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
        }
    }

    private void addCertificateChain(Session session, String alias, byte[] id, Certificate[] cert, boolean isToken) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addCertificateChain", (Object)alias, (Object)isToken);
        }
        int[] attrType = new int[]{1, 0, 257, 130};
        byte[] subject = null;
        byte[] issuer = null;
        CertificateSerialNumber serialNumber = null;
        byte[] encodedSerialNumber = null;
        DerOutputStream dos = null;
        X509CertImpl thecert = null;
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "cert chain is null");
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            return;
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X509", this.providerName);
            if (cert[0] instanceof X509CertImpl) {
                thecert = (X509CertImpl)cert[0];
                dos = new DerOutputStream();
                ((X500Name)thecert.getSubjectDN()).encode(dos);
                subject = dos.toByteArray();
                dos = new DerOutputStream();
                ((X500Name)thecert.getIssuerDN()).encode(dos);
                issuer = dos.toByteArray();
                dos = new DerOutputStream();
                serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                serialNumber.encode((OutputStream)dos);
                encodedSerialNumber = dos.toByteArray();
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(cert[0].getEncoded());
                thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                dos = new DerOutputStream();
                ((X500Name)thecert.getSubjectDN()).encode(dos);
                subject = dos.toByteArray();
                dos = new DerOutputStream();
                ((X500Name)thecert.getIssuerDN()).encode(dos);
                dos = new DerOutputStream();
                serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                serialNumber.encode((OutputStream)dos);
                encodedSerialNumber = dos.toByteArray();
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "Alias = " + alias);
                debug.text(16384L, (Object)className, "addCertificateChain", "id = " + new HexDumpEncoder().encode(id));
            }
            this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
            for (int i = 1; i < cert.length; ++i) {
                if (cert[i] instanceof X509CertImpl) {
                    thecert = (X509CertImpl)cert[i];
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    issuer = dos.toByteArray();
                    dos = new DerOutputStream();
                    serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                    serialNumber.encode((OutputStream)dos);
                    encodedSerialNumber = dos.toByteArray();
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert[i].getEncoded());
                    thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    dos = new DerOutputStream();
                    serialNumber = new CertificateSerialNumber(thecert.getSerialNumber());
                    serialNumber.encode((OutputStream)dos);
                    encodedSerialNumber = dos.toByteArray();
                }
                Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, subject, encodedSerialNumber};
                PKCS11Object pkcs11obj = null;
                session.findObjectsInit(attrType, attrVal);
                pkcs11obj = session.findObject();
                session.findObjectsFinal();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "addCertificateChain", "pkcs11obj = " + pkcs11obj);
                }
                if (pkcs11obj != null) continue;
                this.createCertObject(session, alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, encodedSerialNumber);
            }
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "addCertificateChain", (Throwable)ex);
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            throw new KeyStoreException(ex.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addCertificateChain");
        }
    }

    private Object[] createCertObject(Session session, String label, Boolean isToken, byte[] value, byte[] subject, byte[] id, byte[] issuer, byte[] encodedSerialNumber) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "createCertObject", (Object)label, (Object)isToken);
        }
        int[] attrtypes = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] attrvalues = new Object[]{PKCS11Object.CERTIFICATE, isToken, Boolean.FALSE, label, PKCS11Object.X_509, id, subject, encodedSerialNumber, value, issuer};
        Object[] result = new Object[2];
        PKCS11Object newobj = null;
        try {
            newobj = session.createObject(attrtypes, attrvalues);
            if (!isToken.booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)"PKCS11KeyStore", "createCertObject", "certificate is session object, session is " + session);
                }
                session.addObject();
                result[1] = session;
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "createCertObject", (Throwable)e);
                debug.exit(16384L, (Object)className, "createCertObject");
            }
            throw new KeyStoreException("Cannot store certificate: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "createCertObject");
        }
        result[0] = newobj;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDeleteEntry", (Object)alias);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Session session = null;
            try {
                session = this.sessionManager.getOpSession();
                if (this.engineIsKeyEntry(alias)) {
                    Object entry = this.entries.get(alias.toLowerCase());
                    if (entry instanceof PrivateKeyEntry) {
                        PrivateKeyEntry keyentry = (PrivateKeyEntry)entry;
                        this.deleteKey(session, (PKCS11Key)((Object)keyentry.key), PKCS11Object.PRIVATE_KEY);
                        this.deletePublicKey(session, keyentry.chain, (PKCS11Key)((Object)keyentry.key));
                        this.deleteChain(session, ((PKCS11Key)((Object)keyentry.key)).getID());
                        keyentry.chain = null;
                        keyentry.key = null;
                        keyentry.keyObject = null;
                    } else {
                        SecretKeyEntry keyentry = (SecretKeyEntry)entry;
                        this.deleteKey(session, (PKCS11Key)((Object)keyentry.key), PKCS11Object.SECRET_KEY);
                        keyentry.key = null;
                        keyentry.keyObject = null;
                    }
                } else if (this.engineIsCertificateEntry(alias)) {
                    TrustedCertEntry certentry = (TrustedCertEntry)this.entries.get(alias.toLowerCase());
                    session.destroyObject(certentry.certObject);
                    if (certentry.session != null) {
                        certentry.session.removeObject();
                        certentry.session = null;
                    }
                    certentry.cert = null;
                    certentry.certObject = null;
                }
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
            this.entries.remove(alias.toLowerCase());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDeleteEntry");
        }
    }

    private void deleteKey(Session session, PKCS11Key key, int classNum) {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "deleteKey", (Object)keyString, (Object)classNum);
        }
        PKCS11Object pkcs11obj = null;
        String label = key.getLabel();
        byte[] id = key.getID();
        Integer keytype = key.getKeyType();
        key.rm();
        int cnt = 5;
        if (label == null) {
            --cnt;
        }
        if (id == null || id.length == 0) {
            --cnt;
        }
        int[] attrTypeID = new int[cnt];
        Object[] val = new Object[cnt];
        int x = 0;
        attrTypeID[x] = 1;
        val[x] = Boolean.FALSE;
        attrTypeID[++x] = 0;
        val[x] = classNum;
        attrTypeID[++x] = 2;
        val[x] = Boolean.FALSE;
        ++x;
        if (label != null) {
            attrTypeID[x] = 3;
            val[x] = label;
            ++x;
        }
        if (id != null && id.length > 0) {
            attrTypeID[x] = 258;
            val[x] = id;
        }
        session.findObjectsInit(attrTypeID, val);
        pkcs11obj = session.findObject();
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteKey", (Object)"No Session object found.");
            }
            return;
        }
        session.destroyObject(pkcs11obj);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteKey", (Object)"Session object found.");
        }
    }

    private void deletePublicKey(Session session, Certificate[] cert, PKCS11Key key) {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "deletePublicKey", (Object)cert, (Object)keyString);
        }
        PKCS11Object pkcs11obj = null;
        int[] attrTypeID = null;
        Object[] val = null;
        if (cert == null || cert[0] == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "deletePublicKey", "No cert associated with private key.");
            }
            int[] attrTypeIDN = new int[]{1, 256, 0, 3, 258};
            Object[] valN = new Object[]{Boolean.TRUE, key.getKeyType(), PKCS11Object.PUBLIC_KEY, key.getLabel(), key.getID()};
            session.findObjectsInit(attrTypeIDN, valN);
            pkcs11obj = session.findObject();
            session.findObjectsFinal();
            if (pkcs11obj == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
                }
                return;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)("Object = " + pkcs11obj));
            }
            session.destroyObject(pkcs11obj);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
            }
            return;
        }
        PKCS11PublicKey pub = (PKCS11PublicKey)((X509Certificate)cert[0]).getPublicKey();
        if (pub.getKeyType() == PKCS11Object.RSA) {
            PKCS11RSAPublicKey pubRSA = (PKCS11RSAPublicKey)pub;
            int[] attrTypeIDRSA = new int[]{1, 256, 0, 288, 290, 3, 258};
            Object[] valRSA = new Object[]{Boolean.TRUE, PKCS11Object.RSA, PKCS11Object.PUBLIC_KEY, pubRSA.getModulus(), pubRSA.getPublicExponent(), key.getLabel(), key.getID()};
            attrTypeID = attrTypeIDRSA;
            val = valRSA;
        } else if (pub.getKeyType() == PKCS11Object.DSA) {
            PKCS11DSAPublicKey pubDSA = (PKCS11DSAPublicKey)pub;
            int[] attrTypeIDDSA = new int[]{1, 256, 0, 304, 305, 306, 17, 3, 258};
            Object[] valDSA = new Object[]{Boolean.TRUE, PKCS11Object.DSA, PKCS11Object.PUBLIC_KEY, pubDSA.getPrime(), pubDSA.getSubprime(), pubDSA.getBase(), pubDSA.getValue().toByteArray(), key.getLabel(), key.getID()};
            attrTypeID = attrTypeIDDSA;
            val = valDSA;
        } else {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Key type not RSA or DSA");
            }
            return;
        }
        session.findObjectsInit(attrTypeID, val);
        pkcs11obj = session.findObject();
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
            }
            return;
        }
        session.destroyObject(pkcs11obj);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
        }
    }

    private void deleteChain(Session session, byte[] id) {
        int[] attrTypeID = new int[]{1, 0, 258};
        int[] attrTypeSub = new int[]{1, 0, 257};
        int[] attrTypeIss = new int[]{1, 0, 129};
        byte[] subject = null;
        byte[] issuer = null;
        PKCS11Object pkcs11obj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteChain", (Object)new HexDumpEncoder().encode(id));
        }
        Object[] val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, id};
        session.findObjectsInit(attrTypeID, val);
        pkcs11obj = session.findObject();
        session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteChain", (Object)"Delete Cert not found.");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "deleteChain", "Delete Cert found.");
        }
        subject = (byte[])this.getValue(session, pkcs11obj, 257);
        issuer = (byte[])this.getValue(session, pkcs11obj, 129);
        session.destroyObject(pkcs11obj);
        if (this.bytesEquals(issuer, subject)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteChain", (Object)"Deleted Cert self-signed.");
            }
            return;
        }
        subject = issuer;
        while (true) {
            Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, issuer};
            session.findObjectsInit(attrTypeSub, attrVal);
            pkcs11obj = session.findObject();
            session.findObjectsFinal();
            if (debug != null) {
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert pkcs11obj = " + pkcs11obj);
            }
            if (pkcs11obj == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "deleteChain", "Certificate chain deletion error. Certificate not found");
                    debug.exit(16384L, (Object)className, "deleteChain");
                }
                throw new RuntimeException("Certificate chain deletion error. Certificate not found");
            }
            subject = (byte[])this.getValue(session, pkcs11obj, 257);
            issuer = (byte[])this.getValue(session, pkcs11obj, 129);
            Object[] valIss = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, subject};
            session.findObjectsInit(attrTypeIss, valIss);
            PKCS11Object delete = session.findObject();
            session.findObjectsFinal();
            if (this.bytesEquals(issuer, subject)) {
                if (debug == null) break;
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert is self-signed.");
                break;
            }
            subject = issuer;
            if (debug != null) {
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert delete = " + delete);
            }
            if (delete != null) continue;
            session.destroyObject(pkcs11obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteChain");
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase());
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
            isKey = true;
        }
        return isKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntry) {
            isCert = true;
        }
        return isCert;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = (String)e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                certElem = ((TrustedCertEntry)entry).cert;
            } else {
                if (!(entry instanceof PrivateKeyEntry) || ((PrivateKeyEntry)entry).chain == null) continue;
                certElem = ((PrivateKeyEntry)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            throw new IllegalArgumentException("LoadStoreParameter must not be null");
        }
        KeyStore.ProtectionParameter protectionParam = param.getProtectionParameter();
        if (protectionParam instanceof KeyStore.PasswordProtection) {
            char[] pwd = ((KeyStore.PasswordProtection)protectionParam).getPassword();
            this.engineLoad(null, pwd);
        } else if (protectionParam instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler handler = ((KeyStore.CallbackHandlerProtection)protectionParam).getCallbackHandler();
            Provider p1 = Security.getProvider(this.providerName);
            try {
                ((IBMPKCS11Impl)p1).login(null, handler);
            }
            catch (PKCS11Exception pex) {
                if (pex.getCode() != 256) {
                    throw new IOException(pex.getMessage());
                }
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            this.engineLoad(null, null);
        } else {
            throw new IllegalArgumentException("ProtectionParameter must be aPasswordProtection or CallbackHandlerProtection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineLoad");
        }
        Session session = null;
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            block127: {
                try {
                    CertificateFactory certFactory;
                    Object obj;
                    PKCS11Object pkcs11obj;
                    block121: {
                        session = this.sessionManager.getOpSession();
                        if (password != null) {
                            block120: {
                                try {
                                    session.login(false, new String(password));
                                }
                                catch (PKCS11Exception pex) {
                                    if (pex.getCode() == 256) break block120;
                                    throw new IOException(pex.getMessage());
                                }
                            }
                            password = null;
                        }
                        this.entries.clear();
                        pkcs11obj = null;
                        obj = null;
                        certFactory = null;
                        try {
                            certFactory = CertificateFactory.getInstance("X509", this.providerName);
                        }
                        catch (Exception ee) {
                            if (debug == null) break block121;
                            ee.printStackTrace();
                            if (debug != null) {
                                debug.exit(16384L, (Object)className, "engineLoad");
                            }
                            System.exit(1);
                        }
                    }
                    Vector<PKCS11Object> privKeys = new Vector<PKCS11Object>();
                    Vector<PKCS11Object> secretKeys = new Vector<PKCS11Object>();
                    Vector<PKCS11CertObj> certs = new Vector<PKCS11CertObj>();
                    session.findObjectsInit(null, null);
                    while ((pkcs11obj = session.findObject()) != null) {
                        obj = this.getValue(session, pkcs11obj, 0);
                        if (obj != null && ((Integer)obj).equals(PKCS11Object.PRIVATE_KEY)) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "found PRIVATE KEY");
                            }
                            privKeys.add(pkcs11obj);
                            continue;
                        }
                        if (obj != null && ((Integer)obj).equals(PKCS11Object.CERTIFICATE)) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                            }
                            certs.add(new PKCS11CertObj(pkcs11obj));
                            continue;
                        }
                        if (obj == null || !((Integer)obj).equals(PKCS11Object.SECRET_KEY)) continue;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "found SECRET_KEY");
                        }
                        secretKeys.add(pkcs11obj);
                    }
                    session.findObjectsFinal();
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + privKeys.size() + " # certs=" + certs.size() + " # secret keys=" + secretKeys.size());
                    }
                    String tmpKeyName = "privateKey";
                    int nameNum = 0;
                    int num = 0;
                    if (privKeys.size() > 0) {
                        Enumeration en = privKeys.elements();
                        boolean p = false;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                        }
                        String label = null;
                        byte[] id = null;
                        byte[] sub = null;
                        Object[] results = null;
                        while (en.hasMoreElements()) {
                            PrivateKeyInfo key;
                            PKCS11Object pobj;
                            block122: {
                                pobj = (PKCS11Object)en.nextElement();
                                results = this.getValues(session, pobj, new int[]{3, 258, 257});
                                label = (String)results[0];
                                id = (byte[])results[1];
                                sub = (byte[])results[2];
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "within the private key loop");
                                }
                                String empty = "e";
                                if (id == null) continue;
                                Integer keytype = (Integer)this.getValue(session, pobj, 256);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Key Type=" + keytype.toString());
                                }
                                key = null;
                                if (keytype.equals(PKCS11Object.RSA)) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA(...) clear");
                                        }
                                        key = new RSAPrivateKey(session, pobj);
                                    }
                                    catch (Exception ike) {
                                        try {
                                            if (debug != null) {
                                                debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA() hardware");
                                            }
                                            key = new RSAPrivateKey(session, pobj, (byte[])this.getValue(session, pobj, 258), (byte[])this.getValue(session, pobj, 257), (String)this.getValue(session, pobj, 3), (Boolean)this.getValue(session, pobj, 1), (Boolean)this.getValue(session, pobj, 259), (Boolean)this.getValue(session, pobj, 264), (Boolean)this.getValue(session, pobj, 261), (Boolean)this.getValue(session, pobj, 263), (Boolean)this.getValue(session, pobj, 354), (BigInteger)this.getValue(session, pobj, 288), (BigInteger)this.getValue(session, pobj, 290));
                                            break block122;
                                        }
                                        catch (InvalidKeyException ikee) {
                                            if (debug != null) {
                                                debug.exception(16384L, (Object)className, "engineLoad_2", (Throwable)ikee);
                                            }
                                            break block122;
                                        }
                                    }
                                }
                                if (keytype.equals(PKCS11Object.DSA)) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA(...) clear");
                                        }
                                        key = new DSAPrivateKey(session, pobj);
                                    }
                                    catch (Exception ike) {
                                        try {
                                            if (debug != null) {
                                                debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                                            }
                                            key = new DSAPrivateKey(session, pobj, (String)this.getValue(session, pobj, 3), (byte[])this.getValue(session, pobj, 258), (byte[])this.getValue(session, pobj, 257), (Boolean)this.getValue(session, pobj, 1), (Boolean)this.getValue(session, pobj, 259), (Boolean)this.getValue(session, pobj, 354));
                                            break block122;
                                        }
                                        catch (InvalidKeyException ikee) {
                                            if (debug != null) {
                                                debug.exception(16384L, (Object)className, "engineLoad_3", (Throwable)ikee);
                                            }
                                            break block122;
                                        }
                                    }
                                }
                                if (!keytype.equals(PKCS11Object.ECDSA)) continue;
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Construct ECDSA() key");
                                    }
                                    key = new PKCS11ECPrivateKey(session, pobj, null, null, null, (byte[])session.getAttrValue(pobj, 384));
                                }
                                catch (InvalidKeyException ex) {
                                    if (debug == null) break block122;
                                    debug.exception(16384L, (Object)className, "engineLoad", (Throwable)ex);
                                }
                            }
                            int j = certs.size();
                            Enumeration e = certs.elements();
                            PKCS11CertObj cobj = null;
                            ArrayList<X509Certificate> certsArray = new ArrayList<X509Certificate>();
                            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                            X509Certificate keyCert = null;
                            X509Certificate cert = null;
                            X509Certificate[] chain = null;
                            byte[] origMsg = "testmessage_a very long test message".getBytes();
                            for (int k = 0; k < j; ++k) {
                                block124: {
                                    Signature sig;
                                    PublicKey pubkey;
                                    block123: {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "going through cert objects");
                                        }
                                        cobj = (PKCS11CertObj)e.nextElement();
                                        byte[] tid = cobj.getKeyIdentifier(session);
                                        if (debug != null && tid != null) {
                                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineLoad", "certificate object key identifier " + new HexDumpEncoder().encode(tid) + ", private key object key identifier " + new HexDumpEncoder().encode(id));
                                        }
                                        if (tid == null || !this.bytesEquals(id, tid)) continue;
                                        cert = cobj.getX509Certificate(certFactory, session);
                                        if (cert == null) {
                                            throw new IOException("KeyStore error: certificate object handle is invalid");
                                        }
                                        pubkey = cert.getPublicKey();
                                        sig = null;
                                        try {
                                            sig = Signature.getInstance(key.getAlgorithm(), this.providerName);
                                        }
                                        catch (Exception ex) {
                                            sig = Signature.getInstance(key.getAlgorithm());
                                            if (debug == null) break block123;
                                            debug.text(16384L, (Object)className, "engineLoad", "Error creating signature: " + ex.getMessage());
                                        }
                                    }
                                    try {
                                        sig.initSign((PrivateKey)key);
                                        sig.update(origMsg);
                                        byte[] signature = sig.sign();
                                        sig.initVerify(pubkey);
                                        sig.update(origMsg);
                                        if (!sig.verify(signature)) continue;
                                        keyCert = cert;
                                        if (debug != null) {
                                            debug.text(16384L, (Object)"PKCS11KeyStore", "engineLoad", "signature verified, found matched key pair");
                                        }
                                    }
                                    catch (Exception ex) {
                                        if (debug == null) break block124;
                                        debug.text(16384L, (Object)className, "engineLoad", "Error checking signature: " + ex.getMessage());
                                    }
                                }
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert at pos" + k + " # of certs now = " + certsArray.size());
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert = " + keyCert);
                                }
                                certsArray.add(cert);
                                trustAnchors.add(new TrustAnchor(cert, null));
                                if (keyCert == null) continue;
                                try {
                                    CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                                    X509CertSelector targetConstraints = new X509CertSelector();
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "building certpath");
                                    }
                                    targetConstraints.setCertificate(keyCert);
                                    PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)targetConstraints);
                                    params.setRevocationEnabled(false);
                                    params.setMaxPathLength(-1);
                                    CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(certsArray);
                                    CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "IBMCertPath");
                                    params.addCertStore(store);
                                    try {
                                        PKIXCertPathBuilderResult cpresult = (PKIXCertPathBuilderResult)cpb.build(params);
                                        CertPath cp = cpresult.getCertPath();
                                        if (cp == null) break;
                                        List<? extends Certificate> cpcerts = cp.getCertificates();
                                        int i = 0;
                                        chain = new X509Certificate[cpcerts.size() + 1];
                                        Iterator<? extends Certificate> cpIterator = cpcerts.iterator();
                                        while (cpIterator.hasNext()) {
                                            chain[i++] = (X509Certificate)cpIterator.next();
                                        }
                                        chain[i] = cpresult.getTrustAnchor().getTrustedCert();
                                        break;
                                    }
                                    catch (CertPathBuilderException cpbe) {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad_0", "could not build CertPath for certificate " + cpbe.getMessage());
                                        }
                                        chain = null;
                                        continue;
                                    }
                                }
                                catch (Exception ex) {
                                    if (debug == null) break;
                                    debug.exception(16384L, (Object)className, "engineLoad_1", (Throwable)ex);
                                    break;
                                }
                            }
                            PrivateKeyEntry keyEntry = new PrivateKeyEntry();
                            keyEntry.key = key;
                            keyEntry.keyObject = pobj;
                            keyEntry.chain = chain;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "Entry: \n key =" + key.toString() + "\nkeyObject =" + pobj + "\nchain = " + chain + "\nLabel = " + label);
                            }
                            if (label != null && label.length() != 0) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label != null");
                                }
                                if (!this.entries.containsKey(label.toLowerCase())) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                    }
                                    this.entries.put(label.toLowerCase(), keyEntry);
                                    if (debug == null) continue;
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + label.toLowerCase() + "] to entries");
                                    continue;
                                }
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                }
                                boolean foundLabel = false;
                                while (!foundLabel) {
                                    String newLabel = label + "key" + num;
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "finding label: " + newLabel);
                                    }
                                    if (this.entries.get(newLabel.toLowerCase()) == null) {
                                        this.entries.put(newLabel.toLowerCase(), keyEntry);
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + newLabel.toLowerCase() + "] to entries");
                                        }
                                        foundLabel = true;
                                        continue;
                                    }
                                    ++num;
                                }
                                continue;
                            }
                            boolean foundName = false;
                            while (!foundName) {
                                String keyName = tmpKeyName + nameNum;
                                if (!this.entries.containsKey(keyName.toLowerCase())) {
                                    this.entries.put(keyName.toLowerCase(), keyEntry);
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + keyName.toLowerCase() + "] to entries");
                                    }
                                    foundName = true;
                                    continue;
                                }
                                ++nameNum;
                            }
                        }
                        privKeys.removeAllElements();
                    }
                    tmpKeyName = "secretKey";
                    nameNum = 0;
                    num = 0;
                    if (secretKeys.size() > 0) {
                        int j = secretKeys.size();
                        Enumeration e = secretKeys.elements();
                        block50: for (int k = 0; k < j; ++k) {
                            GeneralKey key;
                            String label;
                            PKCS11Object sobj;
                            block126: {
                                Object[] results;
                                Integer keytype;
                                block125: {
                                    sobj = null;
                                    label = null;
                                    keytype = null;
                                    results = null;
                                    try {
                                        sobj = (PKCS11Object)e.nextElement();
                                        results = this.getValues(session, sobj, new int[]{3, 256});
                                        label = (String)results[0];
                                        if (debug == null) break block125;
                                        debug.text(16384L, (Object)className, "engineLoad", "sobj: " + sobj);
                                    }
                                    catch (NoSuchElementException nsee) {
                                        k = j;
                                        continue;
                                    }
                                }
                                keytype = (Integer)results[1];
                                key = null;
                                try {
                                    switch (keytype) {
                                        case 19: {
                                            key = new GeneralKey(session, sobj, "DES");
                                            break block126;
                                        }
                                        case 21: {
                                            key = new GeneralKey(session, sobj, "DESede");
                                            break block126;
                                        }
                                        case 18: {
                                            key = new GeneralKey(session, sobj, "RC4");
                                            break block126;
                                        }
                                        case 31: {
                                            key = new GeneralKey(session, sobj, "AES");
                                            break block126;
                                        }
                                        case 16: {
                                            key = new GeneralKey(session, sobj, "Generic");
                                            break block126;
                                        }
                                        case 32: {
                                            key = new GeneralKey(session, sobj, "BLOWFISH");
                                            break block126;
                                        }
                                        default: {
                                            if (debug == null) continue block50;
                                            debug.text(16384L, (Object)className, "engineLoad_4", "Key Type not supported. " + keytype);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                catch (Exception ikee) {
                                    if (debug == null) break block126;
                                    debug.exception(16384L, (Object)className, "engineLoad_4.1", (Throwable)ikee);
                                }
                            }
                            SecretKeyEntry keyEntry = new SecretKeyEntry();
                            keyEntry.key = key;
                            keyEntry.keyObject = sobj;
                            if (debug != null) {
                                try {
                                    debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + ((Object)key).toString() + "\nkeyObject =" + sobj + "\nLabel = " + label);
                                }
                                catch (Exception ex) {
                                    debug.exception(16384L, (Object)className, "engineLoad", (Throwable)ex);
                                }
                            }
                            if (label != null && label.length() != 0) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label != null");
                                }
                                if (this.entries.get(label.toLowerCase()) == null) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                    }
                                    this.entries.put(label.toLowerCase(), keyEntry);
                                    if (debug == null) continue;
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + label.toLowerCase() + "] to entries");
                                    continue;
                                }
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                }
                                boolean foundLabel = false;
                                while (!foundLabel) {
                                    String newLabel;
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                    }
                                    if (this.entries.get((newLabel = label + "sec" + num).toLowerCase()) == null) {
                                        this.entries.put(newLabel.toLowerCase(), keyEntry);
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + newLabel.toLowerCase() + "] to entries");
                                        }
                                        foundLabel = true;
                                        continue;
                                    }
                                    ++num;
                                }
                                continue;
                            }
                            boolean foundName = false;
                            while (!foundName) {
                                String keyName = tmpKeyName + nameNum;
                                if (!this.entries.containsKey(keyName.toLowerCase())) {
                                    this.entries.put(keyName.toLowerCase(), keyEntry);
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + keyName.toLowerCase() + "] to entries");
                                    }
                                    foundName = true;
                                    continue;
                                }
                                ++nameNum;
                            }
                        }
                        secretKeys.removeAllElements();
                    }
                    String tmpCertName = "cert";
                    nameNum = 0;
                    if (certs.size() <= 0) break block127;
                    int j = certs.size();
                    Enumeration e = certs.elements();
                    for (int k = 0; k < j; ++k) {
                        PKCS11CertObj cobj;
                        block128: {
                            cobj = null;
                            try {
                                cobj = (PKCS11CertObj)e.nextElement();
                                if (debug == null) break block128;
                                debug.text(16384L, (Object)className, "engineLoad", "cobj: " + cobj);
                            }
                            catch (NoSuchElementException nsee) {
                                k = j;
                                continue;
                            }
                        }
                        String label = cobj.getLabel(session);
                        TrustedCertEntry ce = new TrustedCertEntry();
                        ce.cert = cobj.getX509Certificate(certFactory, session);
                        ce.certObject = cobj.getPKCS11Object();
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + ce.cert.toString() + "\n CertObject =" + cobj + "\nLabel = " + label);
                        }
                        if (label != null && label.length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(label.toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(label.toLowerCase(), ce);
                                if (debug == null) continue;
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + label.toLowerCase() + "] to entries");
                                continue;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                            }
                            boolean foundLabel = false;
                            while (!foundLabel) {
                                String newLabel;
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                }
                                if (this.entries.get((newLabel = label + "cert" + num).toLowerCase()) == null) {
                                    this.entries.put(newLabel.toLowerCase(), ce);
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + newLabel.toLowerCase() + "] to entries");
                                    }
                                    foundLabel = true;
                                    continue;
                                }
                                ++num;
                            }
                            continue;
                        }
                        boolean foundName = false;
                        while (!foundName) {
                            String keyName = tmpCertName + nameNum;
                            if (!this.entries.containsKey(keyName.toLowerCase())) {
                                this.entries.put(keyName.toLowerCase(), ce);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + keyName.toLowerCase() + "] to entries");
                                }
                                foundName = true;
                                continue;
                            }
                            ++nameNum;
                        }
                    }
                    certs.removeAllElements();
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineLoad");
        }
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    private Object[] getValues(Session session, PKCS11Object pkcs11obj, int[] attrs) {
        return session.getAttrValues(pkcs11obj, attrs);
    }

    private Object[] getAttributes(PKCS11Object pkcs11obj) {
        return null;
    }

    private boolean bytesEquals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected void finalize() {
    }

    class PKCS11CertObj {
        private PKCS11Object certObj;
        private X509Certificate cert;
        private byte[] keyID;
        private String label;

        PKCS11CertObj(PKCS11Object obj) {
            this.certObj = obj;
        }

        public X509Certificate getX509Certificate(CertificateFactory certFactory, Session session) throws IOException, CertificateException {
            if (this.cert == null) {
                byte[] bytearray = (byte[])PKCS11KeyStore.this.getValue(session, this.certObj, 17);
                if (bytearray == null) {
                    return null;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(bytearray);
                this.cert = (X509Certificate)certFactory.generateCertificate(bais);
            }
            return this.cert;
        }

        public byte[] getKeyIdentifier(Session session) {
            if (this.keyID == null) {
                Object[] result = PKCS11KeyStore.this.getValues(session, this.certObj, new int[]{258, 3});
                this.keyID = (byte[])result[0];
                this.label = (String)result[1];
            }
            return this.keyID;
        }

        public PKCS11Object getPKCS11Object() {
            return this.certObj;
        }

        public String getLabel(Session session) {
            if (this.label == null) {
                this.label = (String)PKCS11KeyStore.this.getValue(session, this.certObj, 3);
            }
            return this.label;
        }
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;
        Session session;

        TrustedCertEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }
}

