/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.CompilationMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryManagerMXBeanImpl;
import com.ibm.lang.management.OpenTypeMappingIHandler;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    private static MBeanServer platformServer;
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    private static Map<String, String> interfaceNameLookupTable;
    private static Set<String> multiInstanceBeanNames;

    static {
        interfaceNameLookupTable = new HashMap<String, String>();
        interfaceNameLookupTable.put("java.lang.management.ClassLoadingMXBean", CLASS_LOADING_MXBEAN_NAME);
        interfaceNameLookupTable.put("java.lang.management.MemoryMXBean", MEMORY_MXBEAN_NAME);
        interfaceNameLookupTable.put("java.lang.management.ThreadMXBean", THREAD_MXBEAN_NAME);
        interfaceNameLookupTable.put("java.lang.management.RuntimeMXBean", RUNTIME_MXBEAN_NAME);
        interfaceNameLookupTable.put("java.lang.management.OperatingSystemMXBean", OPERATING_SYSTEM_MXBEAN_NAME);
        interfaceNameLookupTable.put("java.lang.management.CompilationMXBean", COMPILATION_MXBEAN_NAME);
        interfaceNameLookupTable.put("java.lang.management.GarbageCollectorMXBean", GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("java.lang.management.MemoryManagerMXBean", MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("java.lang.management.MemoryPoolMXBean", MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("java.util.logging.LoggingMXBean", "java.util.logging:type=Logging");
        interfaceNameLookupTable.put("com.ibm.lang.management.GarbageCollectorMXBean", GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("com.ibm.lang.management.MemoryMXBean", MEMORY_MXBEAN_NAME);
        interfaceNameLookupTable.put("com.ibm.lang.management.MemoryPoolMXBean", MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("com.ibm.lang.management.OperatingSystemMXBean", OPERATING_SYSTEM_MXBEAN_NAME);
        multiInstanceBeanNames = new HashSet<String>();
        multiInstanceBeanNames.add("java.lang.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("com.ibm.lang.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("java.lang.management.MemoryManagerMXBean");
        multiInstanceBeanNames.add("java.lang.management.MemoryPoolMXBean");
        multiInstanceBeanNames.add("com.ibm.lang.management.MemoryPoolMXBean");
    }

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementUtils.getClassLoadingBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementUtils.getCompliationBean();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementUtils.getGarbageCollectorMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementUtils.getMemoryManagerMXBeans();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementUtils.getMemoryBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementUtils.getMemoryPoolMXBeans();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementUtils.getOperatingSystemBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer getPlatformMBeanServer() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        Class<ManagementFactory> clazz = ManagementFactory.class;
        synchronized (ManagementFactory.class) {
            if (platformServer == null) {
                platformServer = MBeanServerFactory.createMBeanServer();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ManagementFactory.registerPlatformBeans(platformServer);
                        return null;
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return platformServer;
        }
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementUtils.getRuntimeBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementUtils.getThreadBean();
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection connection, String mxbeanName, Class<T> mxbeanInterface) throws IOException {
        ManagementFactory.verifyNamedMXBean(mxbeanName, mxbeanInterface);
        Object result = null;
        Class[] interfaces = null;
        interfaces = ManagementUtils.isANotificationEmitter(mxbeanInterface) ? new Class[]{mxbeanInterface, NotificationEmitter.class} : new Class[]{mxbeanInterface};
        result = Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)new OpenTypeMappingIHandler(connection, mxbeanInterface.getName(), mxbeanName));
        return (T)result;
    }

    private static void verifyNamedMXBean(String mxbeanName, Class<?> mxbeanInterface) {
        String mxbeanInterfaceName = mxbeanInterface.getName();
        String expectedObjectName = interfaceNameLookupTable.get(mxbeanInterfaceName);
        if (multiInstanceBeanNames.contains(mxbeanInterfaceName)) {
            if (!mxbeanName.startsWith(expectedObjectName)) {
                try {
                    boolean isKeySame;
                    ObjectName on1 = new ObjectName(expectedObjectName);
                    ObjectName on2 = new ObjectName(mxbeanName);
                    String keyProperty1 = on1.getKeyProperty("type");
                    String keyProperty2 = on2.getKeyProperty("type");
                    boolean bl = keyProperty1 == null ? keyProperty2 == null : (isKeySame = keyProperty1.equals(keyProperty2));
                    if (on1.getDomain().equals(on2.getDomain()) && isKeySame) {
                        return;
                    }
                }
                catch (MalformedObjectNameException on1) {
                }
                catch (NullPointerException on1) {
                    // empty catch block
                }
                throw new IllegalArgumentException(String.valueOf(mxbeanName) + " is not an instance of interface " + mxbeanInterfaceName);
            }
        } else {
            boolean isEquals;
            boolean bl = expectedObjectName == null ? mxbeanName == null : (isEquals = expectedObjectName.equals(mxbeanName));
            if (!isEquals) {
                throw new IllegalArgumentException(String.valueOf(mxbeanName) + " is not an instance of interface " + mxbeanInterfaceName);
            }
        }
    }

    private static void registerPlatformBeans(MBeanServer platformServer) {
        block23: {
            try {
                List<MemoryManagerMXBean> mmBeanList;
                List<GarbageCollectorMXBean> gcBeanList;
                List<MemoryPoolMXBean> mpBeanList;
                CompilationMXBeanImpl cBean;
                ObjectName oName = new ObjectName(CLASS_LOADING_MXBEAN_NAME);
                if (!platformServer.isRegistered(oName)) {
                    platformServer.registerMBean(ManagementUtils.getClassLoadingBean(), oName);
                }
                if (!platformServer.isRegistered(oName = new ObjectName("java.util.logging:type=Logging"))) {
                    platformServer.registerMBean(ManagementUtils.getLoggingBean(), oName);
                }
                if (!platformServer.isRegistered(oName = new ObjectName(MEMORY_MXBEAN_NAME))) {
                    platformServer.registerMBean(ManagementUtils.getMemoryBean(), oName);
                }
                if (!platformServer.isRegistered(oName = new ObjectName(THREAD_MXBEAN_NAME))) {
                    platformServer.registerMBean(ManagementUtils.getThreadBean(), oName);
                }
                if (!platformServer.isRegistered(oName = new ObjectName(RUNTIME_MXBEAN_NAME))) {
                    platformServer.registerMBean(ManagementUtils.getRuntimeBean(), oName);
                }
                if (!platformServer.isRegistered(oName = new ObjectName(OPERATING_SYSTEM_MXBEAN_NAME))) {
                    platformServer.registerMBean(ManagementUtils.getOperatingSystemBean(), oName);
                }
                if ((cBean = ManagementUtils.getCompliationBean()) != null && !platformServer.isRegistered(oName = new ObjectName(COMPILATION_MXBEAN_NAME))) {
                    platformServer.registerMBean(cBean, oName);
                }
                if ((mpBeanList = ManagementUtils.getMemoryPoolMXBeans()) != null) {
                    for (MemoryPoolMXBean mpBean : mpBeanList) {
                        oName = new ObjectName("java.lang:type=MemoryPool,name=" + mpBean.getName());
                        if (platformServer.isRegistered(oName)) continue;
                        platformServer.registerMBean(mpBean, oName);
                    }
                }
                if ((gcBeanList = ManagementUtils.getGarbageCollectorMXBeans()) != null) {
                    for (GarbageCollectorMXBean gcBean : gcBeanList) {
                        oName = new ObjectName("java.lang:type=GarbageCollector,name=" + gcBean.getName());
                        if (platformServer.isRegistered(oName)) continue;
                        platformServer.registerMBean(gcBean, oName);
                    }
                }
                if ((mmBeanList = ManagementUtils.getMemoryManagerMXBeans()) != null) {
                    for (MemoryManagerMXBean mmBean : mmBeanList) {
                        if (!mmBean.getClass().equals(MemoryManagerMXBeanImpl.class) || platformServer.isRegistered(oName = new ObjectName("java.lang:type=MemoryManager,name=" + mmBean.getName()))) continue;
                        platformServer.registerMBean(mmBean, oName);
                    }
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (MBeanRegistrationException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (NotCompliantMBeanException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (MalformedObjectNameException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (NullPointerException e) {
                if (!ManagementUtils.VERBOSE_MODE) break block23;
                e.printStackTrace(System.err);
            }
        }
    }
}

