/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.C14nTransformer;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTTransformer
extends TransformBase
implements Constants {
    static TransformerFactory s_factory;
    private Node ssnode;

    static synchronized TransformerFactory getFactory() {
        if (s_factory != null) {
            return s_factory;
        }
        s_factory = TransformerFactory.newInstance();
        return s_factory;
    }

    public void init(TransformParameterSpec s) throws InvalidAlgorithmParameterException {
        if (s == null || !(s instanceof XSLTTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Need an XSLTTransformParameterSpec instance");
        }
        this.spec = s;
        XSLTTransformParameterSpec xsltspec = (XSLTTransformParameterSpec)this.spec;
        this.ssnode = ((DOMStructure)xsltspec.getStylesheet()).getNode();
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext xcontext) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        Element el = (Element)((DOMStructure)parent).getNode();
        if (this.spec == null) {
            throw new MarshalException("Invalid state: no param");
        }
        XSLTTransformParameterSpec xspec = (XSLTTransformParameterSpec)this.spec;
        XMLStructure stylesheet = xspec.getStylesheet();
        if (!(stylesheet instanceof DOMStructure)) {
            throw new MarshalException("This XSLT Transform implementation only supports DOMStructure");
        }
        Node temp = ((DOMStructure)stylesheet).getNode();
        Node ssnode = temp instanceof Document ? ((Document)temp).getDocumentElement() : temp;
        el.appendChild(el.getOwnerDocument().importNode(ssnode, true));
    }

    public void init(XMLStructure parent, XMLCryptoContext xcontext) throws InvalidAlgorithmParameterException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        Node ssElement = null;
        Element node = (Element)((DOMStructure)parent).getNode();
        try {
            Node child = DOMUtil.getFirstChild2(node);
            while (child != null) {
                if (!Unmarshalling.isIgnorableNode(child)) {
                    if (child.getNodeType() != 1) {
                        throw new InvalidAlgorithmParameterException("XSLT Transform does not support specified node: " + child.getNodeName());
                    }
                    if (!"http://www.w3.org/1999/XSL/Transform".equals(child.getNamespaceURI()) || !"stylesheet".equals(child.getLocalName())) {
                        throw new InvalidAlgorithmParameterException("XSLT Transform does not support specified parameter element: " + child.getNodeName());
                    }
                    if (ssElement != null) {
                        throw new InvalidAlgorithmParameterException("<xsl:stylesheet> element is already processed.");
                    }
                    ssElement = child;
                }
                child = DOMUtil.getNextSibling2(child);
            }
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
        XSLTTransformParameterSpec spec = new XSLTTransformParameterSpec(new DOMStructure(ssElement));
        this.init(spec);
    }

    public Data transform(Data in, XMLCryptoContext xcontext) throws TransformException {
        ByteArrayOutputStream out;
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            if (in instanceof NodeSetData) {
                C14nTransformer ts = new C14nTransformer();
                ((TransformService)ts).init(null);
                in = ts.transform(in, xcontext);
            }
            Transformer tr = XSLTTransformer.getFactory().newTransformer(new DOMSource(this.ssnode));
            out = new ByteArrayOutputStream();
            tr.transform(new StreamSource(((OctetStreamData)in).getOctetStream()), new StreamResult(out));
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
        return new BinaryData(out.toByteArray());
    }
}

