/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Base64Transformer
extends TransformBase {
    private static final int FETCH_BUFFER_SIZE = 2048;

    public Data transform(Data in, XMLCryptoContext xcontext) throws TransformException {
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        if (in instanceof BinaryData) {
            byte[] input = ((BinaryData)in).getData();
            return new BinaryData(Base64.decode(input));
        }
        if (in instanceof OctetStreamData) {
            InputStream is = ((OctetStreamData)in).getOctetStream();
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int readLength;
                while ((readLength = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, readLength);
                }
                baos.close();
            }
            catch (IOException ioe) {
                throw new TransformException(ioe);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            byte[] content = baos.toByteArray();
            return new BinaryData(Base64.decode(content));
        }
        if (in instanceof NodeSetData) {
            Iterator iter = ((NodeSetData)in).iterator();
            StringBuffer buffer = new StringBuffer();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof Text)) continue;
                buffer.append(((Node)obj).getNodeValue());
            }
            byte[] content = Base64.decode(new String(buffer));
            return new BinaryData(content);
        }
        throw new TransformException("Internal Error: Unexpected class: " + in.getClass().getName());
    }
}

