/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Node;

class SignedInfoImpl
extends XMLStructureImpl
implements SignedInfo {
    private static final int FETCH_BUFFER_SIZE = 4096;
    List content;
    private String id;
    private CanonicalizationMethod c14nMethod;
    private SignatureMethod signatureMethod;
    private byte[] canonicalized;
    private KeySelectorResult keyResult;
    private boolean validated;
    private boolean cachedResult;
    private Node node;
    static /* synthetic */ Class class$com$ibm$xml$crypto$dsig$dom$TransformContext;

    SignedInfoImpl(AlgorithmFactory f, CanonicalizationMethod cm, SignatureMethod sm, List references, String id) {
        super(f);
        if (cm == null) {
            throw new NullPointerException("CanonicalizationMethod must not be null.");
        }
        this.c14nMethod = cm;
        if (sm == null) {
            throw new NullPointerException("SignatureMethod must not be null.");
        }
        this.signatureMethod = sm;
        if (references == null) {
            throw new NullPointerException("Reference List must not be null.");
        }
        if (references.size() == 0) {
            throw new IllegalArgumentException("Reference List is empty.");
        }
        this.content = new ArrayList(references.size());
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            Reference obj = (Reference)iter.next();
            this.content.add(obj);
        }
        this.id = id;
        this.canonicalized = null;
        this.node = null;
        this.keyResult = null;
        this.validated = false;
        this.cachedResult = false;
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return Collections.unmodifiableList(this.content);
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.c14nMethod;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public InputStream getCanonicalizedData() {
        if (this.canonicalized == null) {
            return null;
        }
        return new ByteArrayInputStream(this.canonicalized);
    }

    KeySelectorResult getKeySelectorResult() {
        return this.keyResult;
    }

    void setSignatureNode(Node n) {
        for (int i = 0; i < this.content.size(); ++i) {
            ReferenceImpl ref = (ReferenceImpl)this.content.get(i);
            ref.setSignatureNode(n);
        }
    }

    void setNode(Node n) {
        this.node = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] sign(XMLSignContext scontext, KeyInfo ki) throws XMLSignatureException {
        byte[] result;
        InputStream is;
        block17: {
            KeySelector selector = scontext.getKeySelector();
            try {
                this.keyResult = selector.select(ki, KeySelector.Purpose.SIGN, this.signatureMethod, scontext);
            }
            catch (KeySelectorException kse) {
                throw new XMLSignatureException(kse);
            }
            Key key = this.keyResult.getKey();
            boolean saveCanonicalized = true;
            ByteArrayOutputStream baos = null;
            OctetStreamData data = this.canonicalize(scontext);
            SignatureEngine signer = null;
            is = null;
            try {
                try {
                    signer = this.afactory.getSignatureEngine(this.signatureMethod.getAlgorithm());
                    signer.setParameter(this.signatureMethod.getParameterSpec());
                    signer.initSign(key);
                    if (data instanceof BinaryData) {
                        this.canonicalized = ((BinaryData)data).getData();
                        signer.update(this.canonicalized);
                    } else {
                        int readLength;
                        is = data.getOctetStream();
                        if (saveCanonicalized) {
                            baos = new ByteArrayOutputStream();
                        }
                        byte[] buffer = new byte[4096];
                        while ((readLength = is.read(buffer)) != -1) {
                            signer.update(buffer, 0, readLength);
                            if (baos == null) continue;
                            baos.write(buffer, 0, readLength);
                        }
                        if (baos != null) {
                            baos.close();
                            this.canonicalized = baos.toByteArray();
                        }
                    }
                    result = signer.sign();
                }
                catch (GeneralSecurityException gse) {
                    throw new XMLSignatureException(gse);
                }
                catch (IOException ioe) {
                    throw new XMLSignatureException(ioe);
                }
                Object var15_14 = null;
                if (signer == null) break block17;
                this.afactory.releaseSignatureEngine(signer);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (signer != null) {
                    this.afactory.releaseSignatureEngine(signer);
                }
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (is == null) return result;
        try {}
        catch (IOException ioe) {}
        is.close();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean validate(XMLValidateContext vcontext, KeyInfo ki, byte[] sv) throws XMLSignatureException {
        InputStream is;
        block18: {
            if (this.validated) {
                return this.cachedResult;
            }
            KeySelector selector = vcontext.getKeySelector();
            try {
                this.keyResult = selector.select(ki, KeySelector.Purpose.VERIFY, this.signatureMethod, vcontext);
            }
            catch (KeySelectorException kse) {
                throw new XMLSignatureException(kse);
            }
            Key key = this.keyResult.getKey();
            boolean saveCanonicalized = true;
            ByteArrayOutputStream baos = null;
            OctetStreamData data = this.canonicalize(vcontext);
            SignatureEngine signer = null;
            is = null;
            try {
                try {
                    signer = this.afactory.getSignatureEngine(this.signatureMethod.getAlgorithm());
                    signer.setParameter(this.signatureMethod.getParameterSpec());
                    signer.initVerify(key);
                    if (data instanceof BinaryData) {
                        this.canonicalized = ((BinaryData)data).getData();
                        signer.update(this.canonicalized);
                    } else {
                        int readLength;
                        is = data.getOctetStream();
                        if (saveCanonicalized) {
                            baos = new ByteArrayOutputStream();
                        }
                        byte[] buffer = new byte[4096];
                        while ((readLength = is.read(buffer)) != -1) {
                            signer.update(buffer, 0, readLength);
                            if (baos == null) continue;
                            baos.write(buffer, 0, readLength);
                        }
                        if (baos != null) {
                            baos.close();
                            this.canonicalized = baos.toByteArray();
                        }
                    }
                    this.cachedResult = signer.verify(sv);
                    this.validated = true;
                }
                catch (GeneralSecurityException gse) {
                    throw new XMLSignatureException(gse);
                }
                catch (IOException ioe) {
                    throw new XMLSignatureException(ioe);
                }
                Object var15_14 = null;
                if (signer == null) break block18;
                this.afactory.releaseSignatureEngine(signer);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (signer != null) {
                    this.afactory.releaseSignatureEngine(signer);
                }
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (is == null) return this.cachedResult;
        try {}
        catch (IOException ioe) {}
        is.close();
        return this.cachedResult;
    }

    private OctetStreamData canonicalize(XMLCryptoContext context) throws XMLSignatureException {
        Class clazz;
        Data data;
        if (this.node == null) {
            throw new XMLSignatureException("This SignedInfo is not signed yet.");
        }
        Node signedInfo = this.node;
        TransformContext tcontext = new TransformContext(this.afactory, null);
        context.put(class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = SignedInfoImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext, tcontext);
        try {
            try {
                NodeSetData nodes = TransformUtil.toNodeSet(signedInfo, true);
                data = this.c14nMethod.transform(nodes, context);
                if (!(data instanceof OctetStreamData)) {
                    throw new XMLSignatureException("Internal Error: The result of c14n must be OctetStreamData");
                }
                Object var8_6 = null;
                clazz = class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = SignedInfoImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext;
            }
            catch (Exception e) {
                throw new XMLSignatureException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            context.put(class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = SignedInfoImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext, null);
            throw throwable;
        }
        context.put(clazz, null);
        return (OctetStreamData)data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

