/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonPatternMatchers {
    public static final Matcher whitespace = CommonPatternMatchers.generateMatcher("[ \\t\\n\\r][ \\t\\n\\r]*");
    public static final Matcher allButLineFeed = CommonPatternMatchers.generateMatcher("[^\\n\\r]*");
    public static final Matcher quoted_stringvalue = CommonPatternMatchers.generateMatcher("\"[^\\n\\r]*?\"");
    public static final Matcher alpha_numeric_underscore_ascii_attribute = CommonPatternMatchers.generateMatcher("[a-zA-Z_][a-zA-Z0-9_]*");
    public static final Matcher non_whitespace_attribute = CommonPatternMatchers.generateMatcher("[^ \\t\\n\\r][^ \\t\\n\\r]*");
    public static final Matcher hex_0x = CommonPatternMatchers.generateMatcher("0x[0-9A-Fa-f][0-9A-Fa-f]*");
    public static final Matcher hex = CommonPatternMatchers.generateMatcher("[0-9A-Fa-f][0-9A-Fa-f]*");
    public static final Matcher lettervalue = CommonPatternMatchers.generateMatcher("[a-zA-Z][a-zA-Z]*");
    public static final Matcher dec = CommonPatternMatchers.generateMatcher("[0-9][0-9]*");
    public static final Matcher quotation = CommonPatternMatchers.generateMatcher("\"");
    public static final Matcher colon = CommonPatternMatchers.generateMatcher(":");
    public static final Matcher equals = CommonPatternMatchers.generateMatcher("=");
    public static final Matcher comma = CommonPatternMatchers.generateMatcher(",");
    public static final Matcher at_symbol = CommonPatternMatchers.generateMatcher("@");
    public static final Matcher dot = CommonPatternMatchers.generateMatcher("\\.");
    public static final Matcher forward_slash = CommonPatternMatchers.generateMatcher("/");
    public static final Matcher dash = CommonPatternMatchers.generateMatcher("-");
    public static final Matcher open_paren = CommonPatternMatchers.generateMatcher("\\(");
    public static final Matcher close_paren = CommonPatternMatchers.generateMatcher("\\)");
    private static final String pattern_java_name = "[a-zA-Z_$][a-zA-Z_$0-9]*";
    private static final String pattern_java_absolute_name = "[a-zA-Z_$][a-zA-Z_$0-9]*(/[a-zA-Z_$][a-zA-Z_$0-9]*)*";
    private static final String pattern_sov_java_absolute_method_name = "[a-zA-Z_$][a-zA-Z_$0-9]*(\\.[a-zA-Z_$][a-zA-Z_$0-9]*)*";
    private static final String pattern_java_absolute_method_name = "[a-zA-Z_$][a-zA-Z_$0-9]*(/[a-zA-Z_$][a-zA-Z_$0-9]*)*\\.[a-zA-Z_$][a-zA-Z_$0-9]*";
    public static final Matcher java_name = CommonPatternMatchers.generateMatcher("[a-zA-Z_$][a-zA-Z_$0-9]*");
    public static final Matcher java_absolute_name = CommonPatternMatchers.generateMatcher("[a-zA-Z_$][a-zA-Z_$0-9]*(/[a-zA-Z_$][a-zA-Z_$0-9]*)*");
    public static final Matcher java_absolute_method_name = CommonPatternMatchers.generateMatcher("[a-zA-Z_$][a-zA-Z_$0-9]*(/[a-zA-Z_$][a-zA-Z_$0-9]*)*\\.[a-zA-Z_$][a-zA-Z_$0-9]*");
    public static final Matcher java_absolute_name_array = CommonPatternMatchers.generateMatcher("[\\[]*[a-zA-Z_$][a-zA-Z_$0-9]*(/[a-zA-Z_$][a-zA-Z_$0-9]*)*");
    public static final Matcher java_sov_absolute_method_name = CommonPatternMatchers.generateMatcher("[a-zA-Z_$][a-zA-Z_$0-9]*(\\.[a-zA-Z_$][a-zA-Z_$0-9]*)*");
    public static final Matcher java_file_name = CommonPatternMatchers.generateMatcher("[a-zA-Z_$][a-zA-Z_$0-9]*(/[a-zA-Z_$][a-zA-Z_$0-9]*)*.java");
    public static Matcher[] hexadecimal = new Matcher[]{hex_0x, hex};
    public static Matcher at_string = CommonPatternMatchers.generateMatcher("at", 2);
    public static Matcher build_string = CommonPatternMatchers.generateMatcher("build", 2);
    public static Matcher enabled_string = CommonPatternMatchers.generateMatcher("enabled", 2);
    public static Matcher disabled_string = CommonPatternMatchers.generateMatcher("disabled", 2);
    public static Matcher bits64 = CommonPatternMatchers.generateMatcher("64");
    public static Matcher s390 = CommonPatternMatchers.generateMatcher("s390", 2);

    public static Matcher generateMatcher(String pattern) {
        return Pattern.compile(pattern).matcher("");
    }

    public static Matcher generateMatcher(String pattern, int flag) {
        return Pattern.compile(pattern, flag).matcher("");
    }
}

