/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaStaticField
extends JavaField {
    private String _value;

    public JavaStaticField(JavaRuntime runtime, String name, String sig, int modifiers, String value, long declaringClassID) {
        super(runtime, name, sig, modifiers, declaringClassID);
        if (null == runtime) {
            throw new IllegalArgumentException("A Java static field cannot exist in a null Java VM");
        }
        this._value = value;
    }

    protected Object getReferenceType(JavaObject object) throws CorruptDataException, MemoryAccessException {
        String sig = this.getSignature();
        if (sig.startsWith("L") || sig.startsWith("[")) {
            try {
                ImagePointer pointer = this.getDeclaringClass().getID().getAddressSpace().getPointer(this.getLong(null));
                return this._javaVM.getObjectAtAddress(pointer);
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (DataUnavailable e) {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean getBoolean(JavaObject object) throws CorruptDataException, MemoryAccessException {
        return this._value.charAt(0) != '0';
    }

    public byte getByte(JavaObject object) throws CorruptDataException, MemoryAccessException {
        return (byte)this.parse(2);
    }

    public char getChar(JavaObject object) throws CorruptDataException, MemoryAccessException {
        return (char)this.parse(4);
    }

    public double getDouble(JavaObject object) throws CorruptDataException, MemoryAccessException {
        long temp = this.parse(16);
        return Double.longBitsToDouble(temp);
    }

    public float getFloat(JavaObject object) throws CorruptDataException, MemoryAccessException {
        int temp = (int)this.parse(8);
        return Float.intBitsToFloat(temp);
    }

    public int getInt(JavaObject object) throws CorruptDataException, MemoryAccessException {
        return (int)this.parse(8);
    }

    public long getLong(JavaObject object) throws CorruptDataException, MemoryAccessException {
        return this.parse(16);
    }

    public short getShort(JavaObject object) throws CorruptDataException, MemoryAccessException {
        return (short)this.parse(4);
    }

    private long parse(int maxLength) throws CorruptDataException {
        if (null == this._value || this._value.length() > maxLength) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("parse error", null));
        }
        if (16 == this._value.length()) {
            String highS = this._value.substring(0, 8);
            String lowS = this._value.substring(8, 16);
            long high = Long.parseLong(highS, 16);
            long low = Long.parseLong(lowS, 16);
            return high << 32 | low;
        }
        return Long.parseLong(this._value, 16);
    }
}

