/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaInstanceField;
import com.ibm.dtfj.java.j9.JavaMonitor;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaThread;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaObject
implements com.ibm.dtfj.java.JavaObject {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private com.ibm.dtfj.java.j9.JavaHeap _containingHeap;
    private long _arrayletSpineSize;
    private long _arrayletLeafSize;
    private boolean _isArraylet = false;
    protected static final String BOOLEAN_SIGNATURE = "Z";
    protected static final String BYTE_SIGNATURE = "B";
    protected static final String CHAR_SIGNATURE = "C";
    protected static final String SHORT_SIGNATURE = "S";
    protected static final String INTEGER_SIGNATURE = "I";
    protected static final String LONG_SIGNATURE = "J";
    protected static final String FLOAT_SIGNATURE = "F";
    protected static final String DOUBLE_SIGNATURE = "D";
    protected static final String ARRAY_PREFIX_SIGNATURE = "[";
    protected static final String OBJECT_PREFIX_SIGNATURE = "L";
    private Vector _references = null;
    private Object _associatedObject = null;

    JavaObject(JavaRuntime vm, ImagePointer address, com.ibm.dtfj.java.j9.JavaHeap containingHeap, long arrayletSpineSize, long arrayletLeafSize, boolean isArraylet) throws CorruptDataException {
        if (null == vm) {
            throw new IllegalArgumentException("A Java Object cannot exist in a null VM");
        }
        this._basePointer = address;
        this._javaVM = vm;
        this._containingHeap = containingHeap;
        this._arrayletSpineSize = arrayletSpineSize;
        this._arrayletLeafSize = arrayletLeafSize;
        this._isArraylet = isArraylet;
    }

    public static JavaObject createJavaObject(JavaRuntime vm, ImagePointer address) throws CorruptDataException {
        try {
            return (JavaObject)vm.getObjectAtAddress(address);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static JavaObject createJavaObject(JavaRuntime vm, ImagePointer address, com.ibm.dtfj.java.j9.JavaHeap containingHeap, JavaHeapRegion containingRegion) throws CorruptDataException {
        try {
            return (JavaObject)containingRegion.getObjectAtAddress(address);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public JavaClass getJavaClass() throws CorruptDataException {
        if (0L != this._basePointer.getAddress()) {
            ImagePointer classPointer;
            if (this._containingHeap == null) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to access class pointer as containing heap is null", this._basePointer));
            }
            try {
                classPointer = this._containingHeap.readClassPointerRelativeTo(this._basePointer);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to access class pointer", this._basePointer));
            }
            long classID = classPointer.getAddress();
            JavaClass ret = this._javaVM.getClassForID(classID);
            if (ret == null) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Unknown class ID " + classID, null));
            }
            return ret;
        }
        throw new NullPointerException();
    }

    public boolean isArray() throws CorruptDataException {
        return this.getJavaClass().isArray();
    }

    public int getArraySize() throws CorruptDataException {
        JavaClass isa = this.getJavaClass();
        if (isa instanceof JavaArrayClass) {
            JavaArrayClass blueprint = (JavaArrayClass)isa;
            int offset = blueprint.getSizeOffset();
            int numberOfSizeBytes = blueprint.getNumberOfSizeBytes();
            try {
                int numberOfElements = 0;
                if (4 == numberOfSizeBytes) {
                    numberOfElements = this._basePointer.getIntAt((long)offset);
                } else if (8 == numberOfSizeBytes) {
                    long longCount = this._basePointer.getLongAt((long)offset);
                    numberOfElements = (int)longCount;
                    if ((long)numberOfElements != longCount) {
                        System.err.println("Error:  Array element count overflow or underflow.");
                    }
                } else {
                    System.err.println("Error:  unable to read array size as we weren't expecting to read " + numberOfSizeBytes + " bytes.");
                }
                return numberOfElements;
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to read the number of elements", this._basePointer.add((long)offset)));
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void arraycopy(int srcStart, Object dst, int dstStart, int length) throws CorruptDataException, MemoryAccessException {
        JavaClass javaClass = this.getJavaClass();
        if (!(javaClass instanceof JavaArrayClass)) throw new IllegalArgumentException("this JavaObject instance is not an array");
        JavaArrayClass isa = (JavaArrayClass)javaClass;
        String type = javaClass.getName();
        int elementCount = this.getArraySize();
        int pointerSize = 0;
        if (null == dst) {
            throw new IllegalArgumentException("dst is null");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("length out of range: " + length);
        }
        if (dstStart < 0) {
            throw new ArrayIndexOutOfBoundsException("dstStart out of range: " + dstStart);
        }
        if (srcStart < 0) {
            throw new ArrayIndexOutOfBoundsException("srcStart out of range: " + srcStart);
        }
        if (srcStart + length > elementCount) {
            throw new ArrayIndexOutOfBoundsException("source array index out of range: " + (srcStart + length));
        }
        pointerSize = this._javaVM.bytesPerPointer();
        if (type.equals("[B")) {
            if (!(dst instanceof byte[])) throw new IllegalArgumentException("destination array type must be byte");
            byte[] target = (byte[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 1, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 1);
                target[x + dstStart] = leafBase.getByteAt(leafIndex);
            }
            return;
        } else if (type.equals("[Z")) {
            if (!(dst instanceof boolean[])) throw new IllegalArgumentException("destination array type must be boolean");
            boolean[] target = (boolean[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                long leafIndex;
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 1, pointerSize);
                target[x + dstStart] = 0 != leafBase.getByteAt(leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 1));
            }
            return;
        } else if (type.equals("[C")) {
            if (!(dst instanceof char[])) throw new IllegalArgumentException("destination array type must be char");
            char[] target = (char[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 2, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 2);
                target[x + dstStart] = (char)leafBase.getShortAt(leafIndex);
            }
            return;
        } else if (type.equals("[S")) {
            if (!(dst instanceof short[])) throw new IllegalArgumentException("destination array type must be short");
            short[] target = (short[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 2, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 2);
                target[x + dstStart] = leafBase.getShortAt(leafIndex);
            }
            return;
        } else if (type.equals("[I")) {
            if (!(dst instanceof int[])) throw new IllegalArgumentException("destination array type must be int");
            int[] target = (int[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 4, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 4);
                target[x + dstStart] = leafBase.getIntAt(leafIndex);
            }
            return;
        } else if (type.equals("[J")) {
            if (!(dst instanceof long[])) throw new IllegalArgumentException("destination array type must be long");
            long[] target = (long[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 8, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 8);
                target[x + dstStart] = leafBase.getLongAt(leafIndex);
            }
            return;
        } else if (type.equals("[F")) {
            if (!(dst instanceof float[])) throw new IllegalArgumentException("destination array type must be float");
            float[] target = (float[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 4, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 4);
                target[x + dstStart] = leafBase.getFloatAt(leafIndex);
            }
            return;
        } else if (type.equals("[D")) {
            if (!(dst instanceof double[])) throw new IllegalArgumentException("destination array type must be double");
            double[] target = (double[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 8, pointerSize);
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * 8);
                target[x + dstStart] = leafBase.getDoubleAt(leafIndex);
            }
            return;
        } else {
            if (!(dst instanceof Object[])) throw new IllegalArgumentException("destination array type must be Object");
            Object[] target = (Object[])dst;
            if (dstStart + length > target.length) {
                throw new ArrayIndexOutOfBoundsException("destination array index out of range: " + (dstStart + length));
            }
            for (int x = 0; x < length; ++x) {
                ImagePointer leafBase = this._leafBaseForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * pointerSize, pointerSize);
                int fobjectSize = this._containingHeap.getFObjectSize();
                long leafIndex = this._leafIndexForIndexAndTypeSize(isa.getFirstElementOffset(), (srcStart + x) * fobjectSize);
                ImagePointer pointer = this._containingHeap.readFObjectAt(leafBase, leafIndex);
                target[x + dstStart] = this._javaVM.getObjectAtAddress(pointer);
            }
        }
    }

    private long _leafIndexForIndexAndTypeSize(int firstElementOffset, long index) {
        long ret = 0L;
        ret = this.isArraylet() ? index % this._arrayletLeafSize : (long)firstElementOffset + index;
        return ret;
    }

    private ImagePointer _leafBaseForIndexAndTypeSize(int firstElementOffset, long index, int bytesPerPointer) throws CorruptDataException, MemoryAccessException {
        ImagePointer ret = null;
        if (this.isArraylet()) {
            long pointerIndex = index / this._arrayletLeafSize;
            long pointerAddress = (long)firstElementOffset + (long)bytesPerPointer * pointerIndex;
            ret = this._basePointer.getPointerAt(pointerAddress);
        } else {
            ret = this._basePointer;
        }
        return ret;
    }

    public long getSize() throws CorruptDataException {
        Iterator sections = this.getSections();
        long size = 0L;
        while (sections.hasNext()) {
            Object qsect = sections.next();
            if (qsect instanceof ImageSection) {
                ImageSection section = (ImageSection)qsect;
                size += section.getSize();
                continue;
            }
            if (qsect instanceof CorruptData) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)((CorruptData)qsect));
            }
            throw new RuntimeException("Found unexpected object " + qsect.getClass().getName());
        }
        return size;
    }

    public long getHashcode() throws DataUnavailable, CorruptDataException {
        return this.getPersistentHashcode();
    }

    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        if (this._javaVM.objectShouldInferHash()) {
            try {
                int flags = ((JavaAbstractClass)this.getJavaClass()).readFlagsFromInstance(this);
                int twoBytes = flags & 0x7FFF0000;
                long hash = twoBytes >> 16 | twoBytes;
                return hash;
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Address in object header but unreadable", this._basePointer));
            }
        }
        throw new DataUnavailable("Unknown hash strategy for this VM version");
    }

    public ImagePointer getID() {
        return this._basePointer;
    }

    public Iterator getSections() {
        List<Object> sections;
        if (this.isArraylet()) {
            sections = new Vector<com.ibm.dtfj.image.CorruptData>();
            try {
                JavaArrayClass arrayForm = (JavaArrayClass)this.getJavaClass();
                int objectHeaderSize = arrayForm.getFirstElementOffset();
                int bytesPerPointer = this._javaVM.bytesPerPointer();
                try {
                    long spineSectionSize;
                    boolean hasTailLeaf;
                    int instanceSize = arrayForm.getInstanceSize(this);
                    long contentDataSize = instanceSize - objectHeaderSize;
                    int nonTailLeafCount = (int)(contentDataSize / this._arrayletLeafSize);
                    long tailLeafSize = contentDataSize % this._arrayletLeafSize;
                    boolean bl = hasTailLeaf = 0L != tailLeafSize;
                    if (hasTailLeaf) {
                        ImagePointer lastLeaf = this._basePointer.getPointerAt((long)(objectHeaderSize + nonTailLeafCount * bytesPerPointer));
                        long spineEnd = lastLeaf.getAddress() + tailLeafSize;
                        spineSectionSize = Math.max(spineEnd - this._basePointer.getAddress(), this._arrayletSpineSize);
                    } else {
                        spineSectionSize = Math.max((long)(objectHeaderSize + nonTailLeafCount * bytesPerPointer), this._arrayletSpineSize);
                    }
                    JavaObjectImageSection spine = new JavaObjectImageSection(this._basePointer, spineSectionSize);
                    sections.add(spine);
                    long baseAddress = this._basePointer.getAddress();
                    int pointerOffset = objectHeaderSize;
                    for (int i = 0; i < nonTailLeafCount; ++i) {
                        ImagePointer leafPointer = this._basePointer.getPointerAt((long)pointerOffset);
                        long leafAddress = leafPointer.getAddress();
                        if (!this.lessOrEqual(baseAddress, leafAddress) || !this.lessOrEqual(leafAddress, baseAddress + spineSectionSize)) {
                            sections.add(new JavaObjectImageSection(leafPointer, this._arrayletLeafSize));
                        }
                        pointerOffset += bytesPerPointer;
                    }
                }
                catch (MemoryAccessException e) {
                    sections.add(new CorruptData("failed to walk arraylet spine", e.getPointer()));
                }
            }
            catch (CorruptDataException e) {
                sections.add(e.getCorruptData());
            }
        } else {
            long size = 0L;
            try {
                size = ((JavaAbstractClass)this.getJavaClass()).getInstanceSize(this);
                JavaObjectImageSection section = new JavaObjectImageSection(this._basePointer, size);
                sections = Collections.singletonList(section);
            }
            catch (CorruptDataException e) {
                sections = Collections.singletonList(e.getCorruptData());
            }
        }
        return sections.iterator();
    }

    private boolean lessOrEqual(long low, long high) {
        boolean ret = false;
        ret = low < 0L ^ high < 0L ? high < 0L : low <= high;
        return ret;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaObject) {
            JavaObject local = (JavaObject)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._basePointer.equals(local._basePointer);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._basePointer.hashCode();
    }

    public boolean isArraylet() {
        return this._isArraylet;
    }

    public ImagePointer getFObjectAtOffset(int offset) throws MemoryAccessException, CorruptDataException {
        return this._containingHeap.readFObjectAt(this._basePointer, offset);
    }

    public int getFObjectSize() {
        return this._containingHeap.getFObjectSize();
    }

    public Iterator getReferences() {
        if (null == this._references) {
            this._references = new Vector();
            try {
                for (JavaClass jClass = this.getJavaClass(); null != jClass; jClass = jClass.getSuperclass()) {
                    Vector refs = this.getClassReferences(jClass);
                    this._references.addAll(refs);
                }
            }
            catch (CorruptDataException e) {
                this._references.add(e.getCorruptData());
            }
            if (this._associatedObject instanceof JavaClassLoader) {
                JavaClassLoader associatedClassLoader = (JavaClassLoader)this._associatedObject;
                Iterator classes = associatedClassLoader.getCachedClasses();
                while (classes.hasNext()) {
                    Object potentialClass = classes.next();
                    if (!(potentialClass instanceof JavaClass)) continue;
                    JavaClass currentClass = (JavaClass)potentialClass;
                    JavaReference ref = new JavaReference(this._javaVM, (Object)this, currentClass, "Loaded class", 11, 0, 1);
                    this._references.add(ref);
                }
            } else if (this._associatedObject instanceof JavaMonitor || this._associatedObject instanceof JavaThread) {
                // empty if block
            }
        }
        return this._references.iterator();
    }

    void setAssociatedObject(Object o) {
        this._associatedObject = o;
    }

    Object getAssociatedObject() {
        return this._associatedObject;
    }

    private Vector getClassReferences(JavaClass jClass) {
        Vector<Object> references;
        block12: {
            references = new Vector<Object>();
            try {
                if (jClass instanceof JavaArrayClass) {
                    JavaArrayClass arrayClass = (JavaArrayClass)jClass;
                    String type = arrayClass.getLeafClass().getName();
                    if (type.equals("byte") || type.equals("boolean") || type.equals("char") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double")) break block12;
                    Object[] dst = null;
                    int arraySize = this.getArraySize();
                    if (arraySize > 0) {
                        dst = new Object[arraySize];
                        try {
                            this.arraycopy(0, dst, 0, arraySize);
                            for (int i = 0; i < dst.length; ++i) {
                                if (null == dst[i]) continue;
                                String description = "Array Reference";
                                description = description + " [index:" + i + "]";
                                JavaReference jRef = new JavaReference(this._javaVM, (Object)this, dst[i], description, 3, 0, 1);
                                references.add(jRef);
                            }
                        }
                        catch (MemoryAccessException e) {
                            ImagePointer ptrInError = e.getPointer();
                            String message = e.getMessage();
                            references.add(new CorruptData(message, ptrInError));
                        }
                    }
                    JavaClass leafClass = ((JavaArrayClass)jClass).getLeafClass();
                    JavaReference ref = new JavaReference(this._javaVM, (Object)this, leafClass, "Class", 1, 0, 1);
                    references.add(ref);
                    break block12;
                }
                Iterator fieldIt = jClass.getDeclaredFields();
                while (fieldIt.hasNext()) {
                    JavaField jField;
                    String sigPrefix;
                    Object fObject = fieldIt.next();
                    if (!(fObject instanceof JavaInstanceField) || !(sigPrefix = (jField = (JavaField)fObject).getSignature()).startsWith(OBJECT_PREFIX_SIGNATURE) && !sigPrefix.startsWith(ARRAY_PREFIX_SIGNATURE)) continue;
                    try {
                        JavaObject jObject = (JavaObject)jField.getReferenceType(this);
                        if (null == jObject) continue;
                        String fieldName = jField.getName();
                        String description = "Object Reference";
                        if (null != fieldName) {
                            description = description + " [field name:" + fieldName + "]";
                        }
                        JavaReference jRef = new JavaReference(this._javaVM, (Object)this, jObject, description, 2, 0, 1);
                        references.add(jRef);
                    }
                    catch (CorruptDataException e) {
                        references.add(e.getCorruptData());
                    }
                    catch (MemoryAccessException e) {
                        ImagePointer ptrInError = e.getPointer();
                        String message = e.getMessage();
                        references.add(new CorruptData(message, ptrInError));
                    }
                }
                JavaReference ref = new JavaReference(this._javaVM, (Object)this, jClass, "Class", 1, 0, 1);
                references.add(ref);
            }
            catch (CorruptDataException e) {
                references.add(e.getCorruptData());
            }
        }
        return references;
    }

    public JavaHeap getHeap() throws DataUnavailable {
        if (null == this._containingHeap) {
            throw new DataUnavailable("Containing heap not available for this object.");
        }
        return this._containingHeap;
    }

    class JavaObjectImageSection
    extends ImageSection {
        public JavaObjectImageSection(ImagePointer base, long size) {
            super(base, size);
        }

        public String getName() {
            return "In-memory Object section at 0x" + Long.toHexString(this.getBaseAddress().getAddress()) + " (0x" + Long.toHexString(this.getSize()) + " bytes)";
        }
    }
}

