/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.j9.JavaClass;
import java.util.Iterator;

public class JavaLocation
implements com.ibm.dtfj.java.JavaLocation {
    private JavaMethod _method;
    private ImagePointer _pc;
    private int _lineNumber;

    public JavaLocation(JavaMethod method, ImagePointer pc, int lineNumber) {
        if (null == method) {
            throw new IllegalArgumentException("A Java Location cannot have a null method");
        }
        if (null == pc) {
            throw new IllegalArgumentException("A Java Location cannot have a null program counter");
        }
        this._method = method;
        this._pc = pc;
        this._lineNumber = lineNumber;
    }

    public ImagePointer getAddress() throws CorruptDataException {
        return this._pc;
    }

    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (this._lineNumber > 0) {
            return this._lineNumber;
        }
        throw new DataUnavailable();
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        JavaClass j9Class = (JavaClass)this.getMethod().getDeclaringClass();
        return j9Class.getFilename();
    }

    public int getCompilationLevel() throws CorruptDataException {
        ImageSection section;
        long pointer = this.getAddress().getAddress();
        Iterator iter = this.getMethod().getBytecodeSections();
        while (iter.hasNext()) {
            section = (ImageSection)iter.next();
            if (pointer < section.getBaseAddress().getAddress() || pointer >= section.getBaseAddress().getAddress() + section.getSize()) continue;
            return 0;
        }
        iter = this.getMethod().getCompiledSections();
        while (iter.hasNext()) {
            section = (ImageSection)iter.next();
            if (pointer < section.getBaseAddress().getAddress() || pointer >= section.getBaseAddress().getAddress() + section.getSize()) continue;
            return 1;
        }
        return 0;
    }

    public JavaMethod getMethod() throws CorruptDataException {
        return this._method;
    }

    public String toString() {
        String output = null;
        try {
            String className = this.getMethod().getDeclaringClass().getName();
            className = className.replace('/', '.');
            String methodName = this.getMethod().getName();
            String suffix = null;
            try {
                String filename = this.getFilename();
                int line = this.getLineNumber();
                suffix = "(" + filename + ":" + line + ")";
            }
            catch (DTFJException e) {
                suffix = "()";
            }
            output = className + "." + methodName + suffix;
        }
        catch (CorruptDataException e) {
            output = "(corrupt)";
        }
        catch (DataUnavailable e) {
            output = "(data unavailable)";
        }
        return output;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaLocation) {
            JavaLocation local = (JavaLocation)obj;
            isEqual = this._method.equals(local._method) && this._pc.equals(local._pc);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._method.hashCode() ^ this._pc.hashCode();
    }
}

