/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaHeapRegion {
    private JavaHeap _parentHeap;
    private JavaRuntime _javaVM;
    private int _objectAlignment;
    private int _minimumObjectSize;
    private Vector _extents = new Vector();
    private long _arrayletLeafSize;
    private HeapSection _section;

    public JavaHeapRegion(JavaRuntime javaVM, String name, ImagePointer id, int objectAlignment, int minimumObjectSize, long arrayletLeafSize, JavaHeap parentHeap, ImagePointer heapSectionBase, long heapSectionSize) {
        this._parentHeap = parentHeap;
        this._javaVM = javaVM;
        this._objectAlignment = objectAlignment;
        this._minimumObjectSize = minimumObjectSize;
        this._arrayletLeafSize = arrayletLeafSize;
        if (null != heapSectionBase) {
            this._section = new HeapSection(heapSectionBase, heapSectionSize);
        }
    }

    public void addExtent(ImagePointer startAddress, int size, int count) {
        this._extents.add(new HeapExtent(startAddress, size, count));
    }

    public Iterator getSections() {
        List<Object> sections = null;
        sections = null != this._section ? Collections.singletonList(this._section) : this._extents;
        return sections.iterator();
    }

    public Iterator getObjects() {
        return new ExtentWalker(this._parentHeap, this, this._javaVM, this._extents.iterator(), this._objectAlignment, this._minimumObjectSize, this._arrayletLeafSize);
    }

    public void addNewHeapRegionExtent(long start, long end, int count) {
        ImagePointer baseAddress = this._javaVM.pointerInAddressSpace(start);
        int size = (int)(end - start);
        this.addExtent(baseAddress, size, count);
    }

    public int getArrayletSpineSize() {
        return this._minimumObjectSize;
    }

    private static boolean _extentContainsPointer(long extentBase, long extentSize, long pointer) {
        long delta = pointer - extentBase;
        return 0L <= delta && delta < extentSize;
    }

    public long getArrayletLeafSize() {
        return this._arrayletLeafSize;
    }

    public com.ibm.dtfj.java.JavaObject getObjectAtAddress(ImagePointer address) throws CorruptDataException, IllegalArgumentException {
        JavaObject object = null;
        if (null != address && 0L != address.getAddress()) {
            long arrayletIdentificationBitmask = 0L;
            long arrayletIdentificationResult = 0L;
            int arrayletIdentificationWidth = 0;
            int arrayletIdentificationOffset = 0;
            int arrayletSpineSize = 0;
            long arrayletLeafSize = 0L;
            arrayletIdentificationBitmask = this._parentHeap.getArrayletIdentificationBitmask();
            arrayletIdentificationResult = this._parentHeap.getArrayletIdentificationResult();
            arrayletIdentificationWidth = this._parentHeap.getArrayletIdentificationWidth();
            arrayletIdentificationOffset = this._parentHeap.getArrayletIdentificationOffset();
            arrayletSpineSize = this.getArrayletSpineSize();
            arrayletLeafSize = this.getArrayletLeafSize();
            boolean isArraylet = false;
            if (0L != arrayletIdentificationResult) {
                long maskedFlags = 0L;
                if (4 == arrayletIdentificationWidth) {
                    try {
                        maskedFlags = 0xFFFFFFFFL & (long)address.getIntAt((long)arrayletIdentificationOffset);
                    }
                    catch (MemoryAccessException e) {
                        throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to access object flags", address));
                    }
                } else if (8 == arrayletIdentificationWidth) {
                    try {
                        maskedFlags = address.getLongAt((long)arrayletIdentificationOffset);
                    }
                    catch (MemoryAccessException e) {
                        throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to access object flags", address));
                    }
                } else {
                    System.err.println("Arraylet identification width is invalid: " + arrayletIdentificationWidth + " (should be 4 or 8)");
                }
                isArraylet = arrayletIdentificationResult == (arrayletIdentificationBitmask & maskedFlags);
            }
            object = new JavaObject(this._javaVM, address, this._parentHeap, arrayletSpineSize, arrayletLeafSize, isArraylet);
        }
        return object;
    }

    static /* synthetic */ boolean access$200(long x0, long x1, long x2) {
        return JavaHeapRegion._extentContainsPointer(x0, x1, x2);
    }

    class ExtentWalker
    implements Iterator {
        private Iterator _extentIterator;
        private HeapExtent _currentExtent;
        private int _objectsRemainingInExtent;
        private long _nextOffsetInExtent;
        private int _alignment;
        private int _minimumObjectSize;
        private long _arrayletLeafSize;

        public ExtentWalker(JavaHeap heap, JavaHeapRegion region, JavaRuntime vm, Iterator extents, int alignment, int minimumObjectSize, long arrayletLeafSize) {
            JavaHeapRegion.this._parentHeap = heap;
            JavaHeapRegion.this._javaVM = vm;
            this._extentIterator = extents;
            this._alignment = alignment;
            this._minimumObjectSize = minimumObjectSize;
            this._arrayletLeafSize = arrayletLeafSize;
            this._advanceExtentMarker();
        }

        private void _advanceExtentMarker() {
            if (this._extentIterator.hasNext()) {
                this._currentExtent = (HeapExtent)this._extentIterator.next();
                this._nextOffsetInExtent = 0L;
                this._objectsRemainingInExtent = this._currentExtent.objectsInExtent();
            } else {
                this._currentExtent = null;
            }
        }

        public boolean hasNext() {
            boolean moreAvailable = false;
            if (null != this._currentExtent) {
                if (this._objectsRemainingInExtent > 0) {
                    moreAvailable = true;
                } else {
                    this._advanceExtentMarker();
                    moreAvailable = null != this._currentExtent;
                }
            }
            return moreAvailable;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            try {
                objectAddress = this._currentExtent.getBaseAddress().add(this._nextOffsetInExtent);
                instance = JavaHeapRegion.this.getObjectAtAddress(objectAddress);
                theClass = (JavaAbstractClass)instance.getJavaClass();
                if (theClass == null) {
                    this._advanceExtentMarker();
                    return new CorruptData("Invalid object", objectAddress);
                }
                instanceSize = theClass.getInstanceSize(instance);
                spaceOccupied = 0;
                if (((JavaObject)instance).isArraylet()) {
                    arrayForm = (JavaArrayClass)theClass;
                    objectHeaderSize = arrayForm.getFirstElementOffset();
                    nestedType = arrayForm.getLeafClass().getName();
                    contentDataSize = instanceSize - objectHeaderSize;
                    leafCount = (int)(contentDataSize / this._arrayletLeafSize) + (contentDataSize % this._arrayletLeafSize == 0L ? 0 : 1);
                    bytesPerPointer = ((ImageAddressSpace)objectAddress.getAddressSpace()).bytesPerPointer();
                    if (nestedType.equals("double") || nestedType.equals("long")) {
                        spaceOccupied += bytesPerPointer;
                    }
                    if (leafCount > 0) {
                        try {
                            leaf = objectAddress.getPointerAt((long)arrayForm.getFirstElementOffset()).getAddress();
                            extentBase = this._currentExtent.getBaseAddress().getAddress();
                            extentSize = this._currentExtent.getSize();
                            isInlined = JavaHeapRegion.access$200(extentBase, extentSize, leaf);
                            spaceOccupied += bytesPerPointer * leafCount;
                            if (isInlined) {
                                spaceOccupied += instanceSize;
                            }
                            tailLeaf = objectAddress.getPointerAt((long)(arrayForm.getFirstElementOffset() + (leafCount - 1) * bytesPerPointer)).getAddress();
                            if (!JavaHeapRegion.access$200(extentBase, extentSize, tailLeaf)) ** GOTO lbl38
                            spaceOccupied = (int)((long)spaceOccupied + contentDataSize % this._arrayletLeafSize);
                        }
                        catch (MemoryAccessException e) {
                            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Failed to read arraylet leaf pointer", objectAddress.add((long)arrayForm.getFirstElementOffset())));
                        }
                    } else {
                        spaceOccupied += instanceSize;
                    }
                } else {
                    spaceOccupied += instanceSize;
                }
lbl38:
                // 5 sources

                spaceConsumed = Math.max(spaceOccupied, this._minimumObjectSize);
                slack = spaceConsumed % this._alignment;
                filler = 0 == slack ? 0 : this._alignment - slack;
                this._nextOffsetInExtent += (long)(spaceConsumed += filler);
                --this._objectsRemainingInExtent;
                return instance;
            }
            catch (CorruptDataException e) {
                this._advanceExtentMarker();
                return e.getCorruptData();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeapExtent
    extends HeapSection {
        private int _residentObjectCount;

        public HeapExtent(ImagePointer base, long size, int count) {
            super(base, size);
            this._residentObjectCount = count;
        }

        public String getName() {
            return "Heap Extent at " + Long.toHexString(this.getBaseAddress().getAddress()) + " (" + this.getSize() + " bytes long)";
        }

        public int objectsInExtent() {
            return this._residentObjectCount;
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof HeapExtent) {
                HeapExtent local = (HeapExtent)obj;
                isEqual = super.equals(local) && this._residentObjectCount == local._residentObjectCount;
            }
            return isEqual;
        }

        public int hashCode() {
            return super.hashCode() ^ this._residentObjectCount;
        }
    }

    class HeapSection
    implements ImageSection {
        private ImagePointer _base;
        private long _size;

        public HeapSection(ImagePointer base, long size) {
            if (null == base) {
                throw new IllegalArgumentException("Heap extents cannot have null base pointers");
            }
            this._base = base;
            this._size = size;
        }

        public ImagePointer getBaseAddress() {
            return this._base;
        }

        public long getSize() {
            return this._size;
        }

        public String getName() {
            return "Heap extent at 0x" + Long.toHexString(this._base.getAddress()) + " (0x" + Long.toHexString(this._size) + " bytes)";
        }

        public boolean isExecutable() throws DataUnavailable {
            return this._base.isExecutable();
        }

        public boolean isReadOnly() throws DataUnavailable {
            return this._base.isReadOnly();
        }

        public boolean isShared() throws DataUnavailable {
            return this._base.isShared();
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof HeapSection) {
                HeapSection local = (HeapSection)obj;
                isEqual = this._base.equals(local._base) && this._size == local._size;
            }
            return isEqual;
        }

        public int hashCode() {
            return (int)((long)this._base.hashCode() ^ this._size);
        }
    }
}

