/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class JavaAbstractClass
implements JavaClass {
    protected ImagePointer _classPointer;
    protected JavaRuntime _javaVM;
    private int _modifiers;
    private Vector _interfaceNames = new Vector();
    private long _classLoaderID;
    private ImagePointer _objectID;
    private int _flagOffset;

    protected JavaAbstractClass(JavaRuntime vm, ImagePointer id, int modifiers, long loaderID, ImagePointer objectID, int flagOffset) {
        if (null == id) {
            throw new IllegalArgumentException("Java class pointer must be non-null");
        }
        if (null == vm) {
            throw new IllegalArgumentException("Java VM for a class must not be null");
        }
        this._javaVM = vm;
        this._classPointer = id;
        this._modifiers = modifiers;
        this._classLoaderID = loaderID;
        this._objectID = objectID;
        this._flagOffset = flagOffset;
    }

    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this._javaVM.getClassLoaderForID(this._classLoaderID);
    }

    public JavaObject getObject() throws CorruptDataException {
        if (this._objectID == null) {
            return this._javaVM.getObjectAtAddress(this._classPointer);
        }
        return this._javaVM.getObjectAtAddress(this._objectID);
    }

    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    public ImagePointer getID() {
        return this._classPointer;
    }

    public Iterator getInterfaces() {
        return this._interfaceNames.iterator();
    }

    public void addInterfaceName(String interfaceName) {
        this._interfaceNames.add(interfaceName);
    }

    public abstract int getInstanceSize(JavaObject var1);

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaAbstractClass) {
            JavaAbstractClass clazz = (JavaAbstractClass)obj;
            isEqual = this.getClass().equals(clazz.getClass()) && this._javaVM.equals(clazz._javaVM) && this._classPointer.equals(clazz._classPointer);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._classPointer.hashCode();
    }

    public int readFlagsFromInstance(JavaObject instance) throws MemoryAccessException, CorruptDataException {
        return instance.getID().getIntAt((long)this._flagOffset);
    }

    protected void addClassLoaderReference(Collection coll) {
        JavaReference jRef = null;
        try {
            JavaObject classLoaderObject;
            JavaClassLoader classLoader = this.getClassLoader();
            if (null != classLoader && null != (classLoaderObject = classLoader.getObject())) {
                jRef = new JavaReference(this._javaVM, (Object)this, classLoaderObject, "Classloader", 4, 0, 1);
                coll.add(jRef);
            }
        }
        catch (CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    protected void addSuperclassReference(Collection coll) {
        JavaReference jRef = null;
        try {
            JavaClass superClass = this.getSuperclass();
            jRef = new JavaReference(this._javaVM, (Object)this, superClass, "Superclass", 10, 0, 1);
            coll.add(jRef);
        }
        catch (CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }
}

