/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.MemoryRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.Dump;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.CaaNotFound;
import com.ibm.dtfj.corereaders.zos.le.Dll;
import com.ibm.dtfj.corereaders.zos.le.DllFunction;
import com.ibm.dtfj.corereaders.zos.le.DllVariable;
import com.ibm.dtfj.corereaders.zos.le.DsaStackFrame;
import com.ibm.dtfj.corereaders.zos.le.Edb;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import com.ibm.dtfj.corereaders.zos.mvs.Tcb;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.MemoryAccessException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class NewZosDump
implements ICoreFileReader {
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static final int SHARED_MEMORY_ASID = -910042680;
    private static final int RECORD_HEADER_LEN = 64;
    private static final int RECORD_BODY_LEN = 4096;
    private static final int RECORD_LEN = 4160;
    private List _additionalFileNames = new ArrayList();
    private IAbstractAddressSpace _space;
    private ImageInputStream _file;
    private boolean _is64Bit;
    private HashMap _javaAddressSpaces;
    private static Logger log = Logger.getLogger(NewZosDump.class.getName());
    private Dump _dump;
    private AddressSpace[] _zebedeeAddressSpaces;

    private NewZosDump(ClosingFileReader file) {
        this._file = file;
        this._is64Bit = false;
        this.initializeZebedeeDump(file);
        List memoryRanges = this.readTDUMP();
        List keepList = null;
        this._javaAddressSpaces = new LinkedHashMap();
        Iterator<Object> iter = memoryRanges.iterator();
        while (iter.hasNext()) {
            int asid = this.findAsidWithJ9RASEyeCatcher(iter);
            if (-1 == asid) continue;
            this._javaAddressSpaces.put(new Integer(asid), new int[]{asid, 0});
        }
        for (int[] asidinfo : this._javaAddressSpaces.values()) {
            List onASID = this.keepMemoryRangesWithAsid(asidinfo, memoryRanges);
            if (keepList != null) {
                keepList.addAll(onASID);
            } else {
                keepList = onASID;
            }
            if (asidinfo[1] == 0) continue;
            this._is64Bit = true;
        }
        if (keepList != null) {
            MemoryRange[] rawRanges = keepList.toArray(new MemoryRange[keepList.size()]);
            this._space = new DumpReaderAddressSpace(rawRanges, new DumpReader(this._file, this._is64Bit), false, this._is64Bit);
        }
    }

    public String format(int i) {
        return "0x" + Integer.toHexString(i);
    }

    public String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    private void initializeZebedeeDump(ClosingFileReader file) {
        try {
            log.fine("Building Zebedee dump from " + file);
            String fileName = file.getAbsolutePath();
            if (file.isMVSFile()) {
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            }
            this._dump = new Dump(fileName, file, false);
            this._zebedeeAddressSpaces = this._dump.getAddressSpaces();
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINE, "Problem for Zebedee finding dump file", e);
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.FINE, "Zebedee not found", e);
        }
    }

    private AddressSpace findZebedeeAddressSpace(int asid) {
        AddressSpace adrJava = null;
        if (this._zebedeeAddressSpaces != null) {
            for (int i = 0; i < this._zebedeeAddressSpaces.length; ++i) {
                if (asid != this._zebedeeAddressSpaces[i].getAsid()) continue;
                adrJava = this._zebedeeAddressSpaces[i];
                break;
            }
        }
        return adrJava;
    }

    private Edb[] getEdbs(AddressSpace as) {
        HashMap<Long, Edb> edbs = new HashMap<Long, Edb>();
        Tcb[] tc = Tcb.getTcbs(as);
        if (tc != null) {
            for (int i = 0; i < tc.length; ++i) {
                try {
                    Caa ca = new Caa(tc[i]);
                    Edb edb = ca.getEdb();
                    if (edb.getFirstDll() == null) continue;
                    edbs.put(new Long(edb.address()), edb);
                    continue;
                }
                catch (CaaNotFound e) {
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        Edb[] edb = new Edb[edbs.size()];
        edbs.values().toArray(edb);
        return edb;
    }

    private List getThreads(Builder builder, final ImageAddressSpace imgAdr, AddressSpace addressSpace, Edb edb) {
        ArrayList<Object> threads = new ArrayList<Object>();
        AddressRange[] rr = addressSpace.getAddressRanges();
        Tcb[] tc = Tcb.getTcbs(addressSpace);
        if (tc != null) {
            for (int j = 0; j < tc.length; ++j) {
                try {
                    ArrayList<Object> stackSections;
                    ArrayList<Object> stackFrames;
                    Properties props;
                    ArrayList<Object> regs;
                    Caa caa;
                    block28: {
                        RegisterSet rs;
                        log.fine("TCB " + this.format(tc[j].address()));
                        caa = new Caa(tc[j]);
                        log.fine("CAA " + this.format(caa.address()) + " " + caa.whereFound());
                        if (caa.getEdb().address() != edb.address()) {
                            log.fine("Skipping CAA as edb " + this.format(caa.getEdb().address()) + " != edb for process " + this.format(edb.address()));
                            continue;
                        }
                        try {
                            rs = tc[j].getRegisters();
                        }
                        catch (IOException e) {
                            try {
                                rs = tc[j].getRegistersFromBPXGMSTA();
                            }
                            catch (IOException e2) {
                                rs = caa.getCurrentFrame().getRegisterSet();
                            }
                        }
                        regs = new ArrayList<Object>();
                        long psw = rs.getPSW();
                        String pswn = null;
                        switch ((int)(psw >> 31) & 3) {
                            case 0: {
                                pswn = "PSW:24";
                                break;
                            }
                            case 1: {
                                pswn = "PSW:31";
                                break;
                            }
                            default: {
                                pswn = "PSW:64";
                            }
                        }
                        regs.add(builder.buildRegister("PSW", new Long(psw)));
                        for (int i = 0; i < 16; ++i) {
                            regs.add(builder.buildRegister("R" + i, new Long(rs.getRegister(i))));
                        }
                        props = new Properties();
                        props.setProperty("TCB", this.format(caa.getTcb().address()));
                        props.setProperty("CAA", this.format(caa.address()));
                        props.setProperty("EDB", this.format(caa.getEdb().address()));
                        props.setProperty(pswn, this.format(psw));
                        try {
                            props.setProperty("Stack direction", caa.ceecaa_stackdirection() == 0 ? "up" : "down");
                            props.setProperty("CAA CEL level", this.format(caa.ceecaalevel()));
                        }
                        catch (IOException e) {
                            log.log(Level.FINE, "Problem finding stack information", e);
                        }
                        ImagePointer tcbip = imgAdr.getPointer(tc[j].address());
                        try {
                            props.setProperty("Task Completion Code", this.format(tcbip.getIntAt(16L)));
                        }
                        catch (MemoryAccessException e) {
                        }
                        catch (CorruptDataException e) {
                            // empty catch block
                        }
                        stackFrames = new ArrayList<Object>();
                        stackSections = new ArrayList<Object>();
                        try {
                            DsaStackFrame dsa;
                            if (dsa == null) {
                                log.fine("Null current frame for CAA " + this.format(caa.address()));
                                stackSections.add(builder.buildCorruptData(imgAdr, "Null stack frame so no stack sections with CAA", caa.address()));
                                break block28;
                            }
                            try {
                                for (dsa = caa.getCurrentFrame(); dsa != null; dsa = dsa.getParentFrame()) {
                                    final Object builderStackFrame = builder.buildStackFrame(imgAdr, dsa.getDsaAddress(), dsa.getEntryPoint() + dsa.getAddressSpace().stripTopBit(dsa.getEntryOffset()));
                                    final DsaStackFrame currentFrame = dsa;
                                    ImageStackFrame stackFrame = new ImageStackFrame(){
                                        ImageStackFrame isf;
                                        DsaStackFrame frame;
                                        {
                                            this.isf = (ImageStackFrame)builderStackFrame;
                                            this.frame = currentFrame;
                                        }

                                        public ImagePointer getProcedureAddress() {
                                            long start = this.frame.getEntryPoint();
                                            long size = this.frame.getEntryOffset();
                                            return imgAdr.getPointer(start + size);
                                        }

                                        public String getProcedureName() throws CorruptDataException {
                                            String module = this.isf.getProcedureName().split("::")[0];
                                            return module + "::" + this.frame.getEntryName() + "+0x" + Long.toHexString(this.frame.getEntryOffset());
                                        }

                                        public ImagePointer getBasePointer() {
                                            return imgAdr.getPointer(this.frame.getDsaAddress());
                                        }
                                    };
                                    stackFrames.add(stackFrame);
                                    long dsaAddr = dsa.getDsaAddress();
                                    int i = this.findRange(dsaAddr, stackSections, rr);
                                    if (i >= 0) {
                                        stackSections.add(builder.buildStackSection(imgAdr, rr[i].getStartAddress(), rr[i].getStartAddress() + rr[i].getLength()));
                                        continue;
                                    }
                                    if (i != -2) continue;
                                    log.fine("Unable to find stack section for DSA " + this.format(dsa.getDsaAddress()));
                                }
                            }
                            catch (Error e) {
                                long dsaAddress = dsa != null ? dsa.getDsaAddress() : 0L;
                                log.log(Level.FINE, "Problem finding parent frame for DSA " + this.format(dsaAddress), e);
                                stackFrames.add(builder.buildCorruptData(imgAdr, "Corrupt stack frame with DSA " + e.getMessage(), dsaAddress));
                                stackSections.add(builder.buildCorruptData(imgAdr, "Corrupt stack frame with DSA " + e.getMessage(), dsaAddress));
                            }
                        }
                        catch (Error e) {
                            log.log(Level.FINE, "Problem finding current frame for CAA " + this.format(caa.address()), e);
                            stackFrames.add(builder.buildCorruptData(imgAdr, "Corrupt stack frames with CAA " + e.getMessage(), caa.address()));
                            stackSections.add(builder.buildCorruptData(imgAdr, "Corrupt stack frames with CAA " + e.getMessage(), caa.address()));
                        }
                    }
                    String threadId = "";
                    try {
                        threadId = this.format(caa.getPThreadID());
                    }
                    catch (IOException e) {
                        threadId = "<unknown>";
                    }
                    log.fine("Building thread " + threadId + " with " + stackSections.size() + " sections");
                    Object it = builder.buildThread(threadId, regs.iterator(), stackSections.iterator(), stackFrames.iterator(), props, 0);
                    threads.add(it);
                    continue;
                }
                catch (CaaNotFound e) {
                    log.log(Level.FINE, "Problem finding CAA for TCB " + this.format(tc[j].address()), e);
                }
            }
        }
        return threads;
    }

    private List getModules(Builder builder, ImageAddressSpace imgAdr, AddressSpace addressSpace, Edb edb) {
        boolean verboseinfo = false;
        ArrayList<Object> modules = new ArrayList<Object>();
        AddressRange[] rr = addressSpace.getAddressRanges();
        try {
            for (Dll dll = edb.getFirstDll(); dll != null; dll = dll.getNext()) {
                int i;
                long routine;
                int j;
                int i2;
                DllFunction[] f = dll.getFunctions();
                DllVariable[] g = dll.getVariables();
                String dllname = dll.getName();
                ArrayList<Object> symbols = new ArrayList<Object>();
                for (i2 = 0; i2 < f.length; ++i2) {
                    symbols.add(builder.buildSymbol(imgAdr, f[i2].name, f[i2].address));
                }
                for (i2 = 0; i2 < g.length; ++i2) {
                    symbols.add(builder.buildSymbol(imgAdr, g[i2].name, g[i2].address));
                }
                Properties props = new Properties();
                ArrayList<Object> sections = new ArrayList<Object>();
                for (j = 0; j < f.length; ++j) {
                    routine = f[j].address;
                    i = this.findRange(routine, sections, rr);
                    if (i < 0) continue;
                    sections.add(builder.buildModuleSection(imgAdr, "?", rr[i].getStartAddress(), rr[i].getStartAddress() + rr[i].getLength()));
                }
                for (j = 0; j < g.length; ++j) {
                    routine = g[j].address;
                    i = this.findRange(routine, sections, rr);
                    if (i < 0) continue;
                    sections.add(builder.buildModuleSection(imgAdr, "?", rr[i].getStartAddress(), rr[i].getStartAddress() + rr[i].getLength()));
                }
                props.setProperty("Writable Static Area address", this.format(dll.getWsa()));
                Object mod = builder.buildModule(dllname, props, sections.iterator(), symbols.iterator(), 0L);
                modules.add(mod);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, "Problem for Zebedee finding module information", e);
        }
        return modules;
    }

    private int findRange(long routine, List al, AddressRange[] rr) {
        for (ImageSection is : al) {
            if (is.getBaseAddress().getAddress() > routine || routine >= is.getBaseAddress().getAddress() + is.getSize()) continue;
            return -1;
        }
        for (int i = 0; i < rr.length; ++i) {
            if (rr[i].getStartAddress() > routine || routine > rr[i].getEndAddress()) continue;
            log.fine("Found address " + this.format(routine) + " at " + this.format(rr[i].getStartAddress()) + ":" + this.format(rr[i].getEndAddress()));
            return i;
        }
        log.fine("Didn't find address " + this.format(routine));
        return -2;
    }

    private Properties getEnvironment(Builder build, AddressSpace addressSpace, Edb edb) {
        try {
            log.fine("Get environment for EDB = " + edb);
            Properties p = edb.getEnvVars();
            return p;
        }
        catch (IOException e) {
            log.log(Level.FINE, "Problem for Zebedee environment", e);
            return new Properties();
        }
    }

    private long getCreationTime() {
        long tm = this._dump.getCreationDate().getTime();
        log.fine("Java time of dump:" + this.format(tm) + " as date:" + new Date(tm));
        return this._dump.getCreationDate().getTime();
    }

    private List keepMemoryRangesWithAsid(int[] asidinfo, List rangeArray) {
        ArrayList<MemoryRange> keep = new ArrayList<MemoryRange>();
        for (MemoryRange range : rangeArray) {
            boolean range64;
            boolean bl = range64 = range.getVirtualAddress() + range.getSize() >= 0x100000000L;
            if (range64) {
                log.finer("Found 64-bit address range " + this.format(range.getVirtualAddress()) + ":" + this.format(range.getSize()) + " in address space " + this.format(range.getAsid()));
            }
            if (range.getAsid() == asidinfo[0]) {
                keep.add(range);
                if (range64 && asidinfo[1] == 0) {
                    log.fine("Found 64-bit address in Java address space");
                    asidinfo[1] = 1;
                }
            }
            if (range.getAsid() != -910042680) continue;
            MemoryRange rangeCopy = new MemoryRange(range, asidinfo[0]);
            keep.add(rangeCopy);
        }
        return keep;
    }

    private int findAsidWithJ9RASEyeCatcher(Iterator iter) {
        int asid = -1;
        log.fine("Searching");
        try {
            byte[] buf = new byte[4096];
            int oldasid = -1;
            while (iter.hasNext()) {
                MemoryRange range = (MemoryRange)iter.next();
                long offset = range.getFileOffset();
                if (oldasid != range.getAsid()) {
                    oldasid = range.getAsid();
                    log.fine("Searching asid " + this.format(range.getAsid()) + " at " + offset);
                }
                for (long l = 0L; l < range.getSize(); l += 4096L) {
                    this._file.seek(offset);
                    offset += 4160L;
                    this._file.readFully(buf);
                    if (!this.bufferHasJ9RASEyeCatcher(buf)) continue;
                    asid = range.getAsid();
                    log.fine("Found Java asid " + this.format(asid) + " at " + this.format(range.getVirtualAddress()));
                    return asid;
                }
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, "Problem finding Asid", e);
        }
        log.fine("No Java asid found");
        return asid;
    }

    private boolean bufferHasJ9RASEyeCatcher(byte[] buf) {
        byte[] j9vmras = new byte[]{74, 57, 86, 77, 82, 65, 83, 0};
        for (int i = 0; i < buf.length; i += 8) {
            boolean found = true;
            for (int j = 0; j < j9vmras.length; ++j) {
                if (buf[i + j] == j9vmras[j]) continue;
                found = false;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    public void extract(Builder builder) {
        builder.setOSType("z/OS");
        builder.setCPUType("s390");
        builder.setCPUSubType("");
        if (this._dump != null) {
            builder.setCreationTime(this.getCreationTime());
        }
        log.fine("Address spaces " + this._javaAddressSpaces.size());
        for (int[] asidinfo : this._javaAddressSpaces.values()) {
            this.buildAddressSpace(builder, asidinfo[0], asidinfo[1] != 0);
        }
    }

    private void buildAddressSpace(Builder builder, int asid, boolean is64Bit) {
        log.fine("Building address space " + this.format(asid));
        Object addressSpace = builder.buildAddressSpace("z/OS Address Space", asid);
        ImageAddressSpace imgAdr = addressSpace instanceof ImageAddressSpace ? (ImageAddressSpace)addressSpace : null;
        AddressSpace adrJava = imgAdr != null ? this.findZebedeeAddressSpace(asid) : null;
        Edb[] edbs = adrJava != null ? this.getEdbs(adrJava) : new Edb[1];
        for (int i = 0; i < edbs.length; ++i) {
            Object executable;
            Edb edb = edbs[i];
            Properties environment = edb == null ? new Properties() : this.getEnvironment(builder, adrJava, edb);
            List threads = edb == null ? Collections.singletonList(builder.buildCorruptData(addressSpace, "unable to extract thread information this time!", 0L)) : this.getThreads(builder, imgAdr, adrJava, edb);
            List modules = edb == null ? Collections.EMPTY_LIST : this.getModules(builder, imgAdr, adrJava, edb);
            Iterator mods = modules.iterator();
            Object v0 = executable = mods.hasNext() ? mods.next() : null;
            if (executable == null) {
                builder.setExecutableUnavailable("unable to extract executable information");
            }
            String commandLine = environment.getProperty("IBM_JAVA_COMMAND_LINE", "");
            String processid = edb != null ? this.format(edb.address()) : this.format(asid);
            Object process = builder.buildProcess(addressSpace, processid, commandLine, environment, adrJava == null ? null : threads.get(0), threads.iterator(), executable, mods, is64Bit ? 64 : 32);
            log.fine("Built process " + process);
        }
    }

    public static boolean isSupportedDump(ClosingFileReader f) throws IOException, CorruptCoreException {
        f.seek(0L);
        int signature = f.readInt();
        if (17490 == (0xFFFF & signature >> 16)) {
            throw new CorruptCoreException("This is a z/OS core file which has been corrupted by EBCDIC to ASCII conversion.  Reverse the conversion and try again.");
        }
        return signature == -992349888 || signature == -992349632;
    }

    public static ICoreFileReader dumpFromFile(ClosingFileReader f) throws IOException {
        block3: {
            try {
                assert (NewZosDump.isSupportedDump(f)) : "Tried to create a core reader from an unsupported file type";
            }
            catch (CorruptCoreException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Tried to create a core reader from a corrupt core");
            }
        }
        return new NewZosDump(f);
    }

    protected List readTDUMP() {
        log.fine("Reading address ranges");
        ArrayList<MemoryRange> ranges = new ArrayList<MemoryRange>();
        try {
            long pos = 0L;
            while (true) {
                MemoryRange range = this.readRecord(pos);
                pos += 4160L;
                if (null == range || 0 == range.getAsid() || 0L == range.getVirtualAddress()) continue;
                ranges.add(range);
            }
        }
        catch (IOException iOException) {
            log.fine("Read " + ranges.size() + " address ranges");
            return ranges;
        }
    }

    protected MemoryRange readRecord(long pos) throws IOException {
        this._file.seek(pos);
        int signature = this._file.readInt();
        if (signature != -992349888 && signature != -992349632) {
            throw new IOException("Unrecognized dump record");
        }
        this._file.seek(pos + 12L);
        int asid = this._file.readInt();
        this._file.seek(pos + 20L);
        long address = signature == -992349632 ? this._file.readLong() : this._file.readUnsignedInt();
        return new MemoryRange(address, pos + 64L, 4096L, asid);
    }

    public IAbstractAddressSpace getAddressSpace() {
        return this._space;
    }
}

