/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpReader;
import java.io.IOException;

public class LittleEndianDumpReader
extends DumpReader {
    public LittleEndianDumpReader(ClosingFileReader f, boolean is64Bit) {
        super(f, is64Bit);
    }

    public short readShort() throws IOException {
        return this.byteSwap(super.readShort());
    }

    public int readInt() throws IOException {
        return this.byteSwap(super.readInt());
    }

    public long readLong() throws IOException {
        return this.byteSwap(super.readLong());
    }

    private short byteSwap(short s) {
        return (short)(s >> 8 & 0xFF | s << 8 & 0xFF00);
    }

    private int byteSwap(int i) {
        return i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24 & 0xFF000000;
    }

    private long byteSwap(long l) {
        return l >> 56 & 0xFFL | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L | l << 56 & 0xFF00000000000000L;
    }
}

