/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class LayeredAddressSpace
extends CommonAddressSpace {
    private Stack _memoryRanges = new Stack();
    private Stack _files = new Stack();
    private IAbstractAddressSpace _base;

    public LayeredAddressSpace(IAbstractAddressSpace base, boolean isLittleEndian, boolean is64Bit) {
        super(LayeredAddressSpace._extractRanges(base.getMemoryRanges()), isLittleEndian, is64Bit);
        this._base = base;
    }

    private static MemoryRange[] _extractRanges(Iterator memoryRanges) {
        Vector ranges = new Vector();
        while (memoryRanges.hasNext()) {
            ranges.add(memoryRanges.next());
        }
        return ranges.toArray(new MemoryRange[ranges.size()]);
    }

    public Iterator getMemoryRanges() {
        return super.getMemoryRanges();
    }

    public boolean isExecutable(int asid, long address) throws MemoryAccessException {
        return false;
    }

    public boolean isReadOnly(int asid, long address) throws MemoryAccessException {
        return false;
    }

    public boolean isShared(int asid, long address) throws MemoryAccessException {
        return false;
    }

    public int getBytesAt(int asid, long address, byte[] buffer) throws MemoryAccessException {
        Iterator ranges = this._memoryRanges.iterator();
        Iterator files = this._files.iterator();
        while (ranges.hasNext()) {
            MemoryRange range = (MemoryRange)ranges.next();
            Object file = files.next();
            if (!range.contains(address)) continue;
            ClosingFileReader readable = (ClosingFileReader)file;
            try {
                long fileOffset = range.getFileOffset() + (address - range.getVirtualAddress());
                readable.seek(fileOffset);
                readable.readFully(buffer);
                return buffer.length;
            }
            catch (IOException ex) {
                System.out.println(">> Memory access exception in getBytesAt");
                throw new MemoryAccessException(asid, address);
            }
        }
        return this._base.getBytesAt(asid, address, buffer);
    }

    public void mapRegion(long virtualAddress, ClosingFileReader residentFile, long fileOffset, long size) {
        MemoryRange range = new MemoryRange(virtualAddress, fileOffset, size);
        this._memoryRanges.push(range);
        this._files.push(residentFile);
    }
}

