/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionProperty;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMEncryptionProperty
extends DOMStructure
implements EncryptionProperty {
    private final String id;
    private final String target;
    private final Map attributes;
    private final List content;
    private static Debug debug = Debug.getInstance("xmlenc");

    public DOMEncryptionProperty(List content, String target, String id, Map attributes) {
        if (content == null) {
            throw new NullPointerException("content is null");
        }
        if (content.isEmpty()) {
            throw new IllegalArgumentException("content is empty");
        }
        ArrayList contentCopy = new ArrayList(content);
        Iterator<Object> it = contentCopy.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof XMLStructure) continue;
            throw new ClassCastException("content contains an entry that is not of type XMLStructure");
        }
        this.content = Collections.unmodifiableList(contentCopy);
        this.id = id;
        this.target = target;
        if (attributes != null) {
            HashMap attsCopy = new HashMap(attributes);
            if (!attsCopy.isEmpty()) {
                Set keySet = attsCopy.keySet();
                it = keySet.iterator();
                while (it.hasNext()) {
                    String attName = (String)it.next();
                    if (attName.startsWith("xml:")) continue;
                    throw new IllegalArgumentException("attributes has entry not from XML namespace");
                }
            }
            this.attributes = Collections.unmodifiableMap(attsCopy);
        } else {
            this.attributes = null;
        }
    }

    public DOMEncryptionProperty(Element encPropElem) throws MarshalException {
        this.attributes = this.getAttributes(encPropElem);
        this.id = DOMUtils.getAttributeValue(encPropElem, "Id");
        this.target = DOMUtils.getAttributeValue(encPropElem, "Target");
        NodeList nodes = encPropElem.getChildNodes();
        ArrayList<javax.xml.crypto.dom.DOMStructure> content = new ArrayList<javax.xml.crypto.dom.DOMStructure>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            content.add(new javax.xml.crypto.dom.DOMStructure(nodes.item(i)));
        }
        if (content.isEmpty()) {
            throw new MarshalException("The content of EncryptionPropery should not be empty");
        }
        this.content = Collections.unmodifiableList(content);
    }

    private Map getAttributes(Node node) throws MarshalException {
        HashMap<String, String> hm = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int len = namedNodeMap.getLength();
        for (int i = 0; i < len; ++i) {
            Attr att = (Attr)namedNodeMap.item(i);
            if (debug != null) {
                debug.trace("DOMEncryptionProperty", "getAttributes(Node)", "attr namespace=" + att.getNamespaceURI() + ", name=" + att.getName() + ", value=" + att.getValue());
            }
            String name = att.getName();
            String value = att.getValue();
            if (!name.equals("Id") && !name.equals("Target")) {
                String ns = att.getNamespaceURI();
                if (ns != null) {
                    if (!ns.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
                        throw new MarshalException("attribute " + name + " is not from XML namespace");
                    }
                } else {
                    throw new MarshalException("attribute " + name + " namespace URI is null");
                }
            }
            hm.put(name, value);
        }
        return hm;
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public String getId() {
        return this.id;
    }

    public String getTarget() {
        return this.target;
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element encPropElem = DOMUtils.createElement(ownerDoc, "EncryptionProperty", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        if (this.attributes != null) {
            Iterator iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                String att = (String)iter.next();
                String value = (String)this.attributes.get(att);
                DOMUtils.setAttribute(encPropElem, att, value);
            }
        }
        DOMUtils.setAttributeID(encPropElem, "Id", this.id);
        DOMUtils.setAttributeID(encPropElem, "Target", this.target);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            XMLStructure object = (XMLStructure)i.next();
            if (object instanceof DOMStructure) {
                ((DOMStructure)object).marshal(encPropElem, encPrefix, context);
                continue;
            }
            if (object instanceof javax.xml.crypto.dom.DOMStructure) {
                javax.xml.crypto.dom.DOMStructure domObject = (javax.xml.crypto.dom.DOMStructure)object;
                Node node = domObject.getNode();
                if (!(node instanceof Element)) {
                    throw new MarshalException("content has an entry that is not type of Element");
                }
                DOMUtils.appendChild(encPropElem, node);
                continue;
            }
            throw new MarshalException("not a DOMStructure");
        }
        parent.appendChild(encPropElem);
    }

    public boolean equals(Object o) {
        boolean attributesEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionProperty)) {
            return false;
        }
        EncryptionProperty oxo = (EncryptionProperty)o;
        boolean bl = this.id == null ? oxo.getId() == null : (idsEqual = this.id.equals(oxo.getId()));
        boolean bl2 = this.attributes == null ? oxo.getAttributes() == null : (attributesEqual = ((Object)this.attributes).equals(oxo.getAttributes()));
        boolean targetsEqual = this.target == null ? oxo.getTarget() == null : this.target.equals(oxo.getTarget());
        return idsEqual && attributesEqual && targetsEqual && this.equalsContent(oxo.getContent());
    }

    private boolean equalsContent(List otherContent) {
        if (this.content.size() != otherContent.size()) {
            return false;
        }
        for (int i = 0; i < otherContent.size(); ++i) {
            XMLStructure oxs = (XMLStructure)otherContent.get(i);
            XMLStructure xs = (XMLStructure)this.content.get(i);
            if (oxs instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xs instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node onode = ((javax.xml.crypto.dom.DOMStructure)oxs).getNode();
                Node node = ((javax.xml.crypto.dom.DOMStructure)xs).getNode();
                if (DOMUtils.nodesEqual(node, onode)) continue;
                return false;
            }
            if (xs.equals(oxs)) continue;
            return false;
        }
        return true;
    }
}

