/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMEncryptionProperty;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMEncryptionProperties
extends DOMStructure
implements EncryptionProperties {
    private final List properties;
    private final String id;

    public DOMEncryptionProperties(List properties, String id) {
        if (properties == null) {
            throw new NullPointerException("properties cannot be null");
        }
        ArrayList refCopy = new ArrayList(properties);
        if (refCopy.isEmpty()) {
            throw new IllegalArgumentException("list of properties must contain at least one entry");
        }
        for (int i = 0; i < refCopy.size(); ++i) {
            if (refCopy.get(i) instanceof DOMEncryptionProperty) continue;
            throw new ClassCastException("properties[" + i + "] is not a valid type");
        }
        this.properties = Collections.unmodifiableList(refCopy);
        this.id = id;
    }

    public DOMEncryptionProperties(Element manElem) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(manElem, "Id");
        Element refElem = DOMUtils.getFirstChildElement(manElem);
        ArrayList<DOMEncryptionProperty> refs = new ArrayList<DOMEncryptionProperty>();
        while (refElem != null) {
            refs.add(new DOMEncryptionProperty(refElem));
            refElem = DOMUtils.getNextSiblingElement(refElem);
        }
        this.properties = Collections.unmodifiableList(refs);
    }

    public String getId() {
        return this.id;
    }

    public List getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element manElem = DOMUtils.createElement(ownerDoc, "EncryptionProperties", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        DOMUtils.setAttributeID(manElem, "Id", this.id);
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            DOMEncryptionProperty ref = (DOMEncryptionProperty)i.next();
            ref.marshal(manElem, encPrefix, context);
        }
        parent.appendChild(manElem);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionProperties)) {
            return false;
        }
        EncryptionProperties oman = (EncryptionProperties)o;
        boolean idsEqual = this.id == null ? oman.getId() == null : this.id.equals(oman.getId());
        return idsEqual && ((Object)this.properties).equals(oman.getProperties());
    }
}

