/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class DebugStream {
    public static final String className;
    public String debugPrefix;
    public File debugFile;
    public OutputStream debugStream;
    public PrintStream debugPrinter;
    public static final boolean DO_APPEND = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.impl.DebugStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.getName();
    }

    public DebugStream(String debugPrefix) {
        String methodName = "DebugStream";
        this.debugPrefix = debugPrefix;
        this.debugFile = null;
        this.debugStream = null;
        this.debugPrinter = System.out;
        this.debug(className, methodName, "Created on System.out");
        System.out.println("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] Created [ " + className + " ] with output to System.out");
    }

    public static String getTmpPath() {
        GetPropertyAction tmpDirAction = new GetPropertyAction("java.io.tmpdir");
        return AccessController.doPrivileged(tmpDirAction);
    }

    public DebugStream(String debugPrefix, String filePrefix, String fileSuffix) {
        this(debugPrefix, DebugStream.getTmpPath(), filePrefix, fileSuffix);
    }

    public DebugStream(String debugPrefix, String tmpPath, String filePrefix, String fileSuffix) {
        PrintStream useDebugPrinter;
        String methodName = "DebugStream";
        this.debugPrefix = debugPrefix;
        File tmpDir = new File(tmpPath);
        try {
            this.debugFile = File.createTempFile(filePrefix, fileSuffix, tmpDir);
        }
        catch (IOException e) {
            this.debugFile = null;
        }
        if (this.debugFile == null) {
            Object useDebugStream = null;
            useDebugPrinter = System.out;
        } else {
            try {
                FileOutputStream useDebugStream = new FileOutputStream(this.debugFile, true);
                useDebugPrinter = new PrintStream(useDebugStream);
            }
            catch (IOException e) {
                Object useDebugStream = null;
                useDebugPrinter = System.out;
            }
        }
        this.debugPrinter = useDebugPrinter;
        if (tmpDir != null) {
            this.debug(className, methodName, "Temporary Directory", tmpDir);
            System.out.println("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] Created [ " + className + " ] with output to temporary directory [ " + tmpDir + " ]");
        }
        this.debug(className, methodName, "Created on file", this.debugFile);
        System.out.println("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] Created [ " + className + " ] with output to temporary file [ " + this.debugFile + " ]");
    }

    public void debug(String className, String methodName, String text) {
        this.debugPrinter.println("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] " + className + ": " + methodName + ": " + this.debugPrefix + text);
    }

    public void debug(String className, String methodName, String text, Object value2) {
        this.debugPrinter.println("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] " + className + ": " + methodName + ": " + this.debugPrefix + text + " [ " + value2 + " ]");
    }

    public void debugException(String className, String methodName, String text, Exception e) {
        this.debug(className, methodName, text);
        e.printStackTrace(this.debugPrinter);
    }

    public void debugStack(String className, String methodName, String text) {
        new Throwable("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] " + className + ": " + methodName + ": " + this.debugPrefix + text).printStackTrace(this.debugPrinter);
    }

    public void debugStack(String className, String methodName, String text, Object value2) {
        new Throwable("[ " + this.getTime() + " ] [ " + this.getThreadId() + " ] " + className + ": " + methodName + ": " + this.debugPrefix + text + " [ " + value2 + " ]");
    }

    public String getThreadId() {
        return Thread.currentThread().toString();
    }

    public long getTime() {
        return System.currentTimeMillis();
    }
}

