/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class LongConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Long";
    public static final String LONG_ID = "javax.faces.converter.LongConverter.LONG";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() < 1) {
            return null;
        }
        try {
            return Long.valueOf(value2);
        }
        catch (NumberFormatException nfe) {
            throw new ConverterException(MessageFactory.getMessage(context, LONG_ID, value2, "98765432", MessageFactory.getLabel(context, component)));
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return "";
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        try {
            return Long.toString(((Number)value2).longValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

