/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util;

import com.ibm.xml.xlxp2.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp2.api.util.URI;
import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingDeclReader;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.api.util.encoding.IANACharset;
import com.ibm.xml.xlxp2.api.util.encoding.PlatformEncodingSupport;
import com.ibm.xml.xlxp2.api.util.encoding.UCSEncodingSupport;
import com.ibm.xml.xlxp2.api.util.encoding.UTF8EncodingSupport;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SimpleParsedEntityFactory
implements ParsedEntityFactory {
    public static final boolean REQUIRE_IANA_ENCODING_NAMES = false;
    protected String[] fInOutEncodingName;
    protected boolean fCoordinatesAware;
    protected URI fURI;
    protected boolean fIsXML10;
    private DataBufferFactory fBufferFactory;
    private DataSourceFactory fSourceFactory;
    private ParsedEntityFreeList fFreeEntities;
    private int fIDCounter;
    private final EncodingSupport fUTF8EncodingSupport;
    private EncodingDeclReader fEncodingDeclReader;

    public SimpleParsedEntityFactory(DataBufferFactory dataBufferFactory) {
        this.fBufferFactory = dataBufferFactory;
        this.fSourceFactory = new DataSourceFactory(dataBufferFactory);
        this.fUTF8EncodingSupport = UTF8EncodingSupport.getInstance();
        this.fFreeEntities = new ParsedEntityFreeList();
        this.fInOutEncodingName = ArrayAllocator.newStringArray(1);
        this.fEncodingDeclReader = new EncodingDeclReader();
        this.fCoordinatesAware = false;
    }

    public void setBufferLength(int n) {
        this.fSourceFactory.setBufferLength(n);
    }

    public void reset(boolean bl) {
        if (!bl) {
            this.fFreeEntities.clear();
        }
    }

    protected final ParsedEntity getFreeEntity() {
        ParsedEntity parsedEntity = this.fFreeEntities.remove();
        if (parsedEntity == null) {
            parsedEntity = new ParsedEntity(this);
        }
        parsedEntity.id = this.fIDCounter++;
        parsedEntity.setBufferFactory(this.fBufferFactory);
        return parsedEntity;
    }

    public ParsedEntity createParsedEntity(InputStream inputStream, String string) {
        try {
            ParsedEntity parsedEntity = this.getFreeEntity();
            parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
            this.setByteStreamSource(parsedEntity, inputStream, string, this.fInOutEncodingName);
            return parsedEntity;
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    public ParsedEntity createParsedEntityFromXMLString(XMLString xMLString, String string, boolean bl) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        parsedEntity.lineBreaksNormalized = true;
        parsedEntity.isXML10 = bl;
        parsedEntity.isInternal = true;
        parsedEntity.baseURI = string;
        parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
        parsedEntity.setContent(xMLString);
        return parsedEntity;
    }

    public String expandSystemID(String string, String string2) {
        if (string != null && string2 != null) {
            URI uRI = this.fURI;
            if (uRI == null) {
                uRI = this.fURI = new URI();
            }
            return uRI.expand(string, string2);
        }
        return string;
    }

    protected boolean resolvedExternalID(ParsedEntity parsedEntity, XMLString xMLString, String string) {
        return false;
    }

    public final ParsedEntity createParsedEntityFromExternalID(XMLString xMLString, XMLString xMLString2, String string, boolean bl) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        parsedEntity.isXML10 = bl;
        parsedEntity.baseURI = xMLString2.toString();
        parsedEntity.baseURI = this.expandSystemID(parsedEntity.baseURI, string);
        parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
        if (this.resolvedExternalID(parsedEntity, xMLString, string)) {
            return parsedEntity;
        }
        try {
            InputStream inputStream = URI.openStream(parsedEntity.baseURI);
            this.setByteStreamSource(parsedEntity, inputStream, null, null);
            return parsedEntity;
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        if (!this.fFreeEntities.add(parsedEntity, true)) {
            throw new RuntimeException("releaseParsedEntity(entity.id " + parsedEntity.id + ")");
        }
    }

    public final void setCoordinatesAware(boolean bl) {
        this.fCoordinatesAware = bl;
    }

    public final boolean getCoordinatesAware() {
        return this.fCoordinatesAware;
    }

    protected final CharConversionError setByteStreamSource(ParsedEntity parsedEntity, InputStream inputStream, String string, String[] stringArray) throws IOException {
        ByteStreamDataSource byteStreamDataSource = this.fSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.setByteStream(inputStream, string);
        return this.detectEncodingSetSource(parsedEntity, byteStreamDataSource, stringArray);
    }

    protected final CharConversionError setCharacterStreamSource(ParsedEntity parsedEntity, Reader reader, boolean bl) throws IOException {
        CharacterStreamDataSource characterStreamDataSource = this.fSourceFactory.allocateCharacterStreamDataSource();
        characterStreamDataSource.setCharacterStream(reader);
        characterStreamDataSource.isXML10 = true;
        this.fEncodingDeclReader.getVersionNumber(characterStreamDataSource, bl);
        if (bl) {
            parsedEntity.isXML10 = characterStreamDataSource.isXML10;
        } else {
            characterStreamDataSource.isXML10 = parsedEntity.isXML10;
        }
        return characterStreamDataSource.loadFromCharacterStream(parsedEntity);
    }

    private CharConversionError detectEncodingSetSource(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource, String[] stringArray) throws IOException {
        boolean bl = stringArray != null;
        String string = byteStreamDataSource.getEncodingName();
        EncodingSupport encodingSupport = null;
        byteStreamDataSource.isXML10 = true;
        this.fEncodingDeclReader.setSource(byteStreamDataSource, bl);
        int n = this.fEncodingDeclReader.detectEncoding();
        switch (n) {
            default: {
                if (string == null) {
                    encodingSupport = this.fUTF8EncodingSupport;
                    string = "UTF-8";
                    byteStreamDataSource.setEncodingName("UTF-8");
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 1: {
                encodingSupport = this.fUTF8EncodingSupport;
                if (this.fEncodingDeclReader.getLatinEncoding() && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    string = "UTF-8";
                    byteStreamDataSource.setEncodingName("UTF-8");
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 2: {
                encodingSupport = UCSEncodingSupport.getInstance(1);
                if (this.fEncodingDeclReader.getUCSEncoding(2, true) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    string = "UTF-16BE";
                    byteStreamDataSource.setEncodingName("UTF-16BE");
                }
                if (!bl) break;
                stringArray[0] = "UTF-16";
                break;
            }
            case 3: {
                encodingSupport = UCSEncodingSupport.getInstance(2);
                if (this.fEncodingDeclReader.getUCSEncoding(2, false) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string != null) {
                    // empty if block
                }
                string = "UTF-16LE";
                byteStreamDataSource.setEncodingName("UTF-16LE");
                if (!bl) break;
                stringArray[0] = "UTF-16";
                break;
            }
            case 4: {
                encodingSupport = UCSEncodingSupport.getInstance(3);
                if (this.fEncodingDeclReader.getUCSEncoding(4, true) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string != null) {
                    // empty if block
                }
                string = "UTF-32BE";
                byteStreamDataSource.setEncodingName("UTF-32BE");
                if (!bl) break;
                stringArray[0] = "UTF-32";
                break;
            }
            case 5: {
                encodingSupport = UCSEncodingSupport.getInstance(4);
                if (this.fEncodingDeclReader.getUCSEncoding(4, false) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string != null) {
                    // empty if block
                }
                string = "UTF-32LE";
                byteStreamDataSource.setEncodingName("UTF-32LE");
                if (!bl) break;
                stringArray[0] = "UTF-32";
                break;
            }
            case 6: {
                if (this.fEncodingDeclReader.getLatinEncoding() && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    encodingSupport = this.fUTF8EncodingSupport;
                    string = "UTF-8";
                    byteStreamDataSource.setEncodingName("UTF-8");
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 7: {
                if (this.fEncodingDeclReader.getEBCDICEncoding() && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 8: {
                if (this.fEncodingDeclReader.getUCSEncoding(2, true) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 9: {
                if (this.fEncodingDeclReader.getUCSEncoding(2, false) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 10: {
                if (this.fEncodingDeclReader.getUCSEncoding(4, true) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string;
                break;
            }
            case 11: {
                if (this.fEncodingDeclReader.getUCSEncoding(4, false) && string == null) {
                    string = byteStreamDataSource.getEncodingName();
                } else if (string == null) {
                    parsedEntity.error = CharConversionError.inconsistentEncoding();
                    return parsedEntity.error;
                }
                if (!bl) break;
                stringArray[0] = string;
            }
        }
        byteStreamDataSource.rewind();
        if (bl) {
            parsedEntity.isXML10 = byteStreamDataSource.isXML10;
        } else {
            byteStreamDataSource.isXML10 = parsedEntity.isXML10;
        }
        if (encodingSupport == null) {
            this.fInOutEncodingName[0] = string;
            encodingSupport = IANACharset.getEncodingSupport(this.fInOutEncodingName);
            byteStreamDataSource.setEncodingName(this.fInOutEncodingName[0]);
            if (encodingSupport == null) {
                return this.convertByteStreamWithUnknownEncoding(parsedEntity, byteStreamDataSource, string);
            }
        }
        return encodingSupport.loadFromByteStream(parsedEntity, byteStreamDataSource);
    }

    private final CharConversionError convertByteStreamWithUnknownEncoding(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource, String string) throws IOException {
        EncodingSupport encodingSupport = PlatformEncodingSupport.getInstance();
        return encodingSupport.loadFromByteStream(parsedEntity, byteStreamDataSource);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    class ParsedEntityFreeList {
        private SoftReference<?>[] fList = new SoftReference[8];
        private int fListCount;

        public boolean add(ParsedEntity parsedEntity, boolean bl) {
            if (this.fListCount == 0) {
                this.fList[this.fListCount++] = new SoftReference<ParsedEntity>(parsedEntity);
                parsedEntity.id = -1;
                return true;
            }
            if (this.fListCount == 1) {
                if (this.fList[0] != null) {
                    if (!bl || this.fList[0].get() != parsedEntity) {
                        this.fList[this.fListCount++] = new SoftReference<ParsedEntity>(parsedEntity);
                        parsedEntity.id = -1;
                        return true;
                    }
                    return false;
                }
                this.fList[0] = new SoftReference<ParsedEntity>(parsedEntity);
                parsedEntity.id = -1;
                return true;
            }
            int n = this.fListCount;
            int n2 = this.fListCount;
            while (--n >= 0) {
                if (this.fList[n] == null) {
                    n2 = n;
                    if (bl) continue;
                    break;
                }
                if (!bl || this.fList[n].get() != parsedEntity) continue;
                return false;
            }
            if (n2 == this.fListCount) {
                if (this.fListCount == this.fList.length) {
                    this.fList = ArrayAllocator.resizeObjectArray(SoftReference.class, this.fList, this.fListCount << 1);
                }
                ++this.fListCount;
            }
            this.fList[n2] = new SoftReference<ParsedEntity>(parsedEntity);
            parsedEntity.id = -1;
            return true;
        }

        public ParsedEntity remove() {
            Object object;
            SoftReference<?> softReference;
            if (this.fListCount == 1) {
                softReference = this.fList[0];
                object = (ParsedEntity)softReference.get();
                if (object != null) {
                    softReference.clear();
                    this.fList[0] = null;
                    this.fListCount = 0;
                    return object;
                }
            } else if (this.fListCount > 1) {
                softReference = this.fList[this.fListCount - 1];
                object = (ParsedEntity)softReference.get();
                if (object != null) {
                    softReference.clear();
                    this.fList[--this.fListCount] = null;
                    return object;
                }
            } else if (this.fListCount == 0) {
                return null;
            }
            int n = this.fListCount;
            while (--n >= 0) {
                ParsedEntity parsedEntity;
                if (this.fList[n] == null || (parsedEntity = (ParsedEntity)((SoftReference)(object = this.fList[n])).get()) == null) continue;
                ((Reference)object).clear();
                this.fList[n] = null;
                if (n + 1 == this.fListCount) {
                    this.fListCount = n;
                }
                return parsedEntity;
            }
            return null;
        }

        public void clear() {
            for (int i = 0; i < this.fListCount; ++i) {
                if (this.fList[i] == null) continue;
                this.fList[i].clear();
                this.fList[i] = null;
            }
            this.fListCount = 0;
        }
    }
}

