/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax.serializer;

import com.ibm.xml.xlxp2.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp2.api.util.Pool;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SingleByteWriter
extends StAXWriter {
    private static final Pool fPool = new Pool();

    public static final SingleByteWriter getInstance() {
        SingleByteWriter singleByteWriter = (SingleByteWriter)fPool.get();
        if (singleByteWriter == null) {
            singleByteWriter = new SingleByteWriter();
            fPool.assignToPool(singleByteWriter);
        }
        return singleByteWriter;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.write0(cArray, n, n2);
        }
    }

    private void write0(char[] cArray, int n, int n2) throws IOException {
        this.flushInternal();
        int n3 = n + n2;
        while (n + this.fBuffer.length < n3) {
            this.encodeAndWrite(cArray, n, this.fBuffer.length);
            n += this.fBuffer.length;
            this.flushInternal();
        }
        this.encodeAndWrite(cArray, n, n3 - n);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 < this.fBuffer.length) {
            this.encodeAndWrite(string, n, n2);
        } else {
            this.write0(string, n, n2);
        }
    }

    private void write0(String string, int n, int n2) throws IOException {
        this.flushInternal();
        int n3 = n + n2;
        while (n + this.fBuffer.length < n3) {
            this.encodeAndWrite(string, n, this.fBuffer.length);
            n += this.fBuffer.length;
            this.flushInternal();
        }
        this.encodeAndWrite(string, n, n3 - n);
    }

    public void write(int n) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        this.fBuffer[this.fNumBytes++] = (byte)n;
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = this.fNumBytes;
        for (int i = n; i < n3; ++i) {
            this.fBuffer[n4++] = (byte)cArray[i];
        }
        this.fNumBytes = n4;
    }

    private void encodeAndWrite(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = this.fNumBytes;
        for (int i = n; i < n3; ++i) {
            this.fBuffer[n4++] = (byte)string.charAt(i);
        }
        this.fNumBytes = n4;
    }
}

