/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax.serializer;

import com.ibm.xml.xlxp2.api.stax.serializer.ASCIIEncoding;
import com.ibm.xml.xlxp2.api.stax.serializer.GenericEncoding;
import com.ibm.xml.xlxp2.api.stax.serializer.Latin1Encoding;
import com.ibm.xml.xlxp2.api.stax.serializer.UTF8Encoding;
import com.ibm.xml.xlxp2.api.stax.serializer.UTFEncoding;
import com.ibm.xml.xlxp2.api.stax.serializer.Windows125XEncoding;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class Encoding {
    private static final ThreadLocal<Hashtable<String, Encoding>> fEncodings = new ThreadLocal<Hashtable<String, Encoding>>(){

        @Override
        public Hashtable<String, Encoding> initialValue() {
            return new Hashtable<String, Encoding>();
        }
    };
    private static final Encoding fgUTF8Encoding = new UTF8Encoding();
    protected final String encoding;

    public static final boolean contains(int n, int[] nArray) {
        int n2;
        int n3 = 0;
        while ((n2 = nArray[n3]) != n) {
            n3 = n < n2 ? 2 * n3 + 1 : 2 * n3 + 2;
            if (n3 < nArray.length) continue;
            return false;
        }
        return true;
    }

    public static final int find(int n, int[] nArray) {
        int n2;
        int n3 = 0;
        while ((n2 = nArray[n3]) != n) {
            n3 = n < n2 ? 2 * n3 + 1 : 2 * n3 + 2;
            if (n3 < nArray.length) continue;
            return -1;
        }
        return n3;
    }

    private static final Hashtable<String, Encoding> getEncodings() {
        return fEncodings.get();
    }

    public static Encoding getUTF8Encoding() {
        return fgUTF8Encoding;
    }

    public static Encoding getEncoding(int n, String string) throws UnsupportedEncodingException {
        if (n == 0) {
            return fgUTF8Encoding;
        }
        Hashtable<String, Encoding> hashtable = Encoding.getEncodings();
        Encoding encoding = hashtable.get(string);
        if (encoding == null) {
            switch (n) {
                case 1: {
                    encoding = new ASCIIEncoding();
                    break;
                }
                case 2: {
                    encoding = new Latin1Encoding();
                    break;
                }
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    encoding = new Windows125XEncoding(n, string);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    encoding = new UTFEncoding(string);
                    break;
                }
                default: {
                    encoding = new GenericEncoding(string);
                }
            }
            hashtable.put(string, encoding);
        }
        return encoding;
    }

    public static int toCodePoint(char c, char c2) {
        return (c << 10) + c2 + 65536 - 0x3600000 - 56320;
    }

    public Encoding(String string) {
        this.encoding = string;
    }

    public abstract boolean isEncodable(char var1);

    public abstract boolean isEncodable(char var1, char var2);
}

