/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLTokenReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(XMLTokenReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    TokenReceiverConfig conf = null;

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        if (this.conf == null) {
            String wsseSent = Constants.getWSSENS(context);
            throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "InvalidSecurity"), (String)"token51");
        }
        String idattr = IdUtil.getInstance().getIdAttributeName(target);
        String id = idattr == null ? null : target.getAttribute(idattr);
        QName valueType = new QName(target.getNamespaceURI(), target.getLocalName());
        LoginMapping mapping = this.conf.getLoginMapping(valueType);
        if (mapping != null) {
            Subject subject = ReceiverLogin.login(mapping, target, doc, null, context);
            ResultPool.add(context, new TokenResult.Generic(valueType, subject, id));
        } else {
            Tr.warning(tc, "security.wssecurity.XMLTokenReceiver.token52", valueType.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }
}

