/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UsernameTokenReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(UsernameTokenReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    TokenReceiverConfig conf = null;
    private static final String clsName = UsernameTokenReceiver.class.getName();

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        LoginMapping mapping;
        String idattr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        String id = (idattr = IdUtil.getInstance().getIdAttributeName(target)) == null ? null : target.getAttribute(idattr);
        Element usernameElem = (Element)NamespaceUtil.getWsseElementsByTagName(target, "Username").item(0);
        String username = DOMUtil.getStringValue(usernameElem);
        char[] password = null;
        QName passwordType = null;
        NodeList passwordElems = NamespaceUtil.getWsseElementsByTagName(target, "Password");
        if (passwordElems.getLength() != 0) {
            Element passwordElem = (Element)passwordElems.item(0);
            String passwordTypeStr = passwordElem.getAttribute("Type");
            if (!passwordTypeStr.equals("") && NamespaceUtil.equals(passwordType = DOMUtil.getQName(passwordElem, passwordTypeStr), Constants.PASSWORD_DIGEST_RCVR)) {
                String wsseSent = Constants.getWSSENS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "UnsupportedSecurityToken"), (String)"security.wssecurity.UsernameTokenReceiver.token08");
            }
            password = DOMUtil.getStringValue(passwordElem).toCharArray();
        }
        this.validateNonceTimestamp(target, context);
        this.validateNonce(target, context);
        LoginMapping loginMapping = mapping = password == null ? this.conf.getLoginMapping("IDAssertion") : this.conf.getLoginMapping("BasicAuth");
        if (mapping != null) {
            Subject subject = ReceiverLogin.login(mapping, username, null, password, context);
            boolean unOnly = password == null;
            TokenResult.Username result = null;
            result = id != null ? new TokenResult.Username(subject, username, unOnly, id) : new TokenResult.Username(subject, username, unOnly, target);
            ResultPool.add(context, result);
        } else {
            Tr.warning(tc, "security.wssecurity.UsernameTokenReceiver.token53");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void validateNonceTimestamp(Element unToken, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNonceTimestamp");
        }
        String wsseSent = Constants.getWSSENS(context);
        NodeList createdElems = NamespaceUtil.getWsuElementsByTagName(unToken, "Created");
        if (createdElems.getLength() == 0) {
            if (this.conf.isNonceTimestampChecked()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Nonce timestamp found in Username token");
                }
                String msgKey = "security.wssecurity.WSEC5192E";
                Tr.error(tc, msgKey);
                throw new SoapSecurityException(Constants.getQName(wsseSent, "InvalidSecurityToken"), msgKey);
            }
        } else {
            long current;
            Element createdElem = (Element)createdElems.item(0);
            String createdStr = DOMUtil.getStringValue(createdElem);
            Date created = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing Nonce timestamp in String format = " + createdStr);
                }
                created = UTC.parse(createdStr);
            }
            catch (ParseException e) {
                String msgKey = "security.wssecurity.WSEC5191E";
                Tr.processException(e, clsName + ".validateNonceTimestamp", "168");
                Tr.error(tc, msgKey, new Object[]{createdStr, e});
                String message = MessageFormat.format(ConfigUtil.getMessage(msgKey), createdStr, e.toString());
                throw new SoapSecurityException(Constants.getQName(wsseSent, "InvalidSecurity"), message, (Throwable)e);
            }
            long serverTime = current = System.currentTimeMillis();
            Long server_time = new Long(current);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current time = " + current + " ms");
            }
            current -= this.conf.getNonceMaxAge();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce max age = " + this.conf.getNonceMaxAge() + " ms, (current - Nonce max age) = " + current + " ms");
            }
            current -= this.conf.getNonceClockSkew();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce clock skew = " + this.conf.getNonceClockSkew() + " ms, (current - Nonce clock skew) = " + current + " ms");
            }
            long nonceCreatedTime = created.getTime();
            Long nonceCreated_time = new Long(nonceCreatedTime);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce created time (timestamp) = " + nonceCreatedTime + " ms");
            }
            if (nonceCreatedTime < current) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce timestamp is not fresh, creation timestamp " + UTC.format(created) + " too old");
                }
                String msgKey_client = "security.wssecurity.WSEC5193E";
                String msgKey_server = "security.wssecurity.WSEC5200E";
                Date serverDate = new Date(serverTime);
                Date createdDate = new Date(nonceCreatedTime);
                SimpleDateFormat userFriendlyFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss Z");
                String svrTime = userFriendlyFormat.format(serverDate);
                String createTime = userFriendlyFormat.format(createdDate);
                Tr.error(tc, msgKey_server, new Object[]{svrTime, createTime});
                throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "FailedAuthentication"), (String)msgKey_client);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is fresh");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNonceTimestamp");
        }
    }

    private void validateNonce(Element unToken, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNonce");
        }
        String wsseSent = Constants.getWSSENS(context);
        NodeList nonceElems = NamespaceUtil.getWsseElementsByTagName(unToken, "Nonce");
        if (nonceElems.getLength() == 0) {
            if (this.conf.isNonceChecked()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Nonce found in Username token");
                }
                String msgKey = "security.wssecurity.WSEC5194E";
                Tr.error(tc, msgKey);
                throw new SoapSecurityException(Constants.getQName(wsseSent, "InvalidSecurityToken"), msgKey);
            }
        } else {
            Element nonceElem = (Element)nonceElems.item(0);
            QName encType = null;
            if (nonceElem.hasAttribute("EncodingType")) {
                encType = DOMUtil.getQName(nonceElem, nonceElem.getAttribute("EncodingType"));
            }
            String nonceStr = DOMUtil.getStringValue(nonceElem);
            byte[] nonce = null;
            if (encType == null || NamespaceUtil.equals(encType, Constants.BASE64_BINARY_RCVR)) {
                nonce = Base64.decode((String)nonceStr);
            } else if (NamespaceUtil.equals(encType, Constants.HEX_BINARY_RCVR)) {
                try {
                    nonce = Hex.decode(nonceStr);
                }
                catch (ParseException e) {
                    String msgKey = "security.wssecurity.WSEC5175E";
                    Tr.processException(e, clsName + ".validateNonce", "262");
                    Tr.error(tc, msgKey, e);
                    String message = MessageFormat.format(ConfigUtil.getMessage(msgKey), e.toString());
                    throw new SoapSecurityException(Constants.getQName(wsseSent, "InvalidSecurity"), message, (Throwable)e);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported encoding type: " + encType.toString());
                }
                String msgKey = "security.wssecurity.UsernameToken.token55";
                Tr.error(tc, msgKey, new Object[]{encType.toString()});
                throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "UnsupportedSecurityToken"), (String)msgKey, (String)encType.toString());
            }
            NonceManager nonceMgr = this.conf.getNonceManager();
            if (nonceMgr == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NonceManager is not set");
                }
                throw SoapSecurityException.format((String)"security.wssecurity.UsernameToken.token56");
            }
            if (!nonceMgr.validate(nonce)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Repeated Nonce: " + nonceStr);
                }
                String msgKey = "security.wssecurity.WSEC5178E";
                Tr.error(tc, msgKey);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseSent, "FailedAuthentication"), (String)msgKey);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNonce");
        }
    }
}

