/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BinaryTokenCallback;
import com.ibm.wsspi.wssecurity.auth.callback.XMLTokenSenderCallback;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SenderLogin
implements SenderLoginComponent {
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(SenderLogin.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    TokenSenderConfig conf = null;

    public void init(Map map) throws Exception {
        this.conf = (TokenSenderConfig)map.get(TokenSenderConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
            }
            String wsseNS = Constants.getWSSENS(context);
            if (this.conf == null) {
                throw SoapSecurityException.format((QName)Constants.getQName(wsseNS, "InvalidSecurity"), (String)"security.wssecurity.ReceiverLogin.token01");
            }
            String authMethod = this.conf.getAuthMethod();
            String idType = this.conf.getIdType();
            String trustMode = this.conf.getTrustMode();
            QName tokenValueType = this.conf.getTokenValueType();
            final CallbackHandler callbackHandler = this.conf.getCallbackHandler();
            boolean integral = this.conf.isIntegral();
            try {
                if ("BasicAuth".equals(authMethod)) {
                    TokenRequest.Username username_token = this.retrieveUsernameTokenByTargetPort();
                    if (username_token == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Existing token not found, prompting for new token.");
                        }
                        username_token = this.getUsernameRequest(callbackHandler, true);
                        RequestPool.add(context, username_token);
                        this.cacheUsernameTokenByTargetPort(username_token);
                    } else {
                        RequestPool.add(context, username_token);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Existing token found.");
                        }
                    }
                    break block26;
                }
                if ("IDAssertion".equals(authMethod)) {
                    if (!idType.equals("X509Certificate")) {
                        String initialSenderId = this.getInitialSenderId();
                        if (initialSenderId == null || initialSenderId.length() == 0) {
                            Tr.error(tc, "security.wssecurity.no.initial.sender");
                            throw SoapSecurityException.format((String)"security.wssecurity.no.initial.sender");
                        }
                        TokenRequest.Username req = new TokenRequest.Username(this.getInitialSenderId(), null, null, false, this.conf.isNonceAdded(), this.conf.getEncodingType(), this.conf.isNonceTimestampAdded());
                        if (trustMode != null) {
                            if (trustMode.equals("BasicAuth")) {
                                RequestPool.add(context, this.getUsernameRequest(callbackHandler, true));
                            } else {
                                req.setSignature(true);
                            }
                        }
                        RequestPool.add(context, req);
                    } else {
                        X509Certificate initialCert = this.getInitialSenderCert();
                        if (initialCert == null) {
                            Tr.error(tc, "security.wssecurity.no.initial.cert");
                            throw SoapSecurityException.format((String)"security.wssecurity.no.initial.cert");
                        }
                        byte[] certBytes = initialCert.getEncoded();
                        TokenRequest.Binary req = new TokenRequest.Binary(Constants.getQName(wsseNS, "X509v3"), certBytes, null, null, integral);
                        if (trustMode != null) {
                            if (trustMode.equals("BasicAuth")) {
                                RequestPool.add(context, this.getUsernameRequest(callbackHandler, true));
                            } else {
                                req.setSignature(true);
                            }
                        }
                        RequestPool.add(context, req);
                    }
                    break block26;
                }
                if ("Signature".equals(authMethod)) break block26;
                final BinaryTokenCallback tokenCB = new BinaryTokenCallback(null, null);
                final XMLTokenSenderCallback XMLCB = new XMLTokenSenderCallback();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException, UnsupportedCallbackException {
                            callbackHandler.handle(new Callback[]{tokenCB, XMLCB});
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                byte[] tokenByte = tokenCB.getCredToken();
                if (tokenByte != null && tokenByte.length != 0) {
                    RequestPool.add(context, new TokenRequest.Binary(tokenValueType, tokenByte, null, null, integral));
                } else {
                    Element[] xmlToken = XMLCB.getXMLTokens();
                    if (xmlToken != null && xmlToken.length != 0) {
                        RequestPool.add(context, new TokenRequest.XML(xmlToken, integral));
                    }
                }
            }
            catch (Exception e) {
                throw SoapSecurityException.format((QName)Constants.getQName(wsseNS, "InvalidSecurity"), (String)"security.wssecurity.SenderLogin.token32", (String)e.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    protected TokenRequest.Username getUsernameRequest(CallbackHandler callbackHandler, boolean withPass) throws Exception {
        NameCallback nameCB = new NameCallback(ConfigUtil.getMessage("security.wssecurity.SenderLogin.token29"));
        PasswordCallback passwordCB = new PasswordCallback(ConfigUtil.getMessage("security.wssecurity.SenderLogin.token30"), false);
        if (withPass) {
            callbackHandler.handle(new Callback[]{nameCB, passwordCB});
        } else {
            callbackHandler.handle(new Callback[]{nameCB});
        }
        String username = nameCB.getName();
        String password = withPass ? new String(passwordCB.getPassword()) : null;
        return new TokenRequest.Username(username, password, null, this.conf.isIntegral(), this.conf.isNonceAdded(), this.conf.getEncodingType(), this.conf.isNonceTimestampAdded());
    }

    protected String getInitialSenderId() throws SoapSecurityException {
        return "initialSender";
    }

    protected X509Certificate getInitialSenderCert() throws SoapSecurityException {
        return null;
    }

    protected void cacheUsernameTokenByTargetPort(TokenRequest.Username username_token) throws SoapSecurityException {
    }

    protected TokenRequest.Username retrieveUsernameTokenByTargetPort() throws SoapSecurityException {
        return null;
    }
}

