/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.dsig;

import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TemplateGenerator;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.dsig.SignerRequest;
import com.ibm.xml.soapsec.dsig.TemplateModifier;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SignatureSender
implements SoapSecurityComponent {
    static boolean USE_XPATH = false;
    static boolean USE_EMBEDDED = false;
    private static final String SIGNATURE_PREFIX = "ds";
    private static final TraceComponent tc = Tr.register(SignatureSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    SenderConfig gconfig;
    SignatureSenderConfig config;
    private IdUtil idResolver;
    private static final String BODY = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']";
    static final String BODY_XPATH = "count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::*) = count(/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::node() | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/@* | /*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Body']/descendant::*/namespace::* | .)";

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.gconfig = (SenderConfig)map.get(SenderConfig.class);
        this.config = (SignatureSenderConfig)map.get(SignatureSenderConfig.class);
        this.idResolver = IdUtil.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    private static boolean matchClass(Class cl, String className) {
        if (cl.getName().equals(className)) {
            return true;
        }
        Class superclass = cl.getSuperclass();
        if (superclass != null && SignatureSender.matchClass(superclass, className)) {
            return true;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!SignatureSender.matchClass(interfaces[i], className)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object obj, String className) {
        return SignatureSender.matchClass(obj.getClass(), className);
    }

    private static void addReferenceForBody(TemplateGenerator gen, Document doc, SignatureSenderConfig config, String wsuNSSent) {
        Reference ref;
        if (USE_XPATH) {
            ref = gen.createReference("");
            ref.addXPathTransform(BODY_XPATH);
            ref.addTransform(config.getCanonicalizationMethod());
        } else {
            String idname = null;
            Element el = doc.getDocumentElement();
            el = DOMUtil.getFirstElement(el, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
            String attrname = IdUtil.getInstance().getIdAttributeName(el);
            if (attrname != null) {
                idname = el.getAttribute(attrname);
            }
            if (idname == null || idname.length() == 0) {
                idname = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_body_id_");
                el.setAttributeNS(wsuNSSent, "wsu:Id", idname);
                el.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", wsuNSSent);
            }
            ref = gen.createReference("#" + idname);
            String c14n = config.getCanonicalizationMethod();
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(c14n) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(c14n)) {
                HashSet<String> prefixes = new HashSet<String>();
                for (Node cur = el; cur != null && cur.getNodeType() == 1; cur = cur.getParentNode()) {
                    NamedNodeMap map = cur.getAttributes();
                    int len = map == null ? 0 : map.getLength();
                    for (int i = 0; i < len; ++i) {
                        String attrn = map.item(i).getNodeName();
                        if (attrn.equals("xmlns")) {
                            prefixes.add("#default");
                            continue;
                        }
                        if (!attrn.startsWith("xmlns:")) continue;
                        prefixes.add(attrn.substring(6));
                    }
                }
                SignatureSender.scanNamespaceDecls(el, prefixes);
                Element tr = doc.createElementNS(Constants.NS_DSIG, "Transform");
                tr.setAttributeNS(null, "Algorithm", c14n);
                if (prefixes.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    Iterator iter = prefixes.iterator();
                    while (iter.hasNext()) {
                        buffer.append(iter.next());
                        buffer.append(" ");
                    }
                    Element inc = doc.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
                    inc.setAttributeNS(Constants.NS_XMLNS, "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
                    inc.setAttributeNS(null, "PrefixList", new String(buffer));
                    tr.appendChild(inc);
                }
                ref.addTransform(tr);
            } else {
                ref.addTransform(c14n);
            }
        }
        gen.addReference(ref);
    }

    private static void scanNamespaceDecls(Node el, Set prefixes) {
        NamedNodeMap map = el.getAttributes();
        int len = map == null ? 0 : map.getLength();
        for (int i = 0; i < len; ++i) {
            String attrn = map.item(i).getNodeName();
            if (attrn.equals("xmlns")) {
                prefixes.add("#default");
                continue;
            }
            if (!attrn.startsWith("xmlns:")) continue;
            prefixes.add(attrn.substring(6));
        }
        for (Node n = el.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            SignatureSender.scanNamespaceDecls(n, prefixes);
        }
    }

    public void invoke(Document doc, Element security2, Map context) throws Exception {
        X509Certificate cert;
        Key key;
        boolean signSomething = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + security2 + "," + context + ")");
        }
        String signatureMethod = this.config.getSignatureMethod();
        String keyName = this.config.getKeyName();
        KeyLocator locator = this.config.getKeyLocator();
        Request[] requests = RequestPool.get(context, SignerRequest.class);
        if (requests.length == 0) {
            key = locator.getSigningKey(keyName);
            cert = (X509Certificate)locator.getCertificate(keyName);
        } else {
            if (requests.length > 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, requests.length + " SignerRequests. Using the first one");
            }
            SignerRequest signer = (SignerRequest)requests[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Switch signer to: " + signer.getAlias());
            }
            key = locator.getSigningKey(signer.getAlias());
            cert = (X509Certificate)locator.getCertificate(signer.getAlias());
        }
        if (signatureMethod == null) {
            if (SignatureSender.instanceOf(key, "java.security.interfaces.DSAPrivateKey")) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (SignatureSender.instanceOf(key, "java.security.interfaces.RSAPrivateKey")) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                Tr.warning(tc, "security.wssecurity.SignatureSender.unknownKey", key.getClass().getName());
            }
        }
        TemplateGenerator gen = new TemplateGenerator(doc, this.config.getDigestMethod(), this.config.getCanonicalizationMethod(), signatureMethod);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        Iterator iter = this.config.getIntegralParts().iterator();
        String wsuSent = Constants.getWSUNS(context);
        while (iter.hasNext()) {
            String part = (String)iter.next();
            if (!part.equals("body")) continue;
            SignatureSender.addReferenceForBody(gen, doc, this.config, wsuSent);
            signSomething = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining RequestPool.");
        }
        requests = RequestPool.get(context, SignatureRequest.class);
        for (int i = 0; i < requests.length; ++i) {
            SignatureRequest req = (SignatureRequest)requests[i];
            if (req.isBodyRequest()) {
                throw SoapSecurityException.format((String)"security.wssecurity.SignatureSender.dsig02");
            }
            Reference ref = gen.createReference("#" + req.getIdName());
            ref.addTransform(this.config.getCanonicalizationMethod());
            gen.addReference(ref);
            signSomething = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generating a template.");
        }
        if (!signSomething) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element security, Map context)");
            }
            return;
        }
        Element template = gen.getSignatureElement();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Apply TemplateModifiers.");
        }
        iter = this.config.getTemplateModifiers().iterator();
        while (iter.hasNext()) {
            ((TemplateModifier)iter.next()).modifyTemplate(template);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting to Sign.");
        }
        String bstid = null;
        security2.insertBefore(template, security2.getFirstChild());
        if (this.config.getPreC14n()) {
            SignatureSender.preC14n(doc, template);
        }
        if (this.gconfig.doIndentation()) {
            security2.insertBefore(doc.createTextNode("\n      "), template);
        } else {
            DOMUtil.removeIndentation(security2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Template: " + new String(XPathCanonicalizer.serializeSubset((Node)template, (boolean)true)));
        }
        String c14n = this.config.getCanonicalizationMethod();
        if (this.config.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(c14n) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(c14n))) {
            Element c14nElem;
            HashSet<String> prefixes = new HashSet<String>();
            for (Node cur = c14nElem = DOMUtil.getOneElement(template, Constants.NS_DSIG, "CanonicalizationMethod"); cur != null && cur.getNodeType() == 1; cur = cur.getParentNode()) {
                NamedNodeMap map = cur.getAttributes();
                int len = map == null ? 0 : map.getLength();
                for (int i = 0; i < len; ++i) {
                    String attrn = map.item(i).getNodeName();
                    if (attrn.equals("xmlns")) {
                        prefixes.add("#default");
                        continue;
                    }
                    if (!attrn.startsWith("xmlns:")) continue;
                    prefixes.add(attrn.substring(6));
                }
            }
            SignatureSender.scanNamespaceDecls(c14nElem, prefixes);
            if (prefixes.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                iter = prefixes.iterator();
                while (iter.hasNext()) {
                    buffer.append(iter.next());
                    buffer.append(" ");
                }
                Element inc = doc.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "ec:InclusiveNamespaces");
                inc.setAttributeNS(Constants.NS_XMLNS, "xmlns:ec", "http://www.w3.org/2001/10/xml-exc-c14n#");
                inc.setAttributeNS(null, "PrefixList", new String(buffer));
                c14nElem.appendChild(inc);
            }
        }
        SignatureContext sigcontext = new SignatureContext();
        if (tc.isDebugEnabled()) {
            sigcontext.setResourceShower((ResourceShower)ShowerImpl.getInstance());
        }
        sigcontext.setIDResolver((IDResolver)this.idResolver);
        String wsseNSSent = Constants.getWSSENS(context);
        if (USE_EMBEDDED) {
            SignatureSender.insertEmbedded(template, cert.getEncoded(), wsseNSSent);
        } else {
            bstid = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_binary_security_token_id_");
            SignatureSender.insertTokenReference(template, bstid, wsseNSSent);
        }
        if (this.gconfig.doIndentation()) {
            DOMUtil.indent(template, 6, 2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        sigcontext.sign(template, key);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (!USE_EMBEDDED) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Requesting a BinarySecurityToken for the signer certificate");
            }
            TokenRequest.Binary req = new TokenRequest.Binary(Constants.getQName(wsseNSSent, "X509v3"), cert.getEncoded(), bstid, null);
            RequestPool.add(context, req);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element security, Map context)");
        }
    }

    private static void insertTokenReference(Element sig, String tokenid, String wsseNS) {
        Document factory = sig.getOwnerDocument();
        Element ref = factory.createElementNS(wsseNS, "wsse:Reference");
        ref.setAttribute("URI", "#" + tokenid);
        Element tokenref = SignatureSender.insertSTR(sig, wsseNS);
        tokenref.appendChild(ref);
    }

    private static void insertEmbedded(Element sig, byte[] tokenBytes, String wsseNS) throws SoapSecurityException {
        Document factory = sig.getOwnerDocument();
        Element bst = factory.createElementNS(wsseNS, "wsse:BinarySecurityToken");
        bst.appendChild(factory.createTextNode(Base64.encode((byte[])tokenBytes)));
        Element embedded = factory.createElementNS(wsseNS, "wsse:Embedded");
        embedded.appendChild(bst);
        Element tokenref = SignatureSender.insertSTR(sig, wsseNS);
        tokenref.appendChild(embedded);
        DOMUtil.setQNameAttr(bst, null, "ValueType", Constants.getQName(wsseNS, "X509v3"));
        DOMUtil.setQNameAttr(bst, null, "EncodingType", Constants.getQName(wsseNS, "Base64Binary"));
    }

    private static Element insertSTR(Element sig, String wsseNS) {
        Document factory = sig.getOwnerDocument();
        Element tokenref = factory.createElementNS(wsseNS, "wsse:SecurityTokenReference");
        tokenref.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", wsseNS);
        String qname = "KeyInfo";
        if (sig.getPrefix() != null) {
            qname = sig.getPrefix() + ":KeyInfo";
        }
        Element keyinfo = factory.createElementNS(Constants.NS_DSIG, qname);
        qname = "xmlns";
        if (sig.getPrefix() != null) {
            qname = "xmlns:" + sig.getPrefix();
        }
        keyinfo.setAttributeNS(Constants.NS_XMLNS, qname, Constants.NS_DSIG);
        keyinfo.appendChild(tokenref);
        sig.appendChild(keyinfo);
        return tokenref;
    }

    private static void preC14n(Document doc, Element signature) {
        String DSIG_SI = "Sig";
        String BODY2 = "S";
        Element body = DOMUtil.getFirstElement(doc.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        SignatureSender.setPrefix(body, body.getPrefix(), "S");
        body.setAttributeNS(Constants.NS_XMLNS, "xmlns:S", "http://schemas.xmlsoap.org/soap/envelope/");
        String nsdecl = "xmlns";
        if (signature.getPrefix() != null) {
            nsdecl = "xmlns:" + signature.getPrefix();
        }
        signature.removeAttribute(nsdecl);
        SignatureSender.setPrefix(signature, signature.getPrefix(), SIGNATURE_PREFIX);
        nsdecl = "xmlns";
        if (SIGNATURE_PREFIX != null) {
            nsdecl = "xmlns:ds";
        }
        signature.setAttributeNS(Constants.NS_XMLNS, nsdecl, Constants.NS_DSIG);
        Element signedinfo = DOMUtil.getFirstElement(signature, Constants.NS_DSIG, "SignedInfo");
        SignatureSender.setPrefix(signedinfo, signedinfo.getPrefix(), "Sig");
        signedinfo.setAttributeNS(Constants.NS_XMLNS, "xmlns:Sig", Constants.NS_DSIG);
    }

    static void setPrefix(Element el, String fromPrefix, String prefix) {
        if (el.getPrefix() == null) {
            if (fromPrefix == null) {
                el.setPrefix(prefix);
            }
        } else if (el.getPrefix().equals(fromPrefix)) {
            el.setPrefix(prefix);
        }
        if (fromPrefix != null) {
            NamedNodeMap map = el.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Attr a = (Attr)map.item(i);
                if (a.getPrefix() == null || !a.getPrefix().equals(fromPrefix)) continue;
                a.setPrefix(prefix);
            }
        }
        Node ch = DOMUtil.getFirstChild2(el);
        while (ch != null) {
            switch (ch.getNodeType()) {
                case 1: {
                    SignatureSender.setPrefix((Element)ch, fromPrefix, prefix);
                }
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(Element owner, int count, String uri, String type, byte[] content, String encoding) {
            String dumpData = null;
            try {
                dumpData = encoding == null ? new String(content, "UTF-8") : new String(content, encoding);
            }
            catch (Exception e) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + encoding + "].");
            }
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: " + dumpData);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + count + ": " + dumpData);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + uri + ": " + dumpData);
            }
        }
    }
}

