/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.WriteBackResult;
import com.ibm.xml.soapsec.dsig.SignatureReceiver;
import com.ibm.xml.soapsec.dsig.SignatureReceiverConfig;
import com.ibm.xml.soapsec.dsig.SignatureResult;
import com.ibm.xml.soapsec.dsig.SignedPartChecker;
import com.ibm.xml.soapsec.enc.EncryptedPartChecker;
import com.ibm.xml.soapsec.enc.EncryptionReceiver;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.proxy.SOAPEnvelopeProxy;
import com.ibm.xml.soapsec.proxy.SOAPHeaderElementProxy;
import com.ibm.xml.soapsec.time.TimestampChecker;
import com.ibm.xml.soapsec.time.TimestampReceiver;
import com.ibm.xml.soapsec.time.TimestampReceiverConfig;
import com.ibm.xml.soapsec.token.BinaryTokenReceiver;
import com.ibm.xml.soapsec.token.LoginResult;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.ReceiverLoginComponent;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.token.UsernameTokenReceiver;
import com.ibm.xml.soapsec.token.XMLTokenReceiver;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SoapSecurityReceiver {
    public static final String CONFIG_KEY;
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map handlerOption = new HashMap();
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private static final String clsName;

    public void setHandlerOption(String key, Object value2) {
        this.handlerOption.put(key, value2);
    }

    public Object getHandlerOption(String key) {
        return this.handlerOption.get(key);
    }

    private Map getHandlerOptions() {
        return this.handlerOption;
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap map = (HashMap)this._messageConfig.get();
        if (map == null) {
            map = new HashMap();
            this._messageConfig.set(map);
        }
        return map;
    }

    public void setMessageOption(String key, Object value2) {
        this.getMessageConfig().put(key, value2);
    }

    public Object getMessageOption(String key) {
        return this.getMessageConfig().get(key);
    }

    public Map getMessageOptions() {
        return this.getMessageConfig();
    }

    public void init() {
    }

    protected void initConfig(MessageContextProxy context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + context + ")");
        }
        SignatureReceiver signatureReceiver = new SignatureReceiver();
        SignedPartChecker checker = new SignedPartChecker();
        UsernameTokenReceiver tokenReceiver = new UsernameTokenReceiver();
        BinaryTokenReceiver binaryReceiver = new BinaryTokenReceiver();
        XMLTokenReceiver xmlReceiver = new XMLTokenReceiver();
        ReceiverLoginComponent login = this.createLoginComponent();
        TimestampReceiver tsreceiver = new TimestampReceiver();
        TimestampChecker tschecker = new TimestampChecker();
        EncryptionReceiver encryptionReceiver = new EncryptionReceiver();
        EncryptedPartChecker encChecker = new EncryptedPartChecker();
        ReceiverConfig config = (ReceiverConfig)this.getMessageOption(CONFIG_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configuration object is as follows:", new Object[]{config});
        }
        try {
            HashMap<Class<TimestampReceiverConfig>, Object> map = new HashMap<Class<TimestampReceiverConfig>, Object>();
            map.put(ReceiverConfig.class, config);
            map.put(SignatureReceiverConfig.class, config.getSignatureConfig());
            map.put(TokenReceiverConfig.class, config.getTokenConfig());
            map.put(EncryptionReceiverConfig.class, config.getDecryptionConfig());
            map.put(TimestampReceiverConfig.class, config.getTimestampConfig());
            signatureReceiver.init(map);
            checker.init(map);
            tokenReceiver.init(map);
            binaryReceiver.init(map);
            xmlReceiver.init(map);
            login.init(map);
            tsreceiver.init(map);
            tschecker.init(map);
            encryptionReceiver.init(map);
            encChecker.init(map);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".initConfig", "137", this);
            Tr.error(tc, "security.wssecurity.SoapSecurityReceiver.initConfig", e);
            throw new RuntimeException(e.getMessage());
        }
        this.setMessageOption(SignatureReceiver.class.getName(), signatureReceiver);
        this.setMessageOption(SignedPartChecker.class.getName(), checker);
        this.setMessageOption(UsernameTokenReceiver.class.getName(), tokenReceiver);
        this.setMessageOption(BinaryTokenReceiver.class.getName(), binaryReceiver);
        this.setMessageOption(XMLTokenReceiver.class.getName(), xmlReceiver);
        this.setMessageOption(ReceiverLoginComponent.class.getName(), login);
        this.setMessageOption(TimestampReceiver.class.getName(), tsreceiver);
        this.setMessageOption(TimestampChecker.class.getName(), tschecker);
        this.setMessageOption(EncryptionReceiver.class.getName(), encryptionReceiver);
        this.setMessageOption(EncryptedPartChecker.class.getName(), encChecker);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContext context)");
        }
    }

    protected boolean adjustContext(MessageContextProxy context, Map ccontext) throws FaultProxy {
        return false;
    }

    protected boolean backContext(MessageContextProxy context, Map ccontext) throws FaultProxy {
        return false;
    }

    protected ReceiverLoginComponent createLoginComponent() {
        return new ReceiverLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContextProxy context) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + context + ")");
        }
        this.clear();
        try {
            Document doc;
            boolean mustUnderstand = false;
            MessageProxy inMessage = context.getCurrentMessage();
            this.initConfig(context);
            ReceiverConfig config = (ReceiverConfig)this.getMessageOption(CONFIG_KEY);
            try {
                config.validate();
            }
            catch (SoapSecurityException sse) {
                Tr.processException((Throwable)sse, clsName + ".invoke", "198", this);
                Tr.error(tc, "security.wssecurity.config.invalid", (Object)sse);
                throw FaultProxy.makeFault(sse);
            }
            try {
                doc = inMessage.getDocument();
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + "invoke", "%C", this);
                Tr.error(tc, "security.wssecuritymessage.getDocument", e);
                throw FaultProxy.makeFault(e);
            }
            Element security2 = SoapSecurityReceiver.getSecurityHeader(doc, config.getMyActor());
            if (security2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke wsse:Security found: " + security2);
                }
                mustUnderstand = ConfigUtil.isTrue(security2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand"));
                ConfigUtil.setMustUnderstand(context, mustUnderstand);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoke wsse:Security.mustUnderstand: " + mustUnderstand);
                }
            }
            if (!(config.isSignatureRequired() || config.isLoginRequired() || config.isDecryptionRequired() || config.getTimestampConfig() != null && config.getTimestampConfig().addReceivedTimestamp() || mustUnderstand)) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "invoke(MessageContextProxy context)");
                return;
            }
            if (security2 == null && (config.isSignatureRequired() || config.isLoginRequired() || config.isDecryptionRequired()) && SoapSecurityReceiver.countSecurityHeaders(doc) > 0) {
                SoapSecurityException e = config.getMyActor() == null || config.getMyActor().trim().length() == 0 ? new SoapSecurityException("The Application Server expected a Security header with the " + Constants.NS_WSSE + " or " + Constants.NS_WSSE200207 + " or " + Constants.NS_WSSE200204 + " namespace, but it was not found.") : new SoapSecurityException("The Application Server expected a Security header with the " + Constants.NS_WSSE + " or " + Constants.NS_WSSE200207 + " or " + Constants.NS_WSSE200204 + " namespace and the " + config.getMyActor() + " actor, but it was not found.");
                throw FaultProxy.makeFault(e);
            }
            HashMap<String, Object> componentContext = new HashMap<String, Object>();
            ResultPool.initialize(componentContext);
            this.adjustContext(context, componentContext);
            String wsseTmp = (String)context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace");
            boolean bConfiguredNS = wsseTmp != null && wsseTmp.length() != 0;
            try {
                Result[] result;
                if (!bConfiguredNS) {
                    String wsuNS;
                    String wsseNS;
                    if (security2 != null) {
                        wsseNS = security2.getNamespaceURI();
                        if (wsseNS == null || wsseNS.length() == 0 || !NamespaceUtil.isWsse(wsseNS)) throw SoapSecurityException.format((String)"security.wssecurity.WSEC6720E", (String)wsseNS);
                        context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", wsseNS);
                        wsuNS = NamespaceUtil.getCorrespondingWSUNS(wsseNS);
                        if (wsuNS != null && wsuNS.length() != 0) {
                            context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", wsuNS);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No wsu namespace found for " + wsseNS);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Incoming namespaces, wsse = " + wsseNS + ", wsu = " + wsuNS);
                        }
                    } else {
                        Tr.warning(tc, "security.wssecurity.SoapSecurityReceiver.getSecurityHeader", config.getMyActor());
                        context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", Constants.NS_WSSE);
                        Element timestamp = null;
                        String ns1 = null;
                        String ns2 = null;
                        timestamp = TimestampReceiver.getTimestampHeader(doc, true);
                        if (timestamp != null) {
                            ns1 = timestamp.getNamespaceURI();
                        }
                        if ((timestamp = TimestampReceiver.getTimestampHeader(doc, false)) != null) {
                            ns2 = timestamp.getNamespaceURI();
                        }
                        if (!(ns1 != null && ns1.length() != 0 || ns2 != null && ns2.length() != 0)) {
                            context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", Constants.NS_WSU);
                        } else if (ns1 == null || ns1.length() == 0) {
                            if (!NamespaceUtil.isWsu(ns2)) throw SoapSecurityException.format((String)"security.wssecurity.WSEC6720E", (String)ns2);
                            context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", ns2);
                        } else if (ns2 == null || ns2.length() == 0) {
                            if (!NamespaceUtil.isWsu(ns1)) throw SoapSecurityException.format((String)"security.wssecurity.WSEC6720E", (String)ns1);
                            context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", ns1);
                        } else {
                            if (ns1.compareTo(ns2) != 0) throw SoapSecurityException.format((String)"security.wssecurity.WSEC6721E", (String)ns1, (String)ns2);
                            if (!NamespaceUtil.isWsu(ns1)) throw SoapSecurityException.format((String)"security.wssecurity.WSEC6720E", (String)ns1);
                            context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", ns1);
                        }
                    }
                    if (!NamespaceUtil.validate(context)) {
                        wsseNS = (String)context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace");
                        wsuNS = (String)context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace");
                        throw SoapSecurityException.format((String)"security.wssecurity.WSEC6721E", (String)("wsse=" + wsseNS), (String)("wsu=" + wsuNS));
                    }
                }
                componentContext.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace"));
                componentContext.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", context.getConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace"));
                this.invokeComponent(doc, SoapSecuritySender.getHeader(doc), componentContext, TimestampReceiver.class);
                if (security2 != null) {
                    Element el = DOMUtil.getFirstElement(security2);
                    while (el != null) {
                        String ns = el.getNamespaceURI();
                        String ln = el.getLocalName();
                        if (Constants.NS_DSIG.equals(ns) && ln.equals("Signature")) {
                            if (config.isSignatureReady()) {
                                this.invokeComponent(doc, el, componentContext, SignatureReceiver.class);
                            } else {
                                try {
                                    this.invokeComponent(doc, el, componentContext, SignatureReceiver.class);
                                }
                                catch (Exception ex) {
                                    Tr.processException((Throwable)ex, clsName + ".invoke", "276", this);
                                    Tr.error(tc, "security.wssecurity.invaliddsig.ignore", ex);
                                }
                            }
                        } else if (NamespaceUtil.isWsse(ns) && ln.equals("UsernameToken")) {
                            this.invokeComponent(doc, el, componentContext, UsernameTokenReceiver.class);
                        } else if (NamespaceUtil.isWsse(ns) && ln.equals("BinarySecurityToken")) {
                            this.invokeComponent(doc, el, componentContext, BinaryTokenReceiver.class);
                        } else if (Constants.NS_ENC.equals(ns) && (ln.equals("EncryptedKey") || ln.equals("ReferenceList"))) {
                            this.invokeComponent(doc, el, componentContext, EncryptionReceiver.class);
                        } else {
                            this.invokeComponent(doc, el, componentContext, XMLTokenReceiver.class);
                        }
                        el = DOMUtil.getNextElement(el);
                    }
                }
                if (config.isSignatureRequired()) {
                    this.invokeComponent(doc, null, componentContext, SignedPartChecker.class);
                }
                if (config.isDecryptionRequired()) {
                    this.invokeComponent(doc, null, componentContext, EncryptedPartChecker.class);
                }
                if (config.isLoginRequired()) {
                    this.invokeComponent(doc, null, componentContext, ReceiverLoginComponent.class);
                }
                this.invokeComponent(doc, null, componentContext, TimestampChecker.class);
                Result[] resultLogin = ResultPool.get(componentContext, LoginResult.class);
                Result[] resultSign = ResultPool.get(componentContext, SignatureResult.class);
                Result[] resultToken = ResultPool.get(componentContext, TokenResult.X509.class);
                this.processCertificateResults(resultSign, resultToken, context);
                if (resultLogin.length != 0) {
                    this.processLoginResults(resultLogin, context);
                }
                if ((result = ResultPool.get(componentContext, SignatureResult.class)).length != 0) {
                    context.setConfig("com.ibm.xml.soapsec.RequestCert", ((SignatureResult)result[0]).getCertificate());
                }
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".invoke", "321", this);
                Tr.error(tc, "security.wssecurity.invoke.exception", new Object[]{context.getTargetEndpointAddress(), e});
                throw FaultProxy.makeFault(e);
            }
            if (ResultPool.get(componentContext, WriteBackResult.class).length > 0) {
                try {
                    MessageProxy m = MessageFactory.getInstance().create(doc, inMessage);
                    context.setCurrentMessage(m);
                }
                catch (Exception e) {
                    throw FaultProxy.makeFault(e);
                }
            }
            this.backContext(context, componentContext);
            SOAPEnvelopeProxy inEnv = context.getCurrentMessage().getSOAPEnvelope();
            SOAPHeaderElementProxy header2 = NamespaceUtil.getWsseHeaderByName(inEnv, "Security", false);
            if (header2 != null) {
                header2.setProcessed(true);
            }
            if ((header2 = NamespaceUtil.getWsuHeaderByName(inEnv, "Timestamp", true)) != null) {
                header2.setProcessed(true);
            }
            ResultPool.finalize(componentContext);
        }
        finally {
            this.clear();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "invoke(MessageContextProxy context)");
    }

    public void onFault(MessageContextProxy context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(" + context + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContextProxy context)");
        }
    }

    protected void processLoginResults(Result[] results, MessageContextProxy context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processLoginResults(" + results + "," + context + ")");
            Tr.exit(tc, "processLoginResults(Result[] results, MessageContext context)");
        }
    }

    protected void processCertificateResults(Result[] resultSign, Result[] resultToken, MessageContextProxy context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCertificateResults(" + resultSign + "," + resultToken + "," + context + ")");
            Tr.exit(tc, "processCertificateResults(Result[] resultSign, Result [] resultToken, MessageContext context)");
        }
    }

    private void invokeComponent(Document doc, Element target, Map context, Class cl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(" + doc + "," + target + "," + context + "," + cl + ")");
        }
        SoapSecurityComponent receiver = this.getComponent(cl);
        receiver.invoke(doc, target, context);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(Document doc, Element target, Map context, Class cl)");
        }
    }

    private SoapSecurityComponent getComponent(Class cl) {
        return (SoapSecurityComponent)this.getMessageOption(cl.getName());
    }

    private static Element getSecurityHeader(Document doc, String actor) {
        Element header2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityHeader(" + doc + "," + actor + ")");
        }
        if ((header2 = DOMUtil.getFirstElement(doc.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns null");
            }
            return null;
        }
        Element el = DOMUtil.getFirstElement(header2);
        while (el != null) {
            if (NamespaceUtil.isWsse(el.getNamespaceURI()) && "Security".equals(el.getLocalName())) {
                String ac = null;
                if (el.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor") != null) {
                    ac = el.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
                }
                if (actor == null && ac == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Document doc, String  actor) returns " + el);
                    }
                    return el;
                }
                if (actor != null && ac != null && actor.equals(ac)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns " + el);
                    }
                    return el;
                }
            }
            el = DOMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader(Document doc, String actor) returns null");
        }
        return null;
    }

    private static int countSecurityHeaders(Document doc) {
        Element header2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "countSecurityHeaders(" + doc + ")");
        }
        if ((header2 = DOMUtil.getFirstElement(doc.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "countSecurityHeaders(Document doc) returns zero");
            }
            return 0;
        }
        int count = 0;
        Element el = DOMUtil.getFirstElement(header2);
        while (el != null) {
            if ("Security".equals(el.getLocalName())) {
                ++count;
            }
            el = DOMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "countSecurityHeaders(Document doc) returns " + count);
        }
        return count;
    }

    static {
        String setup_jce = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("setup-jce");
            }
        });
        if (setup_jce != null) {
            SetupJCEProviders.setup();
        }
        CONFIG_KEY = ReceiverConfig.class.getName();
        tc = Tr.register(SoapSecurityReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        clsName = SoapSecurityReceiver.class.getName();
    }
}

