/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.xml.soapsec.Request;
import java.util.Map;
import java.util.Vector;

public class RequestPool {
    private static Request[] emptyRequests = new Request[0];

    public static Request[] get(Map context, Class c) {
        Object obj;
        int i;
        int count = 0;
        Vector pool2 = (Vector)context.get(RequestPool.class);
        if (pool2 == null) {
            return emptyRequests;
        }
        for (i = 0; i < pool2.size(); ++i) {
            obj = pool2.elementAt(i);
            if (!RequestPool.matchClass(obj.getClass(), c)) continue;
            ++count;
        }
        Request[] ret = new Request[count];
        count = 0;
        for (i = 0; i < pool2.size(); ++i) {
            obj = pool2.elementAt(i);
            if (!RequestPool.matchClass(obj.getClass(), c)) continue;
            ret[count++] = (Request)obj;
        }
        return ret;
    }

    protected static boolean matchClass(Class cl, Class c) {
        if (cl.equals(c)) {
            return true;
        }
        Class superclass = cl.getSuperclass();
        if (superclass != null && RequestPool.matchClass(superclass, c)) {
            return true;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!RequestPool.matchClass(interfaces[i], c)) continue;
            return true;
        }
        return false;
    }

    public static void remove(Map context, Request req) {
        Vector pool2 = (Vector)context.get(RequestPool.class);
        if (pool2 == null) {
            return;
        }
        pool2.removeElement(req);
    }

    public static void remove(Map context, Request[] reqs) {
        for (int i = 0; i < reqs.length; ++i) {
            RequestPool.remove(context, reqs[i]);
        }
    }

    public static void removeAll(Map context) {
        Vector pool2 = (Vector)context.get(RequestPool.class);
        if (pool2 == null) {
            return;
        }
        pool2.removeAllElements();
    }

    public static void add(Map context, Request req) {
        Vector<Request> pool2 = (Vector<Request>)context.get(RequestPool.class);
        if (pool2 == null) {
            pool2 = new Vector<Request>();
            context.put(RequestPool.class, pool2);
        }
        pool2.addElement(req);
    }

    public static void initialize(Map context) {
        RequestPool.removeAll(context);
    }

    public static void finalize(Map context) {
        RequestPool.removeAll(context);
        context.remove(RequestPool.class);
    }
}

