/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.Registry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;

public abstract class EndpointReferenceManager
extends com.ibm.websphere.wsaddressing.EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.wsspi.wsaddressing.EndpointReferenceManager";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceManager.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    protected static final EndpointReferenceManager _endpointReferenceManager;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";

    protected abstract EndpointReference createConcreteEndpointReference(SOAPElement var1) throws EndpointReferenceCreationException;

    protected static EndpointReferenceManager getWsspiEPRManager() {
        return _endpointReferenceManager;
    }

    public static EndpointReference createEndpointReference(SOAPElement soapElement) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", soapElement);
        }
        EndpointReference epr = null;
        if (com.ibm.websphere.wsaddressing.EndpointReferenceManager.getEPRManager() != null) {
            epr = EndpointReferenceManager.getWsspiEPRManager().createConcreteEndpointReference(soapElement);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", epr);
        }
        return epr;
    }

    public static URI getURIForEndpoint(QName serviceName, String endpointName) throws URIGenerationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] objects = new Object[]{serviceName, endpointName};
            Tr.entry(TRACE_COMPONENT, "getURIForEndpoint", objects);
        }
        URI uri = null;
        if (com.ibm.websphere.wsaddressing.EndpointReferenceManager.getEPRManager() != null) {
            uri = EndpointReferenceManager.getWsspiEPRManager().getConcreteURIForEndpoint(serviceName, endpointName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getURIForEndpoint", uri);
        }
        return uri;
    }

    public static EndpointReference createEndpointReference(URI address) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", address);
        }
        EndpointReference epr = null;
        epr = EndpointReferenceManager.getWsspiEPRManager().createConcreteEndpointReference(address);
        Object[] returned = new Object[]{epr};
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", returned);
        }
        return epr;
    }

    public static EndpointReference createEndpointReference(AttributedURI address) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", address);
        }
        EndpointReference epr = null;
        epr = EndpointReferenceManager.getWsspiEPRManager().createConcreteEndpointReference(address);
        Object[] returned = new Object[]{epr};
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", returned);
        }
        return epr;
    }

    public static SOAPElement getSOAPElementReferenceParameterFromMessageContext(QName name2) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", name2);
        }
        SOAPElement referenceParameter = Registry.getCombinedReferenceParameterReader().getSOAPElementReferenceParameterFromMessageContext(name2);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", referenceParameter);
        }
        return referenceParameter;
    }

    protected abstract EndpointReference createConcreteEndpointReference(URI var1) throws EndpointReferenceCreationException;

    protected abstract EndpointReference createConcreteEndpointReference(AttributedURI var1) throws EndpointReferenceCreationException;

    protected abstract URI getConcreteURIForEndpoint(QName var1, String var2) throws URIGenerationException;

    private static void traceAndFFDCException(Exception e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught a " + exceptionName + ": " + exceptionMessage + " when trying to create a new concrete EndpointReferenceManager instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, CLASSNAME, "1:1.16:285");
    }

    static {
        EndpointReferenceManager eprManager = null;
        try {
            eprManager = (EndpointReferenceManager)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException e) {
            EndpointReferenceManager.traceAndFFDCException(e);
        }
        catch (IllegalAccessException e) {
            EndpointReferenceManager.traceAndFFDCException(e);
        }
        catch (ClassNotFoundException e) {
            EndpointReferenceManager.traceAndFFDCException(e);
        }
        _endpointReferenceManager = eprManager;
    }
}

