/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.common.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class IdentityAssertionLoginModule
implements LoginModule {
    protected boolean debug = true;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final WebSphereRuntimePermission IDENTITY_ASSERTION_INITIALIZE = new WebSphereRuntimePermission("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.initialize");
    private static final WebSphereRuntimePermission IDENTITY_ASSERTION_LOGIN = new WebSphereRuntimePermission("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.login");
    private static final TraceComponent tc = Tr.register(IdentityAssertionLoginModule.class, null, "com.ibm.ejs.resources.security");

    public IdentityAssertionLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "IdentityAssertionLoginModule()");
            Tr.exit(tc, "IdentityAssertionLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler == null ? "null" : callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check");
                Tr.debug(tc, "Expecting : " + IDENTITY_ASSERTION_INITIALIZE.toString());
            }
            sm.checkPermission(IDENTITY_ASSERTION_INITIALIZE);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IdentityAssertionLoginModule");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws WSLoginFailedException {
        Map map;
        SecurityManager sm;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check");
                Tr.debug(tc, "Expecting : " + IDENTITY_ASSERTION_LOGIN.toString());
            }
            sm.checkPermission(IDENTITY_ASSERTION_LOGIN);
        }
        Boolean trust = null;
        Subject login_subject = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String realm = contextManager.getDefaultRealm();
        UserRegistry userRegistry = contextManager.getRegistry(realm);
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "This login module is in a funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if ((map = (Map)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.state")) == null) {
            Tr.error(tc, "security.jaas.IdentityAssertion.state");
            WSLoginFailedException e = new WSLoginFailedException("No Trust information for trust validation.");
            throw e;
        }
        Tr.debug(tc, "We do have state information");
        trust = (Boolean)map.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.trusted");
        if (trust == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing a trust key");
            }
            WSLoginFailedException e = new WSLoginFailedException("No Trust Validator configured for trust validation, identity assertion is disabled.");
            throw e;
        }
        if (!trust.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trust is false");
            }
            WSLoginFailedException e = new WSLoginFailedException("No Trust established for trust validation, identity assertion is disabled.");
            throw e;
        }
        if (trust.booleanValue()) {
            String name2;
            Principal p = (Principal)map.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.principal");
            X509Certificate[] cert = (X509Certificate[])map.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.certificates");
            if (p == null && cert == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No principal or certificate recieved from shared state.");
                }
                Tr.error(tc, "security.jaas.IdentityAssertion.stat");
                WSLoginFailedException e = new WSLoginFailedException("No principal or X509Certificate provided to login new user with.");
                throw e;
            }
            if (p != null) {
                int realmDelimiterIndex;
                name2 = null;
                name2 = p.getName();
                if (name2 != null && (realmDelimiterIndex = name2.lastIndexOf("/")) >= 0) {
                    name2 = name2.substring(realmDelimiterIndex + 1);
                }
                try {
                    login_subject = contextManager.login(realm, name2);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when calling contextManager.login");
                    }
                    WSLoginFailedException le = new WSLoginFailedException(e.getMessage(), (Throwable)e);
                    throw le;
                }
            }
            if (cert != null) {
                if (p != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is a principal and a certificate, the principal will be used.");
                    }
                    Tr.warning(tc, "security.jaas.IdentityAssertion.context");
                } else {
                    try {
                        name2 = userRegistry.mapCertificate(cert);
                        login_subject = contextManager.login(realm, name2);
                    }
                    catch (CertificateMapFailedException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException le = new WSLoginFailedException(e.getMessage(), (Throwable)e);
                        throw le;
                    }
                    catch (CertificateMapNotSupportedException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException le = new WSLoginFailedException(e.getMessage(), (Throwable)e);
                        throw le;
                    }
                    catch (CustomRegistryException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException le = new WSLoginFailedException(e.getMessage(), (Throwable)e);
                        throw le;
                    }
                    catch (RemoteException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException le = new WSLoginFailedException(e.getMessage(), (Throwable)e);
                        throw le;
                    }
                    catch (WSLoginFailedException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when calling contextManager.login");
                        }
                        WSLoginFailedException le = new WSLoginFailedException(e.getMessage(), (Throwable)e);
                        throw le;
                    }
                }
            }
            if (login_subject != null) {
                try {
                    final Subject subjectPriv = login_subject;
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            Set<Principal> principalSet;
                            Set<Object> privateSet;
                            Set<Object> publicSet = subjectPriv.getPublicCredentials();
                            if (publicSet.size() > 0 && !IdentityAssertionLoginModule.this.sharedState.containsValue("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials")) {
                                IdentityAssertionLoginModule.this.sharedState.put("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials", publicSet);
                            }
                            if ((privateSet = subjectPriv.getPrivateCredentials()).size() > 0 && !IdentityAssertionLoginModule.this.sharedState.containsValue("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials")) {
                                IdentityAssertionLoginModule.this.sharedState.put("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials", privateSet);
                            }
                            if ((principalSet = subjectPriv.getPrincipals()).size() > 0 && !IdentityAssertionLoginModule.this.sharedState.containsValue("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials")) {
                                IdentityAssertionLoginModule.this.sharedState.put("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals", principalSet);
                            }
                            return null;
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Context login succeeded and information stored in shared state.  Shared state: " + this.sharedState);
                    }
                }
                catch (PrivilegedActionException e) {
                    contextManager.setRootException((Throwable)e.getException());
                    throw new WSLoginFailedException(e.getException().getMessage(), (Throwable)e.getException());
                }
                this.succeeded = true;
            }
        }
        return this.succeeded;
    }

    public boolean commit() throws WSLoginFailedException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean ret = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            ret = false;
        } else {
            if (!this.commitSucceeded) {
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() {
                                try {
                                    Set principalSet = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals");
                                    if (principalSet != null && principalSet.size() > 0) {
                                        for (Principal principalObject : principalSet) {
                                            if (principalObject == null || IdentityAssertionLoginModule.this.subject.getPrincipals().contains(principalObject)) continue;
                                            IdentityAssertionLoginModule.this.subject.getPrincipals().add(principalObject);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Tr.error(tc, "security.jaas.removePrinException", new Object[]{this.getClass().getName(), e});
                                }
                                try {
                                    Set privateSet = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials");
                                    if (privateSet != null && privateSet.size() > 0) {
                                        for (Object privateObject : privateSet) {
                                            if (privateObject == null || IdentityAssertionLoginModule.this.subject.getPrivateCredentials().contains(privateObject)) continue;
                                            IdentityAssertionLoginModule.this.subject.getPrivateCredentials().add(privateObject);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                                }
                                try {
                                    Set publicSet = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials");
                                    if (publicSet != null && publicSet.size() > 0) {
                                        for (Object publicObject : publicSet) {
                                            if (publicObject == null || IdentityAssertionLoginModule.this.subject.getPublicCredentials().contains(publicObject)) continue;
                                            IdentityAssertionLoginModule.this.subject.getPublicCredentials().add(publicObject);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Tr.error(tc, "security.jaas.removeCredExecption", new Object[]{this.getClass().getName(), e});
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        contextManager.setRootException((Throwable)e.getException());
                        throw new WSLoginFailedException(e.getException().getMessage(), (Throwable)e.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            ret = this.commitSucceeded;
        }
        return ret;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes principals, private credentials, and public credentials from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing the principal set, private credential set, and public credential set from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Set principalSet = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.common.auth.module.IdentityAssertionLoginModule.Principals");
                    if (principalSet != null && principalSet.size() > 0) {
                        for (Object principalObject : principalSet) {
                            if (principalObject == null || !IdentityAssertionLoginModule.this.subject.getPrincipals().contains(principalObject)) continue;
                            IdentityAssertionLoginModule.this.subject.getPrincipals().remove(principalObject);
                        }
                    }
                }
                catch (Exception e) {
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                try {
                    Set privateSet = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.common.auth.module.IdenityAssertionLoginModule.PrivateCredentials");
                    if (privateSet != null && privateSet.size() > 0) {
                        for (Object privateObject : privateSet) {
                            if (privateObject == null || !IdentityAssertionLoginModule.this.subject.getPrivateCredentials().contains(privateObject)) continue;
                            IdentityAssertionLoginModule.this.subject.getPrivateCredentials().remove(privateObject);
                        }
                    }
                }
                catch (Exception e) {
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                try {
                    Set publicSet = (Set)IdentityAssertionLoginModule.this.sharedState.get("com.ibm.wsspi.common.auth.module.IdentityAssertionLoginModule.publicCredentials");
                    if (publicSet != null && publicSet.size() > 0) {
                        for (Object publicObject : publicSet) {
                            if (publicObject == null || !IdentityAssertionLoginModule.this.subject.getPublicCredentials().contains(publicObject)) continue;
                            IdentityAssertionLoginModule.this.subject.getPublicCredentials().remove(publicObject);
                        }
                    }
                }
                catch (Exception e) {
                    Tr.error(tc, "security.jaas.removeCredExecption", new Object[]{this.getClass().getName(), e});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed principals and creds.");
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        Set tempPublicCreds;
        Set tempPrivateCreds;
        Set tempPrincipals;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing principalSet, privateSet and publicSet from the shared state.");
        }
        if ((tempPrincipals = (Set)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.Principals");
        }
        if ((tempPrivateCreds = (Set)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PrivateCredentials");
        }
        if ((tempPublicCreds = (Set)this.sharedState.get("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials")) != null) {
            this.sharedState.remove("com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.PublicCredentials");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }
}

