/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.exception.WsRuntimeFwException;
import com.ibm.ws.runtime.component.ThreadContextHelper;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.Join;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.runtime.component.AsynchronousInitializer;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class WsComponentImpl
implements WsComponent {
    private static final TraceComponent tc = Tr.register(WsComponentImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected String name;
    protected String state;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean inhibitMultiThreadedBehavior = inhibtMultiThreadedBehaviorGlobally;
    private static boolean inhibtMultiThreadedBehaviorGlobally = false;
    private Join join = null;
    private WsException latchedAsynchronousException = null;
    private static ThreadPool initializers = null;
    private ThreadContextHelper threadContextHelper = null;

    protected WsComponentImpl() {
    }

    public void initialize(Object config) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        this.latchedAsynchronousException = null;
    }

    public void destroy() {
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.latchedAsynchronousException = null;
    }

    public void stop() {
    }

    public static void _setStartupThreadPool(ThreadPool threadPool) {
        initializers = threadPool;
    }

    public static void setGlobalAsynchBehaviorInhibited(boolean b) {
        inhibtMultiThreadedBehaviorGlobally = b;
    }

    public void inhibitAsynchBehavior() {
        this.inhibitMultiThreadedBehavior = true;
    }

    public final void runAsynchronousInitializer(AsynchronousInitializer initializer) throws WsRuntimeFwException {
        this.runAsynchronousInitializer(initializer, true);
    }

    protected final void runAsynchronousInitializer(AsynchronousInitializer initializer, boolean joinFlag) throws WsRuntimeFwException {
        if (this.inhibitMultiThreadedBehavior || initializers == null) {
            initializer.run();
            return;
        }
        try {
            if (joinFlag) {
                if (this.join == null) {
                    this.join = new Join();
                }
                this.join.increment();
            }
            _AsynchInitializer task = new _AsynchInitializer(initializer, joinFlag);
            initializers.execute(task);
        }
        catch (InterruptedException e) {
            Manager.Ffdc.log(e, this, WsComponentImpl.class.getName(), "223");
        }
    }

    protected final void join() throws ConfigurationWarning, ConfigurationError, ComponentDisabledException, RuntimeWarning, RuntimeError {
        if (this.join == null) {
            return;
        }
        this.join.join();
        if (this.latchedAsynchronousException != null) {
            if (this.latchedAsynchronousException instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof ConfigurationError) {
                throw (ConfigurationError)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof ComponentDisabledException) {
                throw (ComponentDisabledException)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof RuntimeWarning) {
                throw (RuntimeWarning)this.latchedAsynchronousException;
            }
            if (this.latchedAsynchronousException instanceof RuntimeError) {
                throw (RuntimeError)this.latchedAsynchronousException;
            }
            Manager.Ffdc.log(this.latchedAsynchronousException, this, WsComponentImpl.class.getName(), "260");
            throw new RuntimeWarning("unexpected asynchronous exception: " + this.latchedAsynchronousException);
        }
    }

    private int exceptionRank(WsException exception) {
        if (exception instanceof ConfigurationWarning) {
            return 0;
        }
        if (exception instanceof ConfigurationError) {
            return 2;
        }
        if (exception instanceof ComponentDisabledException) {
            return 1;
        }
        if (exception instanceof RuntimeWarning) {
            return 3;
        }
        if (exception instanceof RuntimeError) {
            return 4;
        }
        Manager.Ffdc.log(this.latchedAsynchronousException, this, WsComponentImpl.class.getName(), "286");
        return -1;
    }

    private void latchAsychronousException(WsException exception) {
        Manager.Ffdc.log(exception, this, WsComponentImpl.class.getName(), "297");
        if (this.latchedAsynchronousException != null) {
            if (this.exceptionRank(exception) > this.exceptionRank(this.latchedAsynchronousException)) {
                this.latchedAsynchronousException = exception;
            }
        } else {
            this.latchedAsynchronousException = exception;
        }
    }

    private ThreadContextHelper getThreadContextHelper() {
        if (this.threadContextHelper == null) {
            this.threadContextHelper = (ThreadContextHelper)ImplFactory.loadImplFromKey(ThreadContextHelper.class);
        }
        return this.threadContextHelper;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name2) {
        this.name = name2;
    }

    public String getState() {
        return this.state;
    }

    protected void setState(String newState) throws RuntimeError, RuntimeWarning, ConfigurationError, ConfigurationWarning {
        String oldValue = this.getState();
        this.state = newState;
        this.getPropertyChangeSupport().firePropertyChange("state", oldValue, this.state);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, propertyChangeListener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.getPropertyChangeSupport().firePropertyChange(evt);
    }

    protected String expandVariable(String string) throws IllegalArgumentException {
        return VariableMapFactory.getVariableMap().expand(string);
    }

    protected String getConfigId(Object object) {
        try {
            MBeanFactory factory = AdminServiceFactory.getMBeanFactory();
            if (factory != null) {
                return factory.getConfigId(object);
            }
        }
        catch (AdminException e) {
            Manager.Ffdc.log(e, this, WsComponentImpl.class.getName(), "499");
        }
        return null;
    }

    protected void registerMBean(String type, RuntimeCollaborator collab, String name2, String id, Properties props) {
        MBeanFactory mbeanFactory;
        if (name2 != null) {
            if (props == null) {
                props = new Properties();
            }
            props.put("name", name2);
        }
        if ((mbeanFactory = AdminServiceFactory.getMBeanFactory()) != null) {
            try {
                mbeanFactory.activateMBean(type, collab, id, null, props);
            }
            catch (AdminException x) {
                Tr.service(tc, "WSVR0400W", new Object[]{name2, x});
            }
        }
    }

    protected void deregisterMBean(String id) {
        try {
            AdminServiceFactory.getMBeanFactory().deactivateMBean(id);
        }
        catch (AdminException e) {
            Tr.service(tc, "WSVR0401W", new Object[]{this.name, e});
        }
    }

    protected void deregisterMBean(Object obj) {
        this.deregisterMBean(this.getConfigId(obj));
    }

    protected void deregisterMBeanViaQuery(String query) {
        Set mbeans = this.lookupMBeans(query);
        if (mbeans != null) {
            for (ObjectName objectName : mbeans) {
                try {
                    AdminServiceFactory.getMBeanFactory().deactivateMBean(objectName);
                }
                catch (AdminException e) {
                    Tr.service(tc, "WSVR0401W", new Object[]{this.name, e});
                }
            }
        }
    }

    protected Set lookupMBeans(String name2) {
        try {
            ObjectName oName = new ObjectName(name2);
            Server server2 = WsServiceRegistry.getService(this, Server.class);
            Hashtable<String, String> table = oName.getKeyPropertyList();
            String domain = oName.getDomain();
            table.put("node", server2.getNodeName());
            table.put("process", server2.getName());
            oName = new ObjectName(domain, table);
            String oNameStr = oName.toString();
            oNameStr = oNameStr + ",*";
            oName = new ObjectName(oNameStr);
            return AdminServiceFactory.getMBeanFactory().getMBeanServer().queryNames(oName, null);
        }
        catch (MalformedObjectNameException e) {
            Tr.service(tc, "WSVR0402W", new Object[]{name2, e});
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, WsComponentImpl.class.getName(), "630");
            return null;
        }
    }

    private class _AsynchInitializer
    implements Runnable {
        final AsynchronousInitializer task;
        final boolean joinFlag;

        _AsynchInitializer(AsynchronousInitializer task, boolean joinFlag) {
            this.task = task;
            this.joinFlag = joinFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                WsComponentImpl.this.getThreadContextHelper().establishCredentials();
                this.task.run();
            }
            catch (ConfigurationWarning e) {
                WsComponentImpl.this.latchAsychronousException(e);
            }
            catch (ConfigurationError e) {
                WsComponentImpl.this.latchAsychronousException(e);
            }
            catch (RuntimeWarning e) {
                WsComponentImpl.this.latchAsychronousException(e);
            }
            catch (RuntimeError e) {
                WsComponentImpl.this.latchAsychronousException(e);
            }
            catch (Throwable e) {
                Manager.Ffdc.log(e, this, WsComponentImpl.class.getName(), "350");
                WsComponentImpl.this.latchAsychronousException(new RuntimeWarning(e));
            }
            finally {
                if (this.joinFlag) {
                    WsComponentImpl.this.join.decrement();
                }
            }
        }
    }
}

