/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LocalCellRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(LocalCellRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final String localCellName = (String)ProcessProperties.getInstance().get("key.containing.cellname");

    public void subset(List identities, StringBuffer reason) {
        super.subset(identities, reason);
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            DescriptionKey element = (DescriptionKey)iter.next();
            ClusterMemberDescription cms = (ClusterMemberDescription)descMgr.getDescription(element);
            if (!((ClusterMemberDescription.Memento)cms.getMemento()).isLeaf()) continue;
            Map properties = element.getProperties();
            String cellName = (String)properties.get("CELLNAME");
            if (cellName == null && (cellName = (String)properties.get("cellName")) == null) {
                cellName = (String)properties.get("CellName");
            }
            if (cellName == null || cellName.equals(this.localCellName)) continue;
            iter.remove();
            reason.append(element);
            reason.append(" removed: Member is not cell local ");
            reason.append(cellName);
            reason.append(' ');
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.5 ");
        }
    }
}

