/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultRule
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(DefaultRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected static final DescriptionManager descMgr;
    private Set<RuleArbitrator> unModifiableArbitratorSet = new HashSet<RuleArbitrator>();
    protected Set<RuleArbitrator> arbitrators = new HashSet<RuleArbitrator>();
    protected final Object arbitratorMutex = new Object();

    public void subset(List identities, StringBuffer reason) {
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            DescriptionKey element = (DescriptionKey)iter.next();
            Description member = descMgr.getDescription(element);
            if (member != null) continue;
            iter.remove();
            reason.append(element + " removed: Did not contain any member information. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        if (coordinator == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "registerRuleArbitrator: coordinator is null");
            }
            return;
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "registerRuleArbitrator: for " + this + "coordinator is ", coordinator);
        }
        Object object = this.arbitratorMutex;
        synchronized (object) {
            this.arbitrators.add(coordinator);
            this.unModifiableArbitratorSet = Collections.unmodifiableSet((Set)((HashSet)this.arbitrators).clone());
        }
    }

    public void registerNotificationType(Identity instance, String notificationType) {
        Set<RuleArbitrator> local_arbitrators = this.unModifiableArbitratorSet;
        for (RuleArbitrator ruleArbitrator : local_arbitrators) {
            ruleArbitrator.registerNotificationType(this, instance, notificationType);
        }
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearArbitrators(RuleArbitrator[] arbitratorArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rule arbitrator being cleared", arbitratorArray.length);
        }
        Object object = this.arbitratorMutex;
        synchronized (object) {
            for (RuleArbitrator ruleArbitrator : arbitratorArray) {
                this.arbitrators.remove(ruleArbitrator);
            }
            this.unModifiableArbitratorSet = Collections.unmodifiableSet((Set)((HashSet)this.arbitrators).clone());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName() + '@' + System.identityHashCode(this));
        result.append("[ arbitrator length is:");
        result.append(this.arbitrators.size());
        result.append(":unModifiableArbitratorSet length is:");
        result.append(this.unModifiableArbitratorSet.size());
        result.append("}]");
        return result.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.21 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }
}

