/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(AttributeRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final Map scmdDistinction = new HashMap(1);
    private Map selectionDescriptions = new HashMap();
    private final Set attributes;

    public AttributeRule(Set attributeSet) {
        this.attributes = attributeSet;
    }

    public void subset(List identities, StringBuffer reason) {
        if (this.attributes != null) {
            Iterator iter = identities.iterator();
            while (iter.hasNext()) {
                DescriptionKey memberIdentity = (DescriptionKey)iter.next();
                this.registerNotificationType(memberIdentity, "type.add.extrinsic");
                this.registerNotificationType(memberIdentity, "type.remove.extrinsic");
                SelectionClusterMemberDescription scmd = (SelectionClusterMemberDescription)this.selectionDescriptions.get(memberIdentity);
                if (scmd == null) {
                    DescriptionKey scmdKey = keyRepository.getDescriptionKey(memberIdentity, scmdDistinction);
                    scmd = (SelectionClusterMemberDescription)descMgr.getDescription(scmdKey);
                    this.selectionDescriptions.put(memberIdentity, scmd);
                }
                if (scmd == null) {
                    iter.remove();
                    reason.append(memberIdentity);
                    reason.append(" removed: Lack of attribute container. ");
                    continue;
                }
                this.registerNotificationType(scmd.getKey(), "type.attribute.added");
                this.registerNotificationType(scmd.getKey(), "type.attribute.removed");
                Set memberAttributes = ((SelectionClusterMemberDescription.Memento)scmd.getMemento()).getAttributes();
                if (memberAttributes.containsAll(this.attributes)) continue;
                iter.remove();
                reason.append(memberIdentity);
                reason.append(" removed: Lack of matching attributes ");
                reason.append(memberAttributes);
                reason.append(' ');
            }
        }
    }

    public String toString() {
        return super.toString() + this.attributes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeRule)) {
            return false;
        }
        return ((Object)this.attributes).equals(((AttributeRule)object).attributes);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

