/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.TreeMap;

public class CFEndPointUtility {
    private static final TraceComponent tc = Tr.register(CFEndPointUtility.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ClusterService ivClusterService = ClusterServiceFactory.getClusterService();
    private ClusterManagement ivClusterManagement = ClusterManagementFactory.getNonDistributedClusterManagement();

    public Identity mapCFEndPointToIdentity(CFEndPoint cfep, String cellName, String nodeName, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCFEndPointToIdentity", new Object[]{cfep, cellName, nodeName, serverName});
        }
        if (cfep == null) {
            throw new IllegalArgumentException("The passed argument 'CFEndPoint cfep' cannot be null");
        }
        Identity endpointIdentity = null;
        TreeMap<String, String> endPointDistinction = new TreeMap<String, String>();
        endPointDistinction.put("NAME", cfep.getName());
        endPointDistinction.put("CELL", cellName);
        if (nodeName != null) {
            endPointDistinction.put("NODE", nodeName);
        }
        if (serverName != null) {
            endPointDistinction.put("SERVER", serverName);
        }
        endPointDistinction.put("TYPE", "CHANNEL");
        endPointDistinction.put("COMPONENT", "CF");
        endpointIdentity = this.ivClusterService.getIdentity(endPointDistinction);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCFEndPointToIdentity", endpointIdentity);
        }
        return endpointIdentity;
    }

    public void addCFEndPointToMember(Identity memberId, CFEndPoint cfep, String cellName, String nodeName, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCFEndPointToMember", new Object[]{memberId, cfep, cellName, nodeName, serverName});
        }
        byte[] endPointData = null;
        Identity endpointIdentity = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeByte(0);
            oos.writeObject(cfep);
            endPointData = baos.toByteArray();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.proxy.wlm.StaticClusterManagement.addCFEndPointToMember", "202", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected: When attemping to add endpoint to cluster member " + memberId + " received unexpected exception " + e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addCFEndPointToMember", "no endpoint added");
            }
            return;
        }
        endpointIdentity = this.mapCFEndPointToIdentity(cfep, cellName, nodeName, serverName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Define member scope data ", memberId);
        }
        try {
            this.ivClusterManagement.defineMemberScopedData(memberId, endpointIdentity, endPointData);
        }
        catch (NoMemberAvailableException e3) {
            FFDCFilter.processException((Throwable)((Object)e3), "com.ibm.ws.proxy.wlm.StaticClusterManagement.addCFEndPointToMember", "223", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected: When adding endpoint to cluster member " + memberId + " received unexpected exception " + (Object)((Object)e3));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addCFEndPointToMember", "no endpoint added");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCFEndPointToMember", "endpoint: " + endpointIdentity + " added to member: " + memberId);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2");
        }
    }
}

