/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.binders;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.MetadataImpl;
import com.ibm.ws.wsaddressing.binders.AttributedQNameBinder;
import com.ibm.ws.wsaddressing.binders.BinderHelper;
import com.ibm.ws.wsaddressing.binders.ServiceNameTypeBinder;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedQName;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.ServiceName;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Node;

public class MetadataBinder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MetadataBinder.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private AttributedQNameBinder _attributedQNameBinder = new AttributedQNameBinder();
    private ServiceNameTypeBinder _serviceNameTypeBinder = new ServiceNameTypeBinder();
    private BinderHelper _binderHelper = new BinderHelper();

    public QName getQName() {
        return new QName("http://www.w3.org/2005/08/addressing", "Metadata");
    }

    public String getJavaName() {
        return "com.ibm.wsspi.wsaddressing.Metadata";
    }

    public javax.xml.soap.SOAPElement serialize(Object data, javax.xml.soap.SOAPElement rootNode, NamespaceData namespaceData) throws SOAPException {
        ServiceName serviceName;
        AttributedQName interfaceName;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{data, rootNode, namespaceData};
            Tr.entry(TRACE_COMPONENT, "serialize", params);
        }
        this._binderHelper.validateSerializeMethodParameters(data, rootNode, "Metadata", namespaceData);
        if (!(data instanceof Metadata)) {
            throw new SOAPException("Object to be bound passed to MetaDataBinder was of incorrect type. Expected class implementing:[com.ibm.wsspi.wsaddressing.EndpointReference] but was:[" + data.getClass().toString() + "]");
        }
        SOAPFactory sf = ((SOAPElement)rootNode).getSOAPFactory();
        MetadataImpl metadata = (MetadataImpl)data;
        rootNode = this._binderHelper.addAttributesToSOAPElementFromAttributedType(rootNode, metadata);
        String namespace = "http://www.w3.org/2007/05/addressing/metadata";
        if (!metadata.isWsaMetadata1_0()) {
            namespace = "http://www.w3.org/2006/05/addressing/wsdl";
        }
        if ((interfaceName = metadata.getInterfaceName()) != null) {
            javax.xml.soap.SOAPElement interfaceNameElement = sf.createElement(new QName(namespace, namespaceData.getwsawInterfaceName().getLocalName()));
            rootNode.addChildElement(this._attributedQNameBinder.serialize(interfaceName, interfaceNameElement, null));
        }
        if ((serviceName = metadata.getServiceName()) != null) {
            javax.xml.soap.SOAPElement serviceNameTypeElement = sf.createElement(new QName(namespace, namespaceData.getwsawServiceName().getLocalName()));
            rootNode.addChildElement(this._serviceNameTypeBinder.serialize(serviceName, serviceNameTypeElement, namespaceData));
        }
        Iterator<javax.xml.soap.SOAPElement> extensibilityElementsIterator = metadata.getExtensibilityElements();
        javax.xml.soap.SOAPElement extensibilityElement = null;
        while (extensibilityElementsIterator.hasNext()) {
            extensibilityElement = extensibilityElementsIterator.next();
            if (extensibilityElement == null) continue;
            rootNode.addChildElement((javax.xml.soap.SOAPElement)extensibilityElement.cloneNode(true));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serialize");
        }
        return rootNode;
    }

    public Object deserialize(javax.xml.soap.SOAPElement source, NamespaceData namespaceData) throws SOAPException {
        String serviceNamespace;
        Iterator serviceNameElementIterator;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{source, namespaceData};
            Tr.entry(TRACE_COMPONENT, "deserialize", params);
        }
        this._binderHelper.checkForNullSOAPElement(source, "Metadata");
        if (namespaceData == null) {
            String message = "Namespace Data object passed to MetadataBinder was null";
            Tr.error(TRACE_COMPONENT, message);
            throw new SOAPException(message);
        }
        SOAPFactory sf = ((SOAPElement)source).getSOAPFactory();
        MetadataImpl metadata = (MetadataImpl)WSAddressingFactory.createMetadata();
        String interfaceNamespace = "http://www.w3.org/2007/05/addressing/metadata";
        Iterator interfaceNameElementIterator = source.getChildElements(new QName(interfaceNamespace, namespaceData.getwsawInterfaceName().getLocalName()));
        if (!interfaceNameElementIterator.hasNext()) {
            interfaceNamespace = "http://www.w3.org/2006/05/addressing/wsdl";
            interfaceNameElementIterator = source.getChildElements(new QName(interfaceNamespace, namespaceData.getwsawInterfaceName().getLocalName()));
        }
        if (interfaceNameElementIterator.hasNext()) {
            javax.xml.soap.SOAPElement interfaceNameElement = (javax.xml.soap.SOAPElement)interfaceNameElementIterator.next();
            AttributedQName interfaceName = (AttributedQName)this._attributedQNameBinder.deserialize(interfaceNameElement, null);
            metadata.setInterfaceName(interfaceName);
            source.removeChild((Node)interfaceNameElement);
            metadata.setWsaMetadata1_0("http://www.w3.org/2007/05/addressing/metadata".equals(interfaceNamespace));
        }
        if (!(serviceNameElementIterator = source.getChildElements(new QName(serviceNamespace = "http://www.w3.org/2007/05/addressing/metadata", namespaceData.getwsawServiceName().getLocalName()))).hasNext()) {
            serviceNamespace = "http://www.w3.org/2006/05/addressing/wsdl";
            serviceNameElementIterator = source.getChildElements(new QName(serviceNamespace, namespaceData.getwsawServiceName().getLocalName()));
        }
        if (serviceNameElementIterator.hasNext()) {
            javax.xml.soap.SOAPElement serviceNameElement = (javax.xml.soap.SOAPElement)serviceNameElementIterator.next();
            ServiceName serviceName = (ServiceName)this._serviceNameTypeBinder.deserialize(serviceNameElement, namespaceData);
            metadata.setServiceName(serviceName);
            source.removeChild((Node)serviceNameElement);
            metadata.setWsaMetadata1_0("http://www.w3.org/2007/05/addressing/metadata".equals(serviceNamespace));
        }
        metadata = (MetadataImpl)this._binderHelper.addAttributesToAttributedTypeFromSOAPElement(source, metadata);
        this._binderHelper.addChildElementsToExtensibleType(sf, source, metadata);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserialize", metadata);
        }
        return metadata;
    }
}

