/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.ExtensibleTypeImpl;
import com.ibm.ws.wsaddressing.HAResource;
import com.ibm.ws.wsaddressing.MetadataImpl;
import com.ibm.ws.wsaddressing.PersistableSOAPElement;
import com.ibm.ws.wsaddressing.ReferenceParameterHolder;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.component.WSAddressingBaseServiceImpl;
import com.ibm.ws.wsaddressing.integration.EndpointReference;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.URI;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class EndpointReferenceImpl
extends ExtensibleTypeImpl
implements EndpointReference {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("_address", AttributedURI.class), new ObjectStreamField("_metadata", Metadata.class), new ObjectStreamField("_referenceParameters", ArrayList.class), new ObjectStreamField("_namespaceData", NamespaceData.class)};
    private static final long serialVersionUID = 8878788329037319531L;
    private AttributedURI _address;
    private Metadata _metadata;
    private NamespaceData _namespaceData;
    protected ReferenceParameterHolder rpHolder = new ReferenceParameterHolder();

    private EndpointReferenceImpl() {
    }

    public EndpointReferenceImpl(AttributedURI address) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EndpointReferenceImpl", address);
        }
        this._address = address;
        this._namespaceData = NamespaceData.getDefaultNamespaceInstance();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EndpointReferenceImpl");
        }
    }

    public AttributedURI getAddress() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getAddress", this._address);
        }
        return this._address;
    }

    public void setAddress(AttributedURI address) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setAddress", address);
        }
        this._address = address == null ? WSAddressingFactory.createAttributedURI(this._namespaceData.getAnonymousURI()) : address;
        this.removeAllRoutingInformation();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setAddress");
        }
    }

    public Metadata getMetadata() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getMetadata", this._metadata);
        }
        return this._metadata;
    }

    public void setMetadata(Metadata metadata) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMetadata", metadata);
        }
        this._metadata = metadata;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMetadata");
        }
    }

    public boolean setAffinity(HAResource highlyAvailableObject) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setAffinity", highlyAvailableObject);
        }
        boolean isHighlyAvailable = this.addHARoutingInformation(highlyAvailableObject);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setAffinity", isHighlyAvailable);
        }
        return isHighlyAvailable;
    }

    public boolean setSFSBAffinity(Remote statefulSessionBean) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setSFSBAffinity", statefulSessionBean);
        }
        boolean isHighlyAvailable = this.addHARoutingInformation(statefulSessionBean);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setSFSBAffinity", isHighlyAvailable);
        }
        return isHighlyAvailable;
    }

    public void setVirtualHostName(String virtualHostName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setVirtualHostName", virtualHostName);
        }
        if (virtualHostName != null) {
            try {
                this.setReferenceParameter(Constants.VIRTUAL_HOST_QNAME, virtualHostName);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "setVirtualHostName", "Unable to add VirtualHostName ReferenceParameter :" + e);
                }
                FFDCFilter.processException(e, this.getClass() + ".setVirtualHostName", "1:285:1.90");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setVirtualHostName");
        }
    }

    public boolean isIntermediaryPresent() {
        String intermediaryPresentString;
        boolean result;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isIntermediaryPresent");
        }
        boolean bl = result = (intermediaryPresentString = this.getReferenceParameter(Constants.INTERMEDIARY_PRESENT_QNAME)) != null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isIntermediaryPresent", result);
        }
        return result;
    }

    public void addIntermediaryPresent() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addIntermediaryPresent");
        }
        try {
            this.setReferenceParameter(Constants.INTERMEDIARY_PRESENT_QNAME, "1");
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "setIntermediaryPresentReferenceParameter", "Unable to add Intermediary ReferenceParameter :" + e);
            }
            FFDCFilter.processException(e, "EndpointReferenceImpl", "1:326:1.90");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addIntermediaryPresent");
        }
    }

    private void removeAllRoutingInformation() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeAllRoutingInformation");
        }
        this.rpHolder.removeAll(Constants.ROUTING_INFORMATION_QNAME);
        this.rpHolder.removeAll(Constants.VIRTUAL_HOST_QNAME);
        this.rpHolder.removeAll(Constants.INTERMEDIARY_PRESENT_QNAME);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeAllRoutingInformation");
        }
    }

    private void addRoutingInformation(QName qname, String keyClusterIDValue) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addRoutingInformation", new Object[]{qname, keyClusterIDValue});
        }
        SOAPElement se = null;
        try {
            SOAPFactory sf = new SOAPFactory();
            se = sf.createElement(qname);
            se.addTextNode(keyClusterIDValue);
        }
        catch (SOAPException e1) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addRoutingInformation", (Object)e1);
            }
            throw new ReferenceParameterCreationException(e1);
        }
        if (se != null) {
            this.setReferenceParameter(Constants.ROUTING_INFORMATION_QNAME, se);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addRoutingInformation");
        }
    }

    private void addFragileRoutingInformation() throws ReferenceParameterCreationException {
        String fragileID;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addFragileRoutingInformation", new Object[0]);
        }
        if ((fragileID = WSAddressingBaseServiceImpl.getInstance().getFragileIdentity()) == null) {
            fragileID = "Fragile";
        }
        this.addRoutingInformation(Constants.FRAGILE_ROUTING_KEY, fragileID);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addFragileRoutingInformation");
        }
    }

    public void addWLMRoutingInformation(String wlmId) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addWLMRoutingInformation", new Object[]{wlmId});
        }
        try {
            if (wlmId == null) {
                this.addFragileRoutingInformation();
            } else {
                this.addRoutingInformation(Constants.WLM_ROUTING_KEY, wlmId);
            }
        }
        catch (ReferenceParameterCreationException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".addWLMRoutingInformation", "1:396:1.90", new Object[]{wlmId});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addWLMRoutingInformation");
        }
    }

    public boolean addHARoutingInformation(Object haSupportedObject) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addHARoutingInformation", new Object[]{haSupportedObject});
        }
        boolean isHighlyAvailable = false;
        String affinityKey = WSAddressingBaseServiceImpl.getInstance().getHAIdentity(haSupportedObject);
        try {
            if (affinityKey != null) {
                this.addRoutingInformation(Constants.AFFINITY_ROUTING_KEY, affinityKey);
                isHighlyAvailable = true;
            } else {
                this.addFragileRoutingInformation();
            }
        }
        catch (ReferenceParameterCreationException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".addHARoutingInformation", "1:420:1.90", new Object[]{haSupportedObject});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addHARoutingInformation", isHighlyAvailable);
        }
        return isHighlyAvailable;
    }

    public SOAPElement getSOAPElement(SOAPElement rootNode) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElement");
        }
        SOAPElement soapElement = null;
        EndpointReferenceTypeBinder endpointReferenceCustomBinder = new EndpointReferenceTypeBinder();
        try {
            soapElement = endpointReferenceCustomBinder.serialize(this, rootNode, null);
        }
        catch (SOAPException e) {
            FFDCFilter.processException(e, this.getClass().getName() + ".getSOAPElement", "1:449:1.90");
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.error(TRACE_COMPONENT, "SOAPException thrown during the serialization of the EPR");
            }
            throw e;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElement", soapElement);
        }
        return soapElement;
    }

    public boolean validate() {
        String uriValue;
        URI uri;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "validate");
        }
        if (this._address != null && (uri = this._address.getURI()) != null && (uriValue = uri.toString()) != null && !uriValue.equals("")) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "validate");
        }
        return false;
    }

    public boolean isAnonymousURI() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isAnonymousURI", this);
        }
        if (this._address != null && this._namespaceData.getAnonymousURI().compareTo(this._address.getURI()) == 0) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "isAnonymousURI", "TRUE");
            }
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isAnonymousURI", "FALSE");
        }
        return false;
    }

    public boolean isNoneURI() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isNoneURI", this);
        }
        if (this._address != null) {
            URI noneURI;
            try {
                noneURI = this._namespaceData.getNoneURI();
            }
            catch (NamespaceNotSupportedException e) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "NamespaceData threw NamespaceNotSupportedException [" + e + "]");
                    Tr.exit(TRACE_COMPONENT, "isNoneURI", "FALSE");
                }
                return false;
            }
            if (noneURI.compareTo(this._address.getURI()) == 0) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "isNoneURI", "TRUE");
                }
                return true;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isNoneURI", "FALSE");
        }
        return false;
    }

    public void setNamespace(String namespace) throws NamespaceNotSupportedException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setNamespaceDate", namespace);
        }
        this._namespaceData = NamespaceData.getInstance(namespace);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setNamespaceDate");
        }
    }

    public String getNamespace() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNamespace");
        }
        String result = null;
        if (this._namespaceData != null) {
            result = this._namespaceData.getNamespace();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNamespace", result);
        }
        return result;
    }

    public NamespaceData getNamespaceData() {
        return this._namespaceData;
    }

    public Iterator getReferenceParameters() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameters");
        }
        Iterator<PersistableSOAPElement> result = this.rpHolder.getReferenceParameters();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameters", result);
        }
        return result;
    }

    public String getReferenceParameter(QName referenceParameterName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameter", new Object[]{referenceParameterName});
        }
        String result = this.rpHolder.getReferenceParameter(referenceParameterName);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameter", result);
        }
        return result;
    }

    public SOAPElement getSOAPElementReferenceParameter(QName referenceParameterName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameter", referenceParameterName);
        }
        SOAPElement result = this.rpHolder.getSOAPElementReferenceParameter(referenceParameterName);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameter", result);
        }
        return result;
    }

    public void setReferenceParameter(QName name2, SOAPElement value2) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setReferenceParameter", new Object[]{name2, value2});
        }
        this.rpHolder.setReferenceParameter(name2, value2);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setReferenceParameter");
        }
    }

    public void setReferenceParameter(QName name2, String value2) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setReferenceParameter", new Object[]{name2, value2});
        }
        this.rpHolder.setReferenceParameter(name2, value2);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setReferenceParameter");
        }
    }

    public void addReferenceParameter(PersistableSOAPElement referenceParameter) {
        this.rpHolder.addReferenceParameter(referenceParameter);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameter");
        }
    }

    public String toString() {
        List<PersistableSOAPElement> extensibilityElements;
        String string = "";
        if (this._namespaceData != null) {
            string = "Namespace[" + this._namespaceData.getNamespace() + "]";
        }
        if (this._address != null) {
            string = "Address[" + this._address.toString() + "]";
        }
        if (this.rpHolder != null) {
            string = string + ", ";
            string = string + this.rpHolder;
        }
        if (this._metadata != null) {
            string = string + ", ";
            string = string + "MetaData[" + this._metadata.toString() + "]";
        }
        if ((extensibilityElements = this.getExtensibilityElementList()) != null && !extensibilityElements.isEmpty()) {
            string = string + ", ";
            string = string + "ExtensibilityElements[" + extensibilityElements.toString() + "]";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "equals", object);
        }
        boolean equals = true;
        if (object == null) {
            return false;
        }
        if (object instanceof EndpointReferenceImpl) {
            EndpointReferenceImpl passedEPR = (EndpointReferenceImpl)object;
            if (this.getNamespace() != null) {
                equals = equals && this.getNamespace().equals(passedEPR.getNamespace());
            } else {
                boolean bl = equals = equals && passedEPR.getNamespace() == null;
            }
            if (this.getAddress() != null) {
                equals = equals && this.getAddress().equals(passedEPR.getAddress());
            } else {
                boolean bl = equals = equals && passedEPR.getAddress() == null;
            }
            if (!equals) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "equals", "FALSE");
                }
                return false;
            }
            if (this.getMetadata() != null) {
                equals = equals && this.getMetadata().equals(passedEPR.getMetadata());
            } else {
                boolean bl = equals = equals && passedEPR.getMetadata() == null;
            }
            if (!equals) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "equals", "FALSE");
                }
                return false;
            }
            equals = this.rpHolder.equals(passedEPR.rpHolder);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "equals", Boolean.toString(equals));
            }
            return equals;
        }
        if (object instanceof EndpointReference) {
            boolean result = object.equals(this);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "equals", result);
            }
            return result;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "equals", "FALSE");
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
        result = 31 * result + (this._metadata == null ? 0 : this._metadata.hashCode());
        result = 31 * result + (this._namespaceData == null ? 0 : this._namespaceData.hashCode());
        result = 31 * result + (this.rpHolder == null ? 0 : this.rpHolder.hashCode());
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        EndpointReferenceImpl endpointReference = (EndpointReferenceImpl)super.clone();
        if (this._address != null) {
            AttributedURI address = (AttributedURI)this._address.clone();
            endpointReference.setAddress(address);
        }
        if (this._metadata != null) {
            Metadata metadata = (Metadata)((MetadataImpl)this._metadata).clone();
            endpointReference.setMetadata(metadata);
        }
        endpointReference._namespaceData = this._namespaceData;
        if (this.rpHolder != null) {
            endpointReference.rpHolder = (ReferenceParameterHolder)this.rpHolder.clone();
        }
        return endpointReference;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readObject", in);
        }
        ObjectInputStream.GetField fields = null;
        try {
            fields = in.readFields();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        List parameters = null;
        this.rpHolder = new ReferenceParameterHolder();
        this._address = (AttributedURI)fields.get("_address", null);
        this._metadata = (Metadata)fields.get("_metadata", null);
        parameters = (List)fields.get("_referenceParameters", null);
        this._namespaceData = (NamespaceData)fields.get("_namespaceData", null);
        if (parameters != null) {
            for (Object parameter2 : parameters) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "serialized refParam", parameter2);
                }
                this.rpHolder.addReferenceParameter((PersistableSOAPElement)parameter2);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readObject");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writeObject", new Object[]{out});
        }
        ArrayList<PersistableSOAPElement> parameters = new ArrayList<PersistableSOAPElement>();
        Iterator<PersistableSOAPElement> it = this.rpHolder.getReferenceParameters();
        while (it.hasNext()) {
            PersistableSOAPElement parameter2 = it.next();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "refParam", parameter2);
            }
            if (parameter2 == null) continue;
            parameters.add(parameter2);
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("_address", this._address);
        fields.put("_metadata", this._metadata);
        fields.put("_referenceParameters", parameters.isEmpty() ? null : parameters);
        fields.put("_namespaceData", this._namespaceData);
        out.writeFields();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writeObject");
        }
    }
}

