/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.xml;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.xml.Factory;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BaseType
implements Serializable {
    private static final TraceComponent _tc = Tr.register(BaseType.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    protected Factory factory;
    protected Element xmlElement;
    protected Attr xmlAttr;
    protected SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected void setFactory(Factory factory) {
        this.factory = factory;
    }

    protected void setXMLElement(Element element) {
        this.xmlElement = element;
    }

    public Element getXMLElement() {
        return this.xmlElement;
    }

    protected void setXMLAttribute(Attr xmlAttr) {
        this.xmlAttr = xmlAttr;
    }

    public Attr getXMLAttribute() {
        return this.xmlAttr;
    }

    public void setElementValue(String elementName, String elementValue) {
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        if (nodes.getLength() == 0) {
            Element elementNode = this.factory.createXMLElementAndText(elementName, elementValue);
            this.xmlElement.appendChild(elementNode);
        } else {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String item = node.getNodeName().trim();
                if (!item.equals(elementName)) continue;
                Node textNode = node.getFirstChild();
                if (!(textNode instanceof Text)) break;
                ((Text)textNode).setNodeValue(elementValue);
                break;
            }
        }
    }

    public void setElementValue(String elementName, boolean value2) {
        this.setElementValue(elementName, new Boolean(value2).toString());
    }

    public void setElementValue(String elementName, int value2) {
        this.setElementValue(elementName, new Integer(value2).toString());
    }

    public void setElementValue(String elementName, float value2) {
        this.setElementValue(elementName, new Float(value2).toString());
    }

    public void setElementValue(String elementName, double value2) {
        this.setElementValue(elementName, new Double(value2).toString());
    }

    public void setElementValue(String elementName, long value2) {
        this.setElementValue(elementName, new Long(value2).toString());
    }

    public void setElementValue(String elementName, short value2) {
        this.setElementValue(elementName, new Short(value2).toString());
    }

    public void setElementValue(String elementName, byte value2) {
        this.setElementValue(elementName, new Byte(value2).toString());
    }

    public void setElementValue(String elementName, Date value2) {
        this.setElementValue(elementName, this.simpleDateFormat.format(value2));
    }

    public void setElementValue(String elementName, BaseType baseType) {
        Element childXml = baseType.getXMLElement();
        this.xmlElement.appendChild(childXml);
    }

    public String getElementValue() {
        if (this.xmlAttr != null) {
            return this.xmlAttr.getValue();
        }
        String value2 = this.xmlElement.getNodeValue();
        if (value2 != null) {
            return value2;
        }
        for (Node node = this.xmlElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) continue;
            return ((Text)node).getData();
        }
        return null;
    }

    public String getElementValue(String property, int index) {
        NodeList nodes = this.xmlElement.getElementsByTagName(property);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node child;
            Node node = nodes.item(i);
            String item = node.getNodeName().trim();
            if (!item.equals(property) || i != index || !((child = (element = (Element)node).getFirstChild()) instanceof Text)) continue;
            return ((Text)child).getData();
        }
        return null;
    }

    public String getElementValue(String elementName) {
        for (Node node = this.xmlElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element anElement;
            Node child;
            if (!node.getNodeName().equals(elementName) || node.getNodeType() != 1 || !((child = (anElement = (Element)node).getFirstChild()) instanceof Text)) continue;
            return ((Text)child).getData();
        }
        return null;
    }

    public boolean getElementBooleanValue(String elementName) {
        return new Boolean(this.getElementValue(elementName));
    }

    public int getElementIntegerValue(String elementName) {
        return new Integer(this.getElementValue(elementName));
    }

    public float getElementFloatValue(String elementName) {
        return new Float(this.getElementValue(elementName)).floatValue();
    }

    public double getElementDoubleValue(String elementName) {
        return new Double(this.getElementValue(elementName));
    }

    public long getElementLongValue(String elementName) {
        return new Long(this.getElementValue(elementName));
    }

    public short getElementShortValue(String elementName) {
        return new Short(this.getElementValue(elementName));
    }

    public byte getElementByteValue(String elementName) {
        return new Byte(this.getElementValue(elementName));
    }

    public Date getElementDateValue(String elementName) {
        try {
            String result = this.getElementValue(elementName);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.BaseType.getElementDateValue", "333", this);
            Tr.error(_tc, "internal.error", ex);
        }
        return null;
    }

    public BaseType getElementValue(String property, String className) {
        for (Node node = this.xmlElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals(property)) continue;
            return this.factory.newInstance((Element)node, className);
        }
        return null;
    }

    public Object getElementValue(String property, String className, int index) {
        int count = 0;
        for (Node node = this.xmlElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals(property)) continue;
            if (count == index) {
                return this.factory.newInstance((Element)node, className);
            }
            ++count;
        }
        return null;
    }

    public void updateElementValue(String value2) {
        Node textNode = this.xmlElement.getFirstChild();
        if (textNode == null) {
            this.factory.createText(this.xmlElement, value2);
        } else {
            textNode.setNodeValue(value2);
        }
    }

    public void updateElementValue(boolean value2) {
        this.updateElementValue(new Boolean(value2).toString());
    }

    public void updateElementValue(int value2) {
        this.updateElementValue(new Integer(value2).toString());
    }

    public void updateElementValue(float value2) {
        this.updateElementValue(new Float(value2).toString());
    }

    public void updateElementValue(double value2) {
        this.updateElementValue(new Double(value2).toString());
    }

    public void updateElementValue(long value2) {
        this.updateElementValue(new Long(value2).toString());
    }

    public void updateElementValue(short value2) {
        this.updateElementValue(new Short(value2).toString());
    }

    public void updateElementValue(byte value2) {
        this.updateElementValue(new Byte(value2).toString());
    }

    public void updateElementValue(Date value2) {
        this.updateElementValue(this.simpleDateFormat.format(value2));
    }

    public boolean removeElement(String elementName) {
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String item = node.getNodeName().trim();
            if (!item.equals(elementName)) continue;
            try {
                this.xmlElement.removeChild(node);
                return true;
            }
            catch (DOMException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.xml.BaseType.removeElement", "469", this);
            }
        }
        return false;
    }

    public int sizeOfElement(String name2) {
        NodeList nodes = this.xmlElement.getElementsByTagName(name2);
        int len = nodes != null ? nodes.getLength() : 0;
        return len;
    }

    public String getElementName() {
        return this.xmlElement.getNodeName();
    }
}

