/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.FileWriteDenialException;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.toJava.DuplicateFileException;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JavaWriter
implements Generator {
    protected Emitter emitter;
    protected String type;
    private boolean isDeploy = false;

    protected JavaWriter(Emitter emitter, String type) {
        this.emitter = emitter;
        this.type = type;
    }

    public void generate() throws IOException {
        String file = this.getFileName();
        if (this.isFileGenerated(file)) {
            throw new DuplicateFileException(Messages.getMessage("duplicateFile00", file), file);
        }
        GenCriteria useCriteria = file.endsWith(".java") ? this.emitter.getGenJava() : this.emitter.getGenXML();
        if (Utils.fileShouldBeWritten(file, this.emitter.getToolEnv(), useCriteria, this.isDeployPhaseOnlyWriter())) {
            try {
                String msg;
                PrintWriter pw = this.getPrintWriter(file);
                this.registerFile(file);
                if (this.emitter.isVerbose() && (msg = this.verboseMessage(file)) != null) {
                    this.emitter.getToolEnv().report(msg);
                }
                this.writeFileHeader(pw);
                this.writeFileBody(pw);
                this.writeFileFooter(pw);
                this.closePrintWriter(pw);
            }
            catch (FileWriteDenialException e) {
                this.emitter.getToolEnv().report(Messages.getMessage("FileWriteDenied", file));
            }
        }
    }

    protected abstract String getFileName();

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean deployOnly) {
        this.isDeploy = deployOnly;
    }

    protected boolean isFileGenerated(String file) {
        return this.emitter.getGeneratedFileNames().contains(file);
    }

    protected void registerFile(String file) {
        this.emitter.getGeneratedFileInfo().add(file, null, this.type);
    }

    protected String verboseMessage(String file) {
        return Messages.getMessage("generating", file);
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        return this.emitter.getToolEnv().getPrintWriter(filename);
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
    }

    protected abstract void writeFileBody(PrintWriter var1) throws IOException;

    protected void writeFileFooter(PrintWriter pw) throws IOException {
    }

    protected void closePrintWriter(PrintWriter pw) {
        pw.close();
    }

    protected void writeComment(PrintWriter pw, Element element) {
        int LINE_LENGTH = 65;
        if (element == null) {
            return;
        }
        Node child = element.getFirstChild();
        if (child == null) {
            return;
        }
        String comment = child.getNodeValue();
        comment = comment.replace('\r', ' ');
        if ((comment = comment.replace('\n', ' ')) != null) {
            int start = 0;
            pw.println();
            while (start < comment.length()) {
                int end = start + 65;
                if (end > comment.length()) {
                    end = comment.length();
                }
                while (end < comment.length() && !Character.isWhitespace(comment.charAt(end))) {
                    ++end;
                }
                pw.println("     // " + comment.substring(start, end).trim());
                start = end + 1;
            }
        }
    }
}

